
package eu.toop.edm.jaxb.dcatap;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.jaxb.adapter.AdapterLocalDateTime;
import eu.toop.edm.jaxb.dcterms.DCStandardType;
import eu.toop.edm.jaxb.w3.skos.ConceptType;


/**
 * <p>Java class for CatalogRecordType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="CatalogRecordType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element name="CatalogRecord" minOccurs="0"&gt;
 *           &lt;complexType&gt;
 *             &lt;complexContent&gt;
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                 &lt;sequence&gt;
 *                   &lt;element ref="{http://xmlns.com/foaf/0.1/}primaryTopic"/&gt;
 *                   &lt;element ref="{http://purl.org/dc/terms/}modified"/&gt;
 *                   &lt;element ref="{http://purl.org/dc/terms/}conformsTo" minOccurs="0"/&gt;
 *                   &lt;element ref="{http://www.w3.org/ns/adms#}status" minOccurs="0"/&gt;
 *                   &lt;element ref="{http://purl.org/dc/terms/}issued" minOccurs="0"/&gt;
 *                   &lt;element ref="{http://purl.org/dc/terms/}description" minOccurs="0"/&gt;
 *                   &lt;element ref="{http://purl.org/dc/terms/}language" maxOccurs="unbounded"/&gt;
 *                   &lt;element ref="{http://purl.org/dc/terms/}source"/&gt;
 *                   &lt;element ref="{http://purl.org/dc/terms/}title" minOccurs="0"/&gt;
 *                 &lt;/sequence&gt;
 *                 &lt;attribute ref="{http://www.w3.org/1999/02/22-rdf-syntax-ns#}about"/&gt;
 *                 &lt;attribute ref="{http://www.w3.org/1999/02/22-rdf-syntax-ns#}nodeID"/&gt;
 *               &lt;/restriction&gt;
 *             &lt;/complexContent&gt;
 *           &lt;/complexType&gt;
 *         &lt;/element&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CatalogRecordType", propOrder = {
    "catalogRecord"
})
@CodingStyleguideUnaware
public class DCatAPCatalogRecordType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "CatalogRecord")
    private DCatAPCatalogRecordType.CatalogRecord catalogRecord;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public DCatAPCatalogRecordType() {
    }

    /**
     * Gets the value of the catalogRecord property.
     * 
     * @return
     *     possible object is
     *     {@link DCatAPCatalogRecordType.CatalogRecord }
     *     
     */
    @Nullable
    public DCatAPCatalogRecordType.CatalogRecord getCatalogRecord() {
        return catalogRecord;
    }

    /**
     * Sets the value of the catalogRecord property.
     * 
     * @param value
     *     allowed object is
     *     {@link DCatAPCatalogRecordType.CatalogRecord }
     *     
     */
    public void setCatalogRecord(
        @Nullable
        DCatAPCatalogRecordType.CatalogRecord value) {
        this.catalogRecord = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final DCatAPCatalogRecordType rhs = ((DCatAPCatalogRecordType) o);
        if (!EqualsHelper.equals(catalogRecord, rhs.catalogRecord)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(catalogRecord).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("catalogRecord", catalogRecord).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        DCatAPCatalogRecordType ret) {
        ret.catalogRecord = ((catalogRecord == null)?null:catalogRecord.clone());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public DCatAPCatalogRecordType clone() {
        DCatAPCatalogRecordType ret = new DCatAPCatalogRecordType();
        cloneTo(ret);
        return ret;
    }


    /**
     * <p>Java class for anonymous complex type.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * 
     * <pre>
     * &lt;complexType&gt;
     *   &lt;complexContent&gt;
     *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
     *       &lt;sequence&gt;
     *         &lt;element ref="{http://xmlns.com/foaf/0.1/}primaryTopic"/&gt;
     *         &lt;element ref="{http://purl.org/dc/terms/}modified"/&gt;
     *         &lt;element ref="{http://purl.org/dc/terms/}conformsTo" minOccurs="0"/&gt;
     *         &lt;element ref="{http://www.w3.org/ns/adms#}status" minOccurs="0"/&gt;
     *         &lt;element ref="{http://purl.org/dc/terms/}issued" minOccurs="0"/&gt;
     *         &lt;element ref="{http://purl.org/dc/terms/}description" minOccurs="0"/&gt;
     *         &lt;element ref="{http://purl.org/dc/terms/}language" maxOccurs="unbounded"/&gt;
     *         &lt;element ref="{http://purl.org/dc/terms/}source"/&gt;
     *         &lt;element ref="{http://purl.org/dc/terms/}title" minOccurs="0"/&gt;
     *       &lt;/sequence&gt;
     *       &lt;attribute ref="{http://www.w3.org/1999/02/22-rdf-syntax-ns#}about"/&gt;
     *       &lt;attribute ref="{http://www.w3.org/1999/02/22-rdf-syntax-ns#}nodeID"/&gt;
     *     &lt;/restriction&gt;
     *   &lt;/complexContent&gt;
     * &lt;/complexType&gt;
     * </pre>
     * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
     * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "primaryTopic",
        "modified",
        "conformsTo",
        "status",
        "issued",
        "description",
        "language",
        "source",
        "title"
    })
    @CodingStyleguideUnaware
    public static class CatalogRecord implements Serializable, IExplicitlyCloneable
    {

        @XmlElement(namespace = "http://xmlns.com/foaf/0.1/", required = true)
        private Object primaryTopic;
        @XmlElement(namespace = "http://purl.org/dc/terms/", required = true, type = String.class)
        @XmlJavaTypeAdapter(AdapterLocalDateTime.class)
        @XmlSchemaType(name = "dateTime")
        private LocalDateTime modified;
        @XmlElement(namespace = "http://purl.org/dc/terms/")
        private DCStandardType conformsTo;
        @XmlElement(namespace = "http://www.w3.org/ns/adms#")
        private ConceptType status;
        @XmlElement(namespace = "http://purl.org/dc/terms/", type = String.class)
        @XmlJavaTypeAdapter(AdapterLocalDateTime.class)
        @XmlSchemaType(name = "dateTime")
        private LocalDateTime issued;
        @XmlElement(namespace = "http://purl.org/dc/terms/")
        private String description;
        @XmlElement(namespace = "http://purl.org/dc/terms/", required = true)
        @XmlSchemaType(name = "anyURI")
        private List<String> language;
        @XmlElement(namespace = "http://purl.org/dc/terms/", required = true)
        private ConceptType source;
        @XmlElement(namespace = "http://purl.org/dc/terms/")
        private String title;
        @XmlAttribute(name = "about", namespace = "http://www.w3.org/1999/02/22-rdf-syntax-ns#")
        @XmlSchemaType(name = "anyURI")
        private String about;
        @XmlAttribute(name = "nodeID", namespace = "http://www.w3.org/1999/02/22-rdf-syntax-ns#")
        @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
        @XmlSchemaType(name = "NCName")
        private String nodeID;

        /**
         * Default constructor<br>
         * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
         * 
         */
        public CatalogRecord() {
        }

        /**
         * Gets the value of the primaryTopic property.
         * 
         * @return
         *     possible object is
         *     {@link Object }
         *     
         */
        @Nullable
        public Object getPrimaryTopic() {
            return primaryTopic;
        }

        /**
         * Sets the value of the primaryTopic property.
         * 
         * @param value
         *     allowed object is
         *     {@link Object }
         *     
         */
        public void setPrimaryTopic(
            @Nullable
            Object value) {
            this.primaryTopic = value;
        }

        /**
         * Gets the value of the modified property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        @Nullable
        public LocalDateTime getModified() {
            return modified;
        }

        /**
         * Sets the value of the modified property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setModified(
            @Nullable
            LocalDateTime value) {
            this.modified = value;
        }

        /**
         * Gets the value of the conformsTo property.
         * 
         * @return
         *     possible object is
         *     {@link DCStandardType }
         *     
         */
        @Nullable
        public DCStandardType getConformsTo() {
            return conformsTo;
        }

        /**
         * Sets the value of the conformsTo property.
         * 
         * @param value
         *     allowed object is
         *     {@link DCStandardType }
         *     
         */
        public void setConformsTo(
            @Nullable
            DCStandardType value) {
            this.conformsTo = value;
        }

        /**
         * Gets the value of the status property.
         * 
         * @return
         *     possible object is
         *     {@link ConceptType }
         *     
         */
        @Nullable
        public ConceptType getStatus() {
            return status;
        }

        /**
         * Sets the value of the status property.
         * 
         * @param value
         *     allowed object is
         *     {@link ConceptType }
         *     
         */
        public void setStatus(
            @Nullable
            ConceptType value) {
            this.status = value;
        }

        /**
         * Gets the value of the issued property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        @Nullable
        public LocalDateTime getIssued() {
            return issued;
        }

        /**
         * Sets the value of the issued property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setIssued(
            @Nullable
            LocalDateTime value) {
            this.issued = value;
        }

        /**
         * Gets the value of the description property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        @Nullable
        public String getDescription() {
            return description;
        }

        /**
         * Sets the value of the description property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setDescription(
            @Nullable
            String value) {
            this.description = value;
        }

        /**
         * Gets the value of the language property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the language property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getLanguage().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link String }
         * 
         * 
         */
        @Nonnull
        @ReturnsMutableObject("JAXB implementation style")
        public List<String> getLanguage() {
            if (language == null) {
                language = new ArrayList<String>();
            }
            return this.language;
        }

        /**
         * Gets the value of the source property.
         * 
         * @return
         *     possible object is
         *     {@link ConceptType }
         *     
         */
        @Nullable
        public ConceptType getSource() {
            return source;
        }

        /**
         * Sets the value of the source property.
         * 
         * @param value
         *     allowed object is
         *     {@link ConceptType }
         *     
         */
        public void setSource(
            @Nullable
            ConceptType value) {
            this.source = value;
        }

        /**
         * Gets the value of the title property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        @Nullable
        public String getTitle() {
            return title;
        }

        /**
         * Sets the value of the title property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setTitle(
            @Nullable
            String value) {
            this.title = value;
        }

        /**
         * Gets the value of the about property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        @Nullable
        public String getAbout() {
            return about;
        }

        /**
         * Sets the value of the about property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setAbout(
            @Nullable
            String value) {
            this.about = value;
        }

        /**
         * Gets the value of the nodeID property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        @Nullable
        public String getNodeID() {
            return nodeID;
        }

        /**
         * Sets the value of the nodeID property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setNodeID(
            @Nullable
            String value) {
            this.nodeID = value;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public boolean equals(final Object o) {
            if (o == this) {
                return true;
            }
            if ((o == null)||(!getClass().equals(o.getClass()))) {
                return false;
            }
            final DCatAPCatalogRecordType.CatalogRecord rhs = ((DCatAPCatalogRecordType.CatalogRecord) o);
            if (!EqualsHelper.equals(about, rhs.about)) {
                return false;
            }
            if (!EqualsHelper.equals(conformsTo, rhs.conformsTo)) {
                return false;
            }
            if (!EqualsHelper.equals(description, rhs.description)) {
                return false;
            }
            if (!EqualsHelper.equals(issued, rhs.issued)) {
                return false;
            }
            if (!EqualsHelper.equalsCollection(language, rhs.language)) {
                return false;
            }
            if (!EqualsHelper.equals(modified, rhs.modified)) {
                return false;
            }
            if (!EqualsHelper.equals(nodeID, rhs.nodeID)) {
                return false;
            }
            if (!EqualsHelper.equals(primaryTopic, rhs.primaryTopic)) {
                return false;
            }
            if (!EqualsHelper.equals(source, rhs.source)) {
                return false;
            }
            if (!EqualsHelper.equals(status, rhs.status)) {
                return false;
            }
            if (!EqualsHelper.equals(title, rhs.title)) {
                return false;
            }
            return true;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public int hashCode() {
            return new HashCodeGenerator(this).append(about).append(conformsTo).append(description).append(issued).append(language).append(modified).append(nodeID).append(primaryTopic).append(source).append(status).append(title).getHashCode();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-tostring
         * 
         */
        @Override
        public String toString() {
            return new ToStringGenerator(this).append("about", about).append("conformsTo", conformsTo).append("description", description).append("issued", issued).append("language", language).append("modified", modified).append("nodeID", nodeID).append("primaryTopic", primaryTopic).append("source", source).append("status", status).append("title", title).getToString();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param aList
         *     The new list member to set. May be <code>null</code>.
         */
        public void setLanguage(
            @Nullable
            final List<String> aList) {
            language = aList;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
         */
        public boolean hasLanguageEntries() {
            return (!getLanguage().isEmpty());
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     <code>true</code> if no item is contained, <code>false</code> otherwise.
         */
        public boolean hasNoLanguageEntries() {
            return getLanguage().isEmpty();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     The number of contained elements. Always &ge; 0.
         */
        @Nonnegative
        public int getLanguageCount() {
            return getLanguage().size();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param index
         *     The index to retrieve
         * @return
         *     The element at the specified index. May be <code>null</code>
         * @throws IndexOutOfBoundsException
         *     if the index is invalid!
         */
        @Nullable
        public String getLanguageAtIndex(
            @Nonnegative
            final int index)
            throws IndexOutOfBoundsException
        {
            return getLanguage().get(index);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param elem
         *     The element to be added. May not be <code>null</code>.
         */
        public void addLanguage(
            @Nonnull
            final String elem) {
            getLanguage().add(elem);
        }

        /**
         * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @param ret
         *     The target object to clone to. May not be <code>null</code>.
         */
        public void cloneTo(
            @Nonnull
            DCatAPCatalogRecordType.CatalogRecord ret) {
            ret.about = about;
            ret.conformsTo = ((conformsTo == null)?null:conformsTo.clone());
            ret.description = description;
            ret.issued = issued;
            if (language == null) {
                ret.language = null;
            } else {
                List<String> retLanguage = new ArrayList<String>();
                for (String aItem: getLanguage()) {
                    retLanguage.add(aItem);
                }
                ret.language = retLanguage;
            }
            ret.modified = modified;
            ret.nodeID = nodeID;
            ret.primaryTopic = primaryTopic;
            ret.source = ((source == null)?null:source.clone());
            ret.status = ((status == null)?null:status.clone());
            ret.title = title;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @return
         *     The cloned object. Never <code>null</code>.
         */
        @Nonnull
        @ReturnsMutableCopy
        @Override
        public DCatAPCatalogRecordType.CatalogRecord clone() {
            DCatAPCatalogRecordType.CatalogRecord ret = new DCatAPCatalogRecordType.CatalogRecord();
            cloneTo(ret);
            return ret;
        }

        /**
         * Special setter with value of type String<br>
         * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
         * 
         * @param valueParam
         *     The value to be set. May be <code>null</code>.
         * @return
         *     The created intermediary object of type DCStandardType and never <code>null</code>
         */
        @Nonnull
        public DCStandardType setConformsTo(
            @Nullable
            final String valueParam) {
            DCStandardType aObj = getConformsTo();
            if (aObj == null) {
                aObj = new DCStandardType(valueParam);
                setConformsTo(aObj);
            } else {
                aObj.setValue(valueParam);
            }
            return aObj;
        }

        /**
         * Get the value of the contained DCStandardType object<br>
         * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
         * 
         * @return
         *     Either the value of the contained DCStandardType object or <code>null</code>
         */
        @Nullable
        public String getConformsToValue() {
            DCStandardType aObj = getConformsTo();
            return ((aObj == null)?null:aObj.getValue());
        }

    }

}
