
package eu.toop.edm.jaxb.dcatap;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.jaxb.adapter.AdapterLocalDateTime;
import eu.toop.edm.jaxb.dcterms.DCLicenceDocumentType;
import eu.toop.edm.jaxb.dcterms.DCLocationType;
import eu.toop.edm.jaxb.dcterms.DCRightStatementType;
import eu.toop.edm.jaxb.foaf.FoafAgentType;
import eu.toop.edm.jaxb.foaf.FoafDocumentType;
import eu.toop.edm.jaxb.w3.skos.ConceptSchemeType;


/**
 * <p>Java class for CatalogType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="CatalogType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{http://data.europa.eu/r5r/}dataset" maxOccurs="unbounded"/&gt;
 *         &lt;element ref="{http://purl.org/dc/terms/}description" maxOccurs="unbounded"/&gt;
 *         &lt;element ref="{http://purl.org/dc/terms/}title" maxOccurs="unbounded"/&gt;
 *         &lt;element ref="{http://purl.org/dc/terms/}publisher"/&gt;
 *         &lt;element ref="{http://purl.org/dc/terms/}creator" minOccurs="0"/&gt;
 *         &lt;element ref="{http://data.europa.eu/r5r/}service" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://data.europa.eu/r5r/}catalog" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://data.europa.eu/r5r/}hasPart" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://data.europa.eu/r5r/}isPartOf" minOccurs="0"/&gt;
 *         &lt;element ref="{http://data.europa.eu/r5r/}record" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://purl.org/dc/terms/}rights" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://data.europa.eu/r5r/}qualifiedRelation" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://purl.org/dc/terms/}issued" minOccurs="0"/&gt;
 *         &lt;element ref="{http://purl.org/dc/terms/}modified" minOccurs="0"/&gt;
 *         &lt;element ref="{http://purl.org/dc/terms/}language" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://data.europa.eu/r5r/}themeTaxonomy" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://xmlns.com/foaf/0.1/}homepage" minOccurs="0"/&gt;
 *         &lt;element ref="{http://purl.org/dc/terms/}spatial" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://purl.org/dc/terms/}licence" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CatalogType", propOrder = {
    "dataset",
    "description",
    "title",
    "publisher",
    "creator",
    "service",
    "catalog",
    "hasPart",
    "isPartOf",
    "record",
    "rights",
    "qualifiedRelation",
    "issued",
    "modified",
    "language",
    "themeTaxonomy",
    "homepage",
    "spatial",
    "licence"
})
@CodingStyleguideUnaware
public class DCatAPCatalogType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(required = true)
    private List<DCatAPDatasetType> dataset;
    @XmlElement(namespace = "http://purl.org/dc/terms/", required = true)
    private List<String> description;
    @XmlElement(namespace = "http://purl.org/dc/terms/", required = true)
    private List<String> title;
    @XmlElement(namespace = "http://purl.org/dc/terms/", required = true)
    private FoafAgentType publisher;
    @XmlElement(namespace = "http://purl.org/dc/terms/")
    private FoafAgentType creator;
    private List<DCatAPDataServiceType> service;
    private List<DCatAPCatalogType> catalog;
    private List<DCatAPCatalogType> hasPart;
    private DCatAPCatalogType isPartOf;
    private List<DCatAPCatalogRecordType> record;
    @XmlElement(namespace = "http://purl.org/dc/terms/")
    private List<DCRightStatementType> rights;
    private List<DCatAPRelationshipType> qualifiedRelation;
    @XmlElement(namespace = "http://purl.org/dc/terms/", type = String.class)
    @XmlJavaTypeAdapter(AdapterLocalDateTime.class)
    @XmlSchemaType(name = "dateTime")
    private LocalDateTime issued;
    @XmlElement(namespace = "http://purl.org/dc/terms/", type = String.class)
    @XmlJavaTypeAdapter(AdapterLocalDateTime.class)
    @XmlSchemaType(name = "dateTime")
    private LocalDateTime modified;
    @XmlElement(namespace = "http://purl.org/dc/terms/")
    @XmlSchemaType(name = "anyURI")
    private List<String> language;
    private List<ConceptSchemeType> themeTaxonomy;
    @XmlElement(namespace = "http://xmlns.com/foaf/0.1/")
    private FoafDocumentType homepage;
    @XmlElement(namespace = "http://purl.org/dc/terms/")
    private List<DCLocationType> spatial;
    @XmlElement(namespace = "http://purl.org/dc/terms/")
    private DCLicenceDocumentType licence;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public DCatAPCatalogType() {
    }

    /**
     * Gets the value of the dataset property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the dataset property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDataset().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DCatAPDatasetType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DCatAPDatasetType> getDataset() {
        if (dataset == null) {
            dataset = new ArrayList<DCatAPDatasetType>();
        }
        return this.dataset;
    }

    /**
     * Gets the value of the description property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the description property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<String> getDescription() {
        if (description == null) {
            description = new ArrayList<String>();
        }
        return this.description;
    }

    /**
     * Gets the value of the title property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the title property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTitle().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<String> getTitle() {
        if (title == null) {
            title = new ArrayList<String>();
        }
        return this.title;
    }

    /**
     * Gets the value of the publisher property.
     * 
     * @return
     *     possible object is
     *     {@link FoafAgentType }
     *     
     */
    @Nullable
    public FoafAgentType getPublisher() {
        return publisher;
    }

    /**
     * Sets the value of the publisher property.
     * 
     * @param value
     *     allowed object is
     *     {@link FoafAgentType }
     *     
     */
    public void setPublisher(
        @Nullable
        FoafAgentType value) {
        this.publisher = value;
    }

    /**
     * Gets the value of the creator property.
     * 
     * @return
     *     possible object is
     *     {@link FoafAgentType }
     *     
     */
    @Nullable
    public FoafAgentType getCreator() {
        return creator;
    }

    /**
     * Sets the value of the creator property.
     * 
     * @param value
     *     allowed object is
     *     {@link FoafAgentType }
     *     
     */
    public void setCreator(
        @Nullable
        FoafAgentType value) {
        this.creator = value;
    }

    /**
     * Gets the value of the service property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the service property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getService().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DCatAPDataServiceType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DCatAPDataServiceType> getService() {
        if (service == null) {
            service = new ArrayList<DCatAPDataServiceType>();
        }
        return this.service;
    }

    /**
     * Gets the value of the catalog property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the catalog property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getCatalog().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DCatAPCatalogType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DCatAPCatalogType> getCatalog() {
        if (catalog == null) {
            catalog = new ArrayList<DCatAPCatalogType>();
        }
        return this.catalog;
    }

    /**
     * Gets the value of the hasPart property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the hasPart property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getHasPart().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DCatAPCatalogType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DCatAPCatalogType> getHasPart() {
        if (hasPart == null) {
            hasPart = new ArrayList<DCatAPCatalogType>();
        }
        return this.hasPart;
    }

    /**
     * Gets the value of the isPartOf property.
     * 
     * @return
     *     possible object is
     *     {@link DCatAPCatalogType }
     *     
     */
    @Nullable
    public DCatAPCatalogType getIsPartOf() {
        return isPartOf;
    }

    /**
     * Sets the value of the isPartOf property.
     * 
     * @param value
     *     allowed object is
     *     {@link DCatAPCatalogType }
     *     
     */
    public void setIsPartOf(
        @Nullable
        DCatAPCatalogType value) {
        this.isPartOf = value;
    }

    /**
     * Gets the value of the record property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the record property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getRecord().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DCatAPCatalogRecordType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DCatAPCatalogRecordType> getRecord() {
        if (record == null) {
            record = new ArrayList<DCatAPCatalogRecordType>();
        }
        return this.record;
    }

    /**
     * Gets the value of the rights property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the rights property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getRights().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DCRightStatementType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DCRightStatementType> getRights() {
        if (rights == null) {
            rights = new ArrayList<DCRightStatementType>();
        }
        return this.rights;
    }

    /**
     * Gets the value of the qualifiedRelation property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the qualifiedRelation property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getQualifiedRelation().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DCatAPRelationshipType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DCatAPRelationshipType> getQualifiedRelation() {
        if (qualifiedRelation == null) {
            qualifiedRelation = new ArrayList<DCatAPRelationshipType>();
        }
        return this.qualifiedRelation;
    }

    /**
     * Gets the value of the issued property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public LocalDateTime getIssued() {
        return issued;
    }

    /**
     * Sets the value of the issued property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setIssued(
        @Nullable
        LocalDateTime value) {
        this.issued = value;
    }

    /**
     * Gets the value of the modified property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public LocalDateTime getModified() {
        return modified;
    }

    /**
     * Sets the value of the modified property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setModified(
        @Nullable
        LocalDateTime value) {
        this.modified = value;
    }

    /**
     * Gets the value of the language property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the language property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getLanguage().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<String> getLanguage() {
        if (language == null) {
            language = new ArrayList<String>();
        }
        return this.language;
    }

    /**
     * Gets the value of the themeTaxonomy property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the themeTaxonomy property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getThemeTaxonomy().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ConceptSchemeType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ConceptSchemeType> getThemeTaxonomy() {
        if (themeTaxonomy == null) {
            themeTaxonomy = new ArrayList<ConceptSchemeType>();
        }
        return this.themeTaxonomy;
    }

    /**
     * Gets the value of the homepage property.
     * 
     * @return
     *     possible object is
     *     {@link FoafDocumentType }
     *     
     */
    @Nullable
    public FoafDocumentType getHomepage() {
        return homepage;
    }

    /**
     * Sets the value of the homepage property.
     * 
     * @param value
     *     allowed object is
     *     {@link FoafDocumentType }
     *     
     */
    public void setHomepage(
        @Nullable
        FoafDocumentType value) {
        this.homepage = value;
    }

    /**
     * Gets the value of the spatial property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the spatial property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSpatial().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DCLocationType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DCLocationType> getSpatial() {
        if (spatial == null) {
            spatial = new ArrayList<DCLocationType>();
        }
        return this.spatial;
    }

    /**
     * Gets the value of the licence property.
     * 
     * @return
     *     possible object is
     *     {@link DCLicenceDocumentType }
     *     
     */
    @Nullable
    public DCLicenceDocumentType getLicence() {
        return licence;
    }

    /**
     * Sets the value of the licence property.
     * 
     * @param value
     *     allowed object is
     *     {@link DCLicenceDocumentType }
     *     
     */
    public void setLicence(
        @Nullable
        DCLicenceDocumentType value) {
        this.licence = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final DCatAPCatalogType rhs = ((DCatAPCatalogType) o);
        if (!EqualsHelper.equalsCollection(catalog, rhs.catalog)) {
            return false;
        }
        if (!EqualsHelper.equals(creator, rhs.creator)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(dataset, rhs.dataset)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(description, rhs.description)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(hasPart, rhs.hasPart)) {
            return false;
        }
        if (!EqualsHelper.equals(homepage, rhs.homepage)) {
            return false;
        }
        if (!EqualsHelper.equals(isPartOf, rhs.isPartOf)) {
            return false;
        }
        if (!EqualsHelper.equals(issued, rhs.issued)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(language, rhs.language)) {
            return false;
        }
        if (!EqualsHelper.equals(licence, rhs.licence)) {
            return false;
        }
        if (!EqualsHelper.equals(modified, rhs.modified)) {
            return false;
        }
        if (!EqualsHelper.equals(publisher, rhs.publisher)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(qualifiedRelation, rhs.qualifiedRelation)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(record, rhs.record)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(rights, rhs.rights)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(service, rhs.service)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(spatial, rhs.spatial)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(themeTaxonomy, rhs.themeTaxonomy)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(title, rhs.title)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(catalog).append(creator).append(dataset).append(description).append(hasPart).append(homepage).append(isPartOf).append(issued).append(language).append(licence).append(modified).append(publisher).append(qualifiedRelation).append(record).append(rights).append(service).append(spatial).append(themeTaxonomy).append(title).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("catalog", catalog).append("creator", creator).append("dataset", dataset).append("description", description).append("hasPart", hasPart).append("homepage", homepage).append("isPartOf", isPartOf).append("issued", issued).append("language", language).append("licence", licence).append("modified", modified).append("publisher", publisher).append("qualifiedRelation", qualifiedRelation).append("record", record).append("rights", rights).append("service", service).append("spatial", spatial).append("themeTaxonomy", themeTaxonomy).append("title", title).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDataset(
        @Nullable
        final List<DCatAPDatasetType> aList) {
        dataset = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDescription(
        @Nullable
        final List<String> aList) {
        description = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setTitle(
        @Nullable
        final List<String> aList) {
        title = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setService(
        @Nullable
        final List<DCatAPDataServiceType> aList) {
        service = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setCatalog(
        @Nullable
        final List<DCatAPCatalogType> aList) {
        catalog = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setHasPart(
        @Nullable
        final List<DCatAPCatalogType> aList) {
        hasPart = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setRecord(
        @Nullable
        final List<DCatAPCatalogRecordType> aList) {
        record = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setRights(
        @Nullable
        final List<DCRightStatementType> aList) {
        rights = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setQualifiedRelation(
        @Nullable
        final List<DCatAPRelationshipType> aList) {
        qualifiedRelation = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setLanguage(
        @Nullable
        final List<String> aList) {
        language = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setThemeTaxonomy(
        @Nullable
        final List<ConceptSchemeType> aList) {
        themeTaxonomy = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setSpatial(
        @Nullable
        final List<DCLocationType> aList) {
        spatial = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDatasetEntries() {
        return (!getDataset().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDatasetEntries() {
        return getDataset().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDatasetCount() {
        return getDataset().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DCatAPDatasetType getDatasetAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDataset().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDataset(
        @Nonnull
        final DCatAPDatasetType elem) {
        getDataset().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDescriptionEntries() {
        return (!getDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDescriptionEntries() {
        return getDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDescriptionCount() {
        return getDescription().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public String getDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDescription().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDescription(
        @Nonnull
        final String elem) {
        getDescription().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasTitleEntries() {
        return (!getTitle().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoTitleEntries() {
        return getTitle().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getTitleCount() {
        return getTitle().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public String getTitleAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTitle().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addTitle(
        @Nonnull
        final String elem) {
        getTitle().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasServiceEntries() {
        return (!getService().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoServiceEntries() {
        return getService().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getServiceCount() {
        return getService().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DCatAPDataServiceType getServiceAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getService().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addService(
        @Nonnull
        final DCatAPDataServiceType elem) {
        getService().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasCatalogEntries() {
        return (!getCatalog().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoCatalogEntries() {
        return getCatalog().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getCatalogCount() {
        return getCatalog().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DCatAPCatalogType getCatalogAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getCatalog().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addCatalog(
        @Nonnull
        final DCatAPCatalogType elem) {
        getCatalog().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasHasPartEntries() {
        return (!getHasPart().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoHasPartEntries() {
        return getHasPart().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getHasPartCount() {
        return getHasPart().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DCatAPCatalogType getHasPartAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getHasPart().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addHasPart(
        @Nonnull
        final DCatAPCatalogType elem) {
        getHasPart().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasRecordEntries() {
        return (!getRecord().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoRecordEntries() {
        return getRecord().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getRecordCount() {
        return getRecord().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DCatAPCatalogRecordType getRecordAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getRecord().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addRecord(
        @Nonnull
        final DCatAPCatalogRecordType elem) {
        getRecord().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasRightsEntries() {
        return (!getRights().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoRightsEntries() {
        return getRights().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getRightsCount() {
        return getRights().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DCRightStatementType getRightsAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getRights().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addRights(
        @Nonnull
        final DCRightStatementType elem) {
        getRights().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasQualifiedRelationEntries() {
        return (!getQualifiedRelation().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoQualifiedRelationEntries() {
        return getQualifiedRelation().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getQualifiedRelationCount() {
        return getQualifiedRelation().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DCatAPRelationshipType getQualifiedRelationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getQualifiedRelation().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addQualifiedRelation(
        @Nonnull
        final DCatAPRelationshipType elem) {
        getQualifiedRelation().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasLanguageEntries() {
        return (!getLanguage().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoLanguageEntries() {
        return getLanguage().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getLanguageCount() {
        return getLanguage().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public String getLanguageAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getLanguage().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addLanguage(
        @Nonnull
        final String elem) {
        getLanguage().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasThemeTaxonomyEntries() {
        return (!getThemeTaxonomy().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoThemeTaxonomyEntries() {
        return getThemeTaxonomy().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getThemeTaxonomyCount() {
        return getThemeTaxonomy().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ConceptSchemeType getThemeTaxonomyAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getThemeTaxonomy().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addThemeTaxonomy(
        @Nonnull
        final ConceptSchemeType elem) {
        getThemeTaxonomy().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasSpatialEntries() {
        return (!getSpatial().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoSpatialEntries() {
        return getSpatial().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getSpatialCount() {
        return getSpatial().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DCLocationType getSpatialAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getSpatial().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addSpatial(
        @Nonnull
        final DCLocationType elem) {
        getSpatial().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        DCatAPCatalogType ret) {
        if (catalog == null) {
            ret.catalog = null;
        } else {
            List<DCatAPCatalogType> retCatalog = new ArrayList<DCatAPCatalogType>();
            for (DCatAPCatalogType aItem: getCatalog()) {
                retCatalog.add(((aItem == null)?null:aItem.clone()));
            }
            ret.catalog = retCatalog;
        }
        ret.creator = ((creator == null)?null:creator.clone());
        if (dataset == null) {
            ret.dataset = null;
        } else {
            List<DCatAPDatasetType> retDataset = new ArrayList<DCatAPDatasetType>();
            for (DCatAPDatasetType aItem: getDataset()) {
                retDataset.add(((aItem == null)?null:aItem.clone()));
            }
            ret.dataset = retDataset;
        }
        if (description == null) {
            ret.description = null;
        } else {
            List<String> retDescription = new ArrayList<String>();
            for (String aItem: getDescription()) {
                retDescription.add(aItem);
            }
            ret.description = retDescription;
        }
        if (hasPart == null) {
            ret.hasPart = null;
        } else {
            List<DCatAPCatalogType> retHasPart = new ArrayList<DCatAPCatalogType>();
            for (DCatAPCatalogType aItem: getHasPart()) {
                retHasPart.add(((aItem == null)?null:aItem.clone()));
            }
            ret.hasPart = retHasPart;
        }
        ret.homepage = ((homepage == null)?null:homepage.clone());
        ret.isPartOf = ((isPartOf == null)?null:isPartOf.clone());
        ret.issued = issued;
        if (language == null) {
            ret.language = null;
        } else {
            List<String> retLanguage = new ArrayList<String>();
            for (String aItem: getLanguage()) {
                retLanguage.add(aItem);
            }
            ret.language = retLanguage;
        }
        ret.licence = ((licence == null)?null:licence.clone());
        ret.modified = modified;
        ret.publisher = ((publisher == null)?null:publisher.clone());
        if (qualifiedRelation == null) {
            ret.qualifiedRelation = null;
        } else {
            List<DCatAPRelationshipType> retQualifiedRelation = new ArrayList<DCatAPRelationshipType>();
            for (DCatAPRelationshipType aItem: getQualifiedRelation()) {
                retQualifiedRelation.add(((aItem == null)?null:aItem.clone()));
            }
            ret.qualifiedRelation = retQualifiedRelation;
        }
        if (record == null) {
            ret.record = null;
        } else {
            List<DCatAPCatalogRecordType> retRecord = new ArrayList<DCatAPCatalogRecordType>();
            for (DCatAPCatalogRecordType aItem: getRecord()) {
                retRecord.add(((aItem == null)?null:aItem.clone()));
            }
            ret.record = retRecord;
        }
        if (rights == null) {
            ret.rights = null;
        } else {
            List<DCRightStatementType> retRights = new ArrayList<DCRightStatementType>();
            for (DCRightStatementType aItem: getRights()) {
                retRights.add(((aItem == null)?null:aItem.clone()));
            }
            ret.rights = retRights;
        }
        if (service == null) {
            ret.service = null;
        } else {
            List<DCatAPDataServiceType> retService = new ArrayList<DCatAPDataServiceType>();
            for (DCatAPDataServiceType aItem: getService()) {
                retService.add(((aItem == null)?null:aItem.clone()));
            }
            ret.service = retService;
        }
        if (spatial == null) {
            ret.spatial = null;
        } else {
            List<DCLocationType> retSpatial = new ArrayList<DCLocationType>();
            for (DCLocationType aItem: getSpatial()) {
                retSpatial.add(((aItem == null)?null:aItem.clone()));
            }
            ret.spatial = retSpatial;
        }
        if (themeTaxonomy == null) {
            ret.themeTaxonomy = null;
        } else {
            List<ConceptSchemeType> retThemeTaxonomy = new ArrayList<ConceptSchemeType>();
            for (ConceptSchemeType aItem: getThemeTaxonomy()) {
                retThemeTaxonomy.add(((aItem == null)?null:aItem.clone()));
            }
            ret.themeTaxonomy = retThemeTaxonomy;
        }
        if (title == null) {
            ret.title = null;
        } else {
            List<String> retTitle = new ArrayList<String>();
            for (String aItem: getTitle()) {
                retTitle.add(aItem);
            }
            ret.title = retTitle;
        }
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public DCatAPCatalogType clone() {
        DCatAPCatalogType ret = new DCatAPCatalogType();
        cloneTo(ret);
        return ret;
    }

}
