
package eu.toop.edm.jaxb.dcatap;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.NormalizedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.jaxb.adapter.AdapterDuration;
import com.helger.jaxb.adapter.AdapterLocalDateTime;
import eu.toop.edm.jaxb.cccev.CCCEVEvidenceType;
import eu.toop.edm.jaxb.cccev.CCCEVEvidenceTypeType;
import eu.toop.edm.jaxb.cccev.CCCEVReferenceFrameworkType;
import eu.toop.edm.jaxb.dcterms.DCLocationType;
import eu.toop.edm.jaxb.dcterms.DCMediaType;
import eu.toop.edm.jaxb.dcterms.DCPeriodOfTimeType;
import eu.toop.edm.jaxb.dcterms.DCProvenanceStatementType;
import eu.toop.edm.jaxb.dcterms.DCRightStatementType;
import eu.toop.edm.jaxb.dcterms.DCStandardType;
import eu.toop.edm.jaxb.foaf.FoafAgentType;
import eu.toop.edm.jaxb.foaf.FoafDocumentType;
import eu.toop.edm.jaxb.prov.ActivityType;
import eu.toop.edm.jaxb.prov.AttributionType;
import eu.toop.edm.jaxb.rdf.PlainLiteral;
import eu.toop.edm.jaxb.rdf.Resource;
import eu.toop.edm.jaxb.w3.skos.ConceptType;


/**
 * <p>Java class for DatasetType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="DatasetType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;extension base="{http://www.w3.org/1999/02/22-rdf-syntax-ns#}Resource"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{http://purl.org/dc/terms/}description" maxOccurs="unbounded"/&gt;
 *         &lt;element ref="{http://purl.org/dc/terms/}title" maxOccurs="unbounded"/&gt;
 *         &lt;element ref="{http://purl.org/dc/terms/}spatial" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://data.europa.eu/r5r/}contactPoint" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://data.europa.eu/r5r/}distribution" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://data.europa.eu/r5r/}keyword" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://data.europa.eu/r5r/}theme" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/adms#}sample" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/adms#}versionNotes" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://purl.org/dc/terms/}accessRights" minOccurs="0"/&gt;
 *         &lt;element ref="{http://purl.org/dc/terms/}accrualPeriodicity" minOccurs="0"/&gt;
 *         &lt;element ref="{http://purl.org/dc/terms/}conformsTo" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://purl.org/dc/terms/}creator" minOccurs="0"/&gt;
 *         &lt;element ref="{http://purl.org/dc/terms/}format" minOccurs="0"/&gt;
 *         &lt;element ref="{http://purl.org/dc/terms/}hasVersion" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://purl.org/dc/terms/}identifier" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://purl.org/dc/terms/}isReferencedBy" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://purl.org/dc/terms/}issued" minOccurs="0"/&gt;
 *         &lt;element ref="{http://purl.org/dc/terms/}language" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://purl.org/dc/terms/}modified" minOccurs="0"/&gt;
 *         &lt;element ref="{http://purl.org/dc/terms/}provenance" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://purl.org/dc/terms/}publisher" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://purl.org/dc/terms/}relation" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://purl.org/dc/terms/}source" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://purl.org/dc/terms/}temporal" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://purl.org/dc/terms/}type" minOccurs="0"/&gt;
 *         &lt;element ref="{http://xmlns.com/foaf/0.1/}page" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/prov#}qualifiedAttribution" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/prov#}wasGeneratedBy" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://data.europa.eu/r5r/}hasVersion" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://data.europa.eu/r5r/}isVersionOf" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://data.europa.eu/r5r/}landingPage" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://data.europa.eu/r5r/}qualifiedRelation" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://data.europa.eu/r5r/}spatialResolutionInMeters" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://data.europa.eu/r5r/}temporalResolution" maxOccurs="unbounded" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/extension&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "DatasetType", propOrder = {
    "description",
    "title",
    "spatial",
    "contactPoint",
    "distribution",
    "keyword",
    "theme",
    "sample",
    "versionNotes",
    "accessRights",
    "accrualPeriodicity",
    "conformsTo",
    "creator",
    "format",
    "dctHasVersion",
    "identifier",
    "isReferencedBy",
    "issued",
    "language",
    "modified",
    "provenance",
    "publisher",
    "relation",
    "source",
    "temporal",
    "type",
    "page",
    "qualifiedAttribution",
    "wasGeneratedBy",
    "hasVersion",
    "isVersionOf",
    "landingPage",
    "qualifiedRelation",
    "spatialResolutionInMeters",
    "temporalResolution"
})
@XmlSeeAlso({
    CCCEVReferenceFrameworkType.class,
    CCCEVEvidenceType.class,
    CCCEVEvidenceTypeType.class
})
@CodingStyleguideUnaware
public class DCatAPDatasetType
    extends Resource
{

    @XmlElement(namespace = "http://purl.org/dc/terms/", required = true)
    private List<String> description;
    @XmlElement(namespace = "http://purl.org/dc/terms/", required = true)
    private List<String> title;
    @XmlElement(namespace = "http://purl.org/dc/terms/")
    private List<DCLocationType> spatial;
    private List<Object> contactPoint;
    private List<DCatAPDistributionType> distribution;
    private List<PlainLiteral> keyword;
    private List<ConceptType> theme;
    @XmlElement(namespace = "http://www.w3.org/ns/adms#")
    private List<DCatAPDistributionType> sample;
    @XmlElement(namespace = "http://www.w3.org/ns/adms#")
    private List<PlainLiteral> versionNotes;
    @XmlElement(namespace = "http://purl.org/dc/terms/")
    private DCRightStatementType accessRights;
    @XmlElement(namespace = "http://purl.org/dc/terms/")
    @XmlSchemaType(name = "positiveInteger")
    private BigInteger accrualPeriodicity;
    @XmlElement(namespace = "http://purl.org/dc/terms/")
    private List<DCStandardType> conformsTo;
    @XmlElement(namespace = "http://purl.org/dc/terms/")
    private FoafAgentType creator;
    @XmlElement(namespace = "http://purl.org/dc/terms/")
    private DCMediaType format;
    @XmlElement(name = "hasVersion", namespace = "http://purl.org/dc/terms/")
    private List<Resource> dctHasVersion;
    @XmlElement(namespace = "http://purl.org/dc/terms/")
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    @XmlSchemaType(name = "normalizedString")
    private List<String> identifier;
    @XmlElement(namespace = "http://purl.org/dc/terms/")
    private List<Resource> isReferencedBy;
    @XmlElement(namespace = "http://purl.org/dc/terms/", type = String.class)
    @XmlJavaTypeAdapter(AdapterLocalDateTime.class)
    @XmlSchemaType(name = "dateTime")
    private LocalDateTime issued;
    @XmlElement(namespace = "http://purl.org/dc/terms/")
    @XmlSchemaType(name = "anyURI")
    private List<String> language;
    @XmlElement(namespace = "http://purl.org/dc/terms/", type = String.class)
    @XmlJavaTypeAdapter(AdapterLocalDateTime.class)
    @XmlSchemaType(name = "dateTime")
    private LocalDateTime modified;
    @XmlElement(namespace = "http://purl.org/dc/terms/")
    private List<DCProvenanceStatementType> provenance;
    @XmlElement(namespace = "http://purl.org/dc/terms/")
    private List<FoafAgentType> publisher;
    @XmlElement(namespace = "http://purl.org/dc/terms/")
    private List<Object> relation;
    @XmlElement(namespace = "http://purl.org/dc/terms/")
    private List<ConceptType> source;
    @XmlElement(namespace = "http://purl.org/dc/terms/")
    private List<DCPeriodOfTimeType> temporal;
    @XmlElement(namespace = "http://purl.org/dc/terms/")
    @XmlSchemaType(name = "anyURI")
    private String type;
    @XmlElement(namespace = "http://xmlns.com/foaf/0.1/")
    private List<FoafDocumentType> page;
    @XmlElement(namespace = "http://www.w3.org/ns/prov#")
    private List<AttributionType> qualifiedAttribution;
    @XmlElement(namespace = "http://www.w3.org/ns/prov#")
    private List<ActivityType> wasGeneratedBy;
    private List<DCatAPDatasetType> hasVersion;
    private List<DCatAPDatasetType> isVersionOf;
    private List<FoafDocumentType> landingPage;
    private List<DCatAPRelationshipType> qualifiedRelation;
    private List<BigDecimal> spatialResolutionInMeters;
    @XmlElement(type = String.class)
    @XmlJavaTypeAdapter(AdapterDuration.class)
    @XmlSchemaType(name = "duration")
    private List<Duration> temporalResolution;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public DCatAPDatasetType() {
    }

    /**
     * Gets the value of the description property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the description property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<String> getDescription() {
        if (description == null) {
            description = new ArrayList<String>();
        }
        return this.description;
    }

    /**
     * Gets the value of the title property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the title property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTitle().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<String> getTitle() {
        if (title == null) {
            title = new ArrayList<String>();
        }
        return this.title;
    }

    /**
     * Gets the value of the spatial property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the spatial property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSpatial().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DCLocationType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DCLocationType> getSpatial() {
        if (spatial == null) {
            spatial = new ArrayList<DCLocationType>();
        }
        return this.spatial;
    }

    /**
     * Gets the value of the contactPoint property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the contactPoint property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getContactPoint().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Object }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<Object> getContactPoint() {
        if (contactPoint == null) {
            contactPoint = new ArrayList<Object>();
        }
        return this.contactPoint;
    }

    /**
     * Gets the value of the distribution property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the distribution property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDistribution().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DCatAPDistributionType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DCatAPDistributionType> getDistribution() {
        if (distribution == null) {
            distribution = new ArrayList<DCatAPDistributionType>();
        }
        return this.distribution;
    }

    /**
     * Gets the value of the keyword property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the keyword property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getKeyword().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PlainLiteral }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PlainLiteral> getKeyword() {
        if (keyword == null) {
            keyword = new ArrayList<PlainLiteral>();
        }
        return this.keyword;
    }

    /**
     * Gets the value of the theme property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the theme property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTheme().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ConceptType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ConceptType> getTheme() {
        if (theme == null) {
            theme = new ArrayList<ConceptType>();
        }
        return this.theme;
    }

    /**
     * Gets the value of the sample property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the sample property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSample().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DCatAPDistributionType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DCatAPDistributionType> getSample() {
        if (sample == null) {
            sample = new ArrayList<DCatAPDistributionType>();
        }
        return this.sample;
    }

    /**
     * Gets the value of the versionNotes property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the versionNotes property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getVersionNotes().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PlainLiteral }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PlainLiteral> getVersionNotes() {
        if (versionNotes == null) {
            versionNotes = new ArrayList<PlainLiteral>();
        }
        return this.versionNotes;
    }

    /**
     * Gets the value of the accessRights property.
     * 
     * @return
     *     possible object is
     *     {@link DCRightStatementType }
     *     
     */
    @Nullable
    public DCRightStatementType getAccessRights() {
        return accessRights;
    }

    /**
     * Sets the value of the accessRights property.
     * 
     * @param value
     *     allowed object is
     *     {@link DCRightStatementType }
     *     
     */
    public void setAccessRights(
        @Nullable
        DCRightStatementType value) {
        this.accessRights = value;
    }

    /**
     * Gets the value of the accrualPeriodicity property.
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    @Nullable
    public BigInteger getAccrualPeriodicity() {
        return accrualPeriodicity;
    }

    /**
     * Sets the value of the accrualPeriodicity property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     */
    public void setAccrualPeriodicity(
        @Nullable
        BigInteger value) {
        this.accrualPeriodicity = value;
    }

    /**
     * Gets the value of the conformsTo property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the conformsTo property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getConformsTo().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DCStandardType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DCStandardType> getConformsTo() {
        if (conformsTo == null) {
            conformsTo = new ArrayList<DCStandardType>();
        }
        return this.conformsTo;
    }

    /**
     * Gets the value of the creator property.
     * 
     * @return
     *     possible object is
     *     {@link FoafAgentType }
     *     
     */
    @Nullable
    public FoafAgentType getCreator() {
        return creator;
    }

    /**
     * Sets the value of the creator property.
     * 
     * @param value
     *     allowed object is
     *     {@link FoafAgentType }
     *     
     */
    public void setCreator(
        @Nullable
        FoafAgentType value) {
        this.creator = value;
    }

    /**
     * Gets the value of the format property.
     * 
     * @return
     *     possible object is
     *     {@link DCMediaType }
     *     
     */
    @Nullable
    public DCMediaType getFormat() {
        return format;
    }

    /**
     * Sets the value of the format property.
     * 
     * @param value
     *     allowed object is
     *     {@link DCMediaType }
     *     
     */
    public void setFormat(
        @Nullable
        DCMediaType value) {
        this.format = value;
    }

    /**
     * Gets the value of the dctHasVersion property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the dctHasVersion property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDCTHasVersion().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Resource }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<Resource> getDCTHasVersion() {
        if (dctHasVersion == null) {
            dctHasVersion = new ArrayList<Resource>();
        }
        return this.dctHasVersion;
    }

    /**
     * Gets the value of the identifier property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the identifier property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getIdentifier().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<String> getIdentifier() {
        if (identifier == null) {
            identifier = new ArrayList<String>();
        }
        return this.identifier;
    }

    /**
     * Gets the value of the isReferencedBy property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the isReferencedBy property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getIsReferencedBy().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Resource }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<Resource> getIsReferencedBy() {
        if (isReferencedBy == null) {
            isReferencedBy = new ArrayList<Resource>();
        }
        return this.isReferencedBy;
    }

    /**
     * Gets the value of the issued property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public LocalDateTime getIssued() {
        return issued;
    }

    /**
     * Sets the value of the issued property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setIssued(
        @Nullable
        LocalDateTime value) {
        this.issued = value;
    }

    /**
     * Gets the value of the language property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the language property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getLanguage().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<String> getLanguage() {
        if (language == null) {
            language = new ArrayList<String>();
        }
        return this.language;
    }

    /**
     * Gets the value of the modified property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public LocalDateTime getModified() {
        return modified;
    }

    /**
     * Sets the value of the modified property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setModified(
        @Nullable
        LocalDateTime value) {
        this.modified = value;
    }

    /**
     * Gets the value of the provenance property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the provenance property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getProvenance().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DCProvenanceStatementType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DCProvenanceStatementType> getProvenance() {
        if (provenance == null) {
            provenance = new ArrayList<DCProvenanceStatementType>();
        }
        return this.provenance;
    }

    /**
     * Gets the value of the publisher property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the publisher property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPublisher().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link FoafAgentType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<FoafAgentType> getPublisher() {
        if (publisher == null) {
            publisher = new ArrayList<FoafAgentType>();
        }
        return this.publisher;
    }

    /**
     * Gets the value of the relation property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the relation property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getRelation().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Object }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<Object> getRelation() {
        if (relation == null) {
            relation = new ArrayList<Object>();
        }
        return this.relation;
    }

    /**
     * Gets the value of the source property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the source property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSource().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ConceptType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ConceptType> getSource() {
        if (source == null) {
            source = new ArrayList<ConceptType>();
        }
        return this.source;
    }

    /**
     * Gets the value of the temporal property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the temporal property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTemporal().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DCPeriodOfTimeType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DCPeriodOfTimeType> getTemporal() {
        if (temporal == null) {
            temporal = new ArrayList<DCPeriodOfTimeType>();
        }
        return this.temporal;
    }

    /**
     * Gets the value of the type property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getType() {
        return type;
    }

    /**
     * Sets the value of the type property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setType(
        @Nullable
        String value) {
        this.type = value;
    }

    /**
     * Gets the value of the page property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the page property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPage().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link FoafDocumentType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<FoafDocumentType> getPage() {
        if (page == null) {
            page = new ArrayList<FoafDocumentType>();
        }
        return this.page;
    }

    /**
     * Gets the value of the qualifiedAttribution property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the qualifiedAttribution property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getQualifiedAttribution().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AttributionType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AttributionType> getQualifiedAttribution() {
        if (qualifiedAttribution == null) {
            qualifiedAttribution = new ArrayList<AttributionType>();
        }
        return this.qualifiedAttribution;
    }

    /**
     * Gets the value of the wasGeneratedBy property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the wasGeneratedBy property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getWasGeneratedBy().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ActivityType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ActivityType> getWasGeneratedBy() {
        if (wasGeneratedBy == null) {
            wasGeneratedBy = new ArrayList<ActivityType>();
        }
        return this.wasGeneratedBy;
    }

    /**
     * Gets the value of the hasVersion property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the hasVersion property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getHasVersion().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DCatAPDatasetType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DCatAPDatasetType> getHasVersion() {
        if (hasVersion == null) {
            hasVersion = new ArrayList<DCatAPDatasetType>();
        }
        return this.hasVersion;
    }

    /**
     * Gets the value of the isVersionOf property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the isVersionOf property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getIsVersionOf().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DCatAPDatasetType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DCatAPDatasetType> getIsVersionOf() {
        if (isVersionOf == null) {
            isVersionOf = new ArrayList<DCatAPDatasetType>();
        }
        return this.isVersionOf;
    }

    /**
     * Gets the value of the landingPage property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the landingPage property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getLandingPage().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link FoafDocumentType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<FoafDocumentType> getLandingPage() {
        if (landingPage == null) {
            landingPage = new ArrayList<FoafDocumentType>();
        }
        return this.landingPage;
    }

    /**
     * Gets the value of the qualifiedRelation property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the qualifiedRelation property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getQualifiedRelation().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DCatAPRelationshipType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DCatAPRelationshipType> getQualifiedRelation() {
        if (qualifiedRelation == null) {
            qualifiedRelation = new ArrayList<DCatAPRelationshipType>();
        }
        return this.qualifiedRelation;
    }

    /**
     * Gets the value of the spatialResolutionInMeters property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the spatialResolutionInMeters property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSpatialResolutionInMeters().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link BigDecimal }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<BigDecimal> getSpatialResolutionInMeters() {
        if (spatialResolutionInMeters == null) {
            spatialResolutionInMeters = new ArrayList<BigDecimal>();
        }
        return this.spatialResolutionInMeters;
    }

    /**
     * Gets the value of the temporalResolution property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the temporalResolution property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTemporalResolution().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<Duration> getTemporalResolution() {
        if (temporalResolution == null) {
            temporalResolution = new ArrayList<Duration>();
        }
        return this.temporalResolution;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        final DCatAPDatasetType rhs = ((DCatAPDatasetType) o);
        if (!EqualsHelper.equals(accessRights, rhs.accessRights)) {
            return false;
        }
        if (!EqualsHelper.equals(accrualPeriodicity, rhs.accrualPeriodicity)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(conformsTo, rhs.conformsTo)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(contactPoint, rhs.contactPoint)) {
            return false;
        }
        if (!EqualsHelper.equals(creator, rhs.creator)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(dctHasVersion, rhs.dctHasVersion)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(description, rhs.description)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(distribution, rhs.distribution)) {
            return false;
        }
        if (!EqualsHelper.equals(format, rhs.format)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(hasVersion, rhs.hasVersion)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(identifier, rhs.identifier)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(isReferencedBy, rhs.isReferencedBy)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(isVersionOf, rhs.isVersionOf)) {
            return false;
        }
        if (!EqualsHelper.equals(issued, rhs.issued)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(keyword, rhs.keyword)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(landingPage, rhs.landingPage)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(language, rhs.language)) {
            return false;
        }
        if (!EqualsHelper.equals(modified, rhs.modified)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(page, rhs.page)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(provenance, rhs.provenance)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(publisher, rhs.publisher)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(qualifiedAttribution, rhs.qualifiedAttribution)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(qualifiedRelation, rhs.qualifiedRelation)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(relation, rhs.relation)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(sample, rhs.sample)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(source, rhs.source)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(spatial, rhs.spatial)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(spatialResolutionInMeters, rhs.spatialResolutionInMeters)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(temporal, rhs.temporal)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(temporalResolution, rhs.temporalResolution)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(theme, rhs.theme)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(title, rhs.title)) {
            return false;
        }
        if (!EqualsHelper.equals(type, rhs.type)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(versionNotes, rhs.versionNotes)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(wasGeneratedBy, rhs.wasGeneratedBy)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(accessRights).append(accrualPeriodicity).append(conformsTo).append(contactPoint).append(creator).append(dctHasVersion).append(description).append(distribution).append(format).append(hasVersion).append(identifier).append(isReferencedBy).append(isVersionOf).append(issued).append(keyword).append(landingPage).append(language).append(modified).append(page).append(provenance).append(publisher).append(qualifiedAttribution).append(qualifiedRelation).append(relation).append(sample).append(source).append(spatial).append(spatialResolutionInMeters).append(temporal).append(temporalResolution).append(theme).append(title).append(type).append(versionNotes).append(wasGeneratedBy).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("accessRights", accessRights).append("accrualPeriodicity", accrualPeriodicity).append("conformsTo", conformsTo).append("contactPoint", contactPoint).append("creator", creator).append("dctHasVersion", dctHasVersion).append("description", description).append("distribution", distribution).append("format", format).append("hasVersion", hasVersion).append("identifier", identifier).append("isReferencedBy", isReferencedBy).append("isVersionOf", isVersionOf).append("issued", issued).append("keyword", keyword).append("landingPage", landingPage).append("language", language).append("modified", modified).append("page", page).append("provenance", provenance).append("publisher", publisher).append("qualifiedAttribution", qualifiedAttribution).append("qualifiedRelation", qualifiedRelation).append("relation", relation).append("sample", sample).append("source", source).append("spatial", spatial).append("spatialResolutionInMeters", spatialResolutionInMeters).append("temporal", temporal).append("temporalResolution", temporalResolution).append("theme", theme).append("title", title).append("type", type).append("versionNotes", versionNotes).append("wasGeneratedBy", wasGeneratedBy).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDescription(
        @Nullable
        final List<String> aList) {
        description = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setTitle(
        @Nullable
        final List<String> aList) {
        title = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setSpatial(
        @Nullable
        final List<DCLocationType> aList) {
        spatial = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setContactPoint(
        @Nullable
        final List<Object> aList) {
        contactPoint = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDistribution(
        @Nullable
        final List<DCatAPDistributionType> aList) {
        distribution = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setKeyword(
        @Nullable
        final List<PlainLiteral> aList) {
        keyword = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setTheme(
        @Nullable
        final List<ConceptType> aList) {
        theme = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setSample(
        @Nullable
        final List<DCatAPDistributionType> aList) {
        sample = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setVersionNotes(
        @Nullable
        final List<PlainLiteral> aList) {
        versionNotes = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setConformsTo(
        @Nullable
        final List<DCStandardType> aList) {
        conformsTo = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDCTHasVersion(
        @Nullable
        final List<Resource> aList) {
        dctHasVersion = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setIdentifier(
        @Nullable
        final List<String> aList) {
        identifier = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setIsReferencedBy(
        @Nullable
        final List<Resource> aList) {
        isReferencedBy = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setLanguage(
        @Nullable
        final List<String> aList) {
        language = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setProvenance(
        @Nullable
        final List<DCProvenanceStatementType> aList) {
        provenance = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPublisher(
        @Nullable
        final List<FoafAgentType> aList) {
        publisher = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setRelation(
        @Nullable
        final List<Object> aList) {
        relation = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setSource(
        @Nullable
        final List<ConceptType> aList) {
        source = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setTemporal(
        @Nullable
        final List<DCPeriodOfTimeType> aList) {
        temporal = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPage(
        @Nullable
        final List<FoafDocumentType> aList) {
        page = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setQualifiedAttribution(
        @Nullable
        final List<AttributionType> aList) {
        qualifiedAttribution = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setWasGeneratedBy(
        @Nullable
        final List<ActivityType> aList) {
        wasGeneratedBy = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setHasVersion(
        @Nullable
        final List<DCatAPDatasetType> aList) {
        hasVersion = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setIsVersionOf(
        @Nullable
        final List<DCatAPDatasetType> aList) {
        isVersionOf = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setLandingPage(
        @Nullable
        final List<FoafDocumentType> aList) {
        landingPage = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setQualifiedRelation(
        @Nullable
        final List<DCatAPRelationshipType> aList) {
        qualifiedRelation = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setSpatialResolutionInMeters(
        @Nullable
        final List<BigDecimal> aList) {
        spatialResolutionInMeters = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setTemporalResolution(
        @Nullable
        final List<Duration> aList) {
        temporalResolution = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDescriptionEntries() {
        return (!getDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDescriptionEntries() {
        return getDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDescriptionCount() {
        return getDescription().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public String getDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDescription().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDescription(
        @Nonnull
        final String elem) {
        getDescription().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasTitleEntries() {
        return (!getTitle().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoTitleEntries() {
        return getTitle().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getTitleCount() {
        return getTitle().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public String getTitleAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTitle().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addTitle(
        @Nonnull
        final String elem) {
        getTitle().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasSpatialEntries() {
        return (!getSpatial().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoSpatialEntries() {
        return getSpatial().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getSpatialCount() {
        return getSpatial().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DCLocationType getSpatialAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getSpatial().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addSpatial(
        @Nonnull
        final DCLocationType elem) {
        getSpatial().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasContactPointEntries() {
        return (!getContactPoint().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoContactPointEntries() {
        return getContactPoint().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getContactPointCount() {
        return getContactPoint().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public Object getContactPointAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getContactPoint().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addContactPoint(
        @Nonnull
        final Object elem) {
        getContactPoint().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDistributionEntries() {
        return (!getDistribution().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDistributionEntries() {
        return getDistribution().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDistributionCount() {
        return getDistribution().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DCatAPDistributionType getDistributionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDistribution().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDistribution(
        @Nonnull
        final DCatAPDistributionType elem) {
        getDistribution().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasKeywordEntries() {
        return (!getKeyword().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoKeywordEntries() {
        return getKeyword().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getKeywordCount() {
        return getKeyword().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PlainLiteral getKeywordAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getKeyword().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addKeyword(
        @Nonnull
        final PlainLiteral elem) {
        getKeyword().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasThemeEntries() {
        return (!getTheme().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoThemeEntries() {
        return getTheme().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getThemeCount() {
        return getTheme().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ConceptType getThemeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTheme().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addTheme(
        @Nonnull
        final ConceptType elem) {
        getTheme().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasSampleEntries() {
        return (!getSample().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoSampleEntries() {
        return getSample().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getSampleCount() {
        return getSample().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DCatAPDistributionType getSampleAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getSample().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addSample(
        @Nonnull
        final DCatAPDistributionType elem) {
        getSample().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasVersionNotesEntries() {
        return (!getVersionNotes().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoVersionNotesEntries() {
        return getVersionNotes().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getVersionNotesCount() {
        return getVersionNotes().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PlainLiteral getVersionNotesAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getVersionNotes().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addVersionNotes(
        @Nonnull
        final PlainLiteral elem) {
        getVersionNotes().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasConformsToEntries() {
        return (!getConformsTo().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoConformsToEntries() {
        return getConformsTo().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getConformsToCount() {
        return getConformsTo().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DCStandardType getConformsToAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getConformsTo().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addConformsTo(
        @Nonnull
        final DCStandardType elem) {
        getConformsTo().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDCTHasVersionEntries() {
        return (!getDCTHasVersion().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDCTHasVersionEntries() {
        return getDCTHasVersion().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDCTHasVersionCount() {
        return getDCTHasVersion().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public Resource getDCTHasVersionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDCTHasVersion().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDCTHasVersion(
        @Nonnull
        final Resource elem) {
        getDCTHasVersion().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasIdentifierEntries() {
        return (!getIdentifier().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoIdentifierEntries() {
        return getIdentifier().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getIdentifierCount() {
        return getIdentifier().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public String getIdentifierAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getIdentifier().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addIdentifier(
        @Nonnull
        final String elem) {
        getIdentifier().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasIsReferencedByEntries() {
        return (!getIsReferencedBy().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoIsReferencedByEntries() {
        return getIsReferencedBy().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getIsReferencedByCount() {
        return getIsReferencedBy().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public Resource getIsReferencedByAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getIsReferencedBy().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addIsReferencedBy(
        @Nonnull
        final Resource elem) {
        getIsReferencedBy().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasLanguageEntries() {
        return (!getLanguage().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoLanguageEntries() {
        return getLanguage().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getLanguageCount() {
        return getLanguage().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public String getLanguageAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getLanguage().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addLanguage(
        @Nonnull
        final String elem) {
        getLanguage().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasProvenanceEntries() {
        return (!getProvenance().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoProvenanceEntries() {
        return getProvenance().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getProvenanceCount() {
        return getProvenance().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DCProvenanceStatementType getProvenanceAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getProvenance().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addProvenance(
        @Nonnull
        final DCProvenanceStatementType elem) {
        getProvenance().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPublisherEntries() {
        return (!getPublisher().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPublisherEntries() {
        return getPublisher().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPublisherCount() {
        return getPublisher().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public FoafAgentType getPublisherAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPublisher().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPublisher(
        @Nonnull
        final FoafAgentType elem) {
        getPublisher().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasRelationEntries() {
        return (!getRelation().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoRelationEntries() {
        return getRelation().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getRelationCount() {
        return getRelation().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public Object getRelationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getRelation().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addRelation(
        @Nonnull
        final Object elem) {
        getRelation().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasSourceEntries() {
        return (!getSource().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoSourceEntries() {
        return getSource().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getSourceCount() {
        return getSource().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ConceptType getSourceAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getSource().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addSource(
        @Nonnull
        final ConceptType elem) {
        getSource().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasTemporalEntries() {
        return (!getTemporal().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoTemporalEntries() {
        return getTemporal().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getTemporalCount() {
        return getTemporal().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DCPeriodOfTimeType getTemporalAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTemporal().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addTemporal(
        @Nonnull
        final DCPeriodOfTimeType elem) {
        getTemporal().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPageEntries() {
        return (!getPage().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPageEntries() {
        return getPage().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPageCount() {
        return getPage().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public FoafDocumentType getPageAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPage().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPage(
        @Nonnull
        final FoafDocumentType elem) {
        getPage().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasQualifiedAttributionEntries() {
        return (!getQualifiedAttribution().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoQualifiedAttributionEntries() {
        return getQualifiedAttribution().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getQualifiedAttributionCount() {
        return getQualifiedAttribution().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AttributionType getQualifiedAttributionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getQualifiedAttribution().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addQualifiedAttribution(
        @Nonnull
        final AttributionType elem) {
        getQualifiedAttribution().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasWasGeneratedByEntries() {
        return (!getWasGeneratedBy().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoWasGeneratedByEntries() {
        return getWasGeneratedBy().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getWasGeneratedByCount() {
        return getWasGeneratedBy().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ActivityType getWasGeneratedByAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getWasGeneratedBy().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addWasGeneratedBy(
        @Nonnull
        final ActivityType elem) {
        getWasGeneratedBy().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasHasVersionEntries() {
        return (!getHasVersion().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoHasVersionEntries() {
        return getHasVersion().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getHasVersionCount() {
        return getHasVersion().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DCatAPDatasetType getHasVersionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getHasVersion().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addHasVersion(
        @Nonnull
        final DCatAPDatasetType elem) {
        getHasVersion().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasIsVersionOfEntries() {
        return (!getIsVersionOf().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoIsVersionOfEntries() {
        return getIsVersionOf().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getIsVersionOfCount() {
        return getIsVersionOf().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DCatAPDatasetType getIsVersionOfAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getIsVersionOf().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addIsVersionOf(
        @Nonnull
        final DCatAPDatasetType elem) {
        getIsVersionOf().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasLandingPageEntries() {
        return (!getLandingPage().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoLandingPageEntries() {
        return getLandingPage().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getLandingPageCount() {
        return getLandingPage().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public FoafDocumentType getLandingPageAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getLandingPage().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addLandingPage(
        @Nonnull
        final FoafDocumentType elem) {
        getLandingPage().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasQualifiedRelationEntries() {
        return (!getQualifiedRelation().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoQualifiedRelationEntries() {
        return getQualifiedRelation().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getQualifiedRelationCount() {
        return getQualifiedRelation().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DCatAPRelationshipType getQualifiedRelationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getQualifiedRelation().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addQualifiedRelation(
        @Nonnull
        final DCatAPRelationshipType elem) {
        getQualifiedRelation().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasSpatialResolutionInMetersEntries() {
        return (!getSpatialResolutionInMeters().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoSpatialResolutionInMetersEntries() {
        return getSpatialResolutionInMeters().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getSpatialResolutionInMetersCount() {
        return getSpatialResolutionInMeters().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public BigDecimal getSpatialResolutionInMetersAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getSpatialResolutionInMeters().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addSpatialResolutionInMeters(
        @Nonnull
        final BigDecimal elem) {
        getSpatialResolutionInMeters().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasTemporalResolutionEntries() {
        return (!getTemporalResolution().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoTemporalResolutionEntries() {
        return getTemporalResolution().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getTemporalResolutionCount() {
        return getTemporalResolution().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public Duration getTemporalResolutionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTemporalResolution().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addTemporalResolution(
        @Nonnull
        final Duration elem) {
        getTemporalResolution().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        DCatAPDatasetType ret) {
        super.cloneTo(ret);
        ret.accessRights = ((accessRights == null)?null:accessRights.clone());
        ret.accrualPeriodicity = accrualPeriodicity;
        if (conformsTo == null) {
            ret.conformsTo = null;
        } else {
            List<DCStandardType> retConformsTo = new ArrayList<DCStandardType>();
            for (DCStandardType aItem: getConformsTo()) {
                retConformsTo.add(((aItem == null)?null:aItem.clone()));
            }
            ret.conformsTo = retConformsTo;
        }
        if (contactPoint == null) {
            ret.contactPoint = null;
        } else {
            List<Object> retContactPoint = new ArrayList<Object>();
            for (Object aItem: getContactPoint()) {
                retContactPoint.add(aItem);
            }
            ret.contactPoint = retContactPoint;
        }
        ret.creator = ((creator == null)?null:creator.clone());
        if (dctHasVersion == null) {
            ret.dctHasVersion = null;
        } else {
            List<Resource> retDCTHasVersion = new ArrayList<Resource>();
            for (Resource aItem: getDCTHasVersion()) {
                retDCTHasVersion.add(((aItem == null)?null:aItem.clone()));
            }
            ret.dctHasVersion = retDCTHasVersion;
        }
        if (description == null) {
            ret.description = null;
        } else {
            List<String> retDescription = new ArrayList<String>();
            for (String aItem: getDescription()) {
                retDescription.add(aItem);
            }
            ret.description = retDescription;
        }
        if (distribution == null) {
            ret.distribution = null;
        } else {
            List<DCatAPDistributionType> retDistribution = new ArrayList<DCatAPDistributionType>();
            for (DCatAPDistributionType aItem: getDistribution()) {
                retDistribution.add(((aItem == null)?null:aItem.clone()));
            }
            ret.distribution = retDistribution;
        }
        ret.format = ((format == null)?null:format.clone());
        if (hasVersion == null) {
            ret.hasVersion = null;
        } else {
            List<DCatAPDatasetType> retHasVersion = new ArrayList<DCatAPDatasetType>();
            for (DCatAPDatasetType aItem: getHasVersion()) {
                retHasVersion.add(((aItem == null)?null:aItem.clone()));
            }
            ret.hasVersion = retHasVersion;
        }
        if (identifier == null) {
            ret.identifier = null;
        } else {
            List<String> retIdentifier = new ArrayList<String>();
            for (String aItem: getIdentifier()) {
                retIdentifier.add(aItem);
            }
            ret.identifier = retIdentifier;
        }
        if (isReferencedBy == null) {
            ret.isReferencedBy = null;
        } else {
            List<Resource> retIsReferencedBy = new ArrayList<Resource>();
            for (Resource aItem: getIsReferencedBy()) {
                retIsReferencedBy.add(((aItem == null)?null:aItem.clone()));
            }
            ret.isReferencedBy = retIsReferencedBy;
        }
        if (isVersionOf == null) {
            ret.isVersionOf = null;
        } else {
            List<DCatAPDatasetType> retIsVersionOf = new ArrayList<DCatAPDatasetType>();
            for (DCatAPDatasetType aItem: getIsVersionOf()) {
                retIsVersionOf.add(((aItem == null)?null:aItem.clone()));
            }
            ret.isVersionOf = retIsVersionOf;
        }
        ret.issued = issued;
        if (keyword == null) {
            ret.keyword = null;
        } else {
            List<PlainLiteral> retKeyword = new ArrayList<PlainLiteral>();
            for (PlainLiteral aItem: getKeyword()) {
                retKeyword.add(((aItem == null)?null:aItem.clone()));
            }
            ret.keyword = retKeyword;
        }
        if (landingPage == null) {
            ret.landingPage = null;
        } else {
            List<FoafDocumentType> retLandingPage = new ArrayList<FoafDocumentType>();
            for (FoafDocumentType aItem: getLandingPage()) {
                retLandingPage.add(((aItem == null)?null:aItem.clone()));
            }
            ret.landingPage = retLandingPage;
        }
        if (language == null) {
            ret.language = null;
        } else {
            List<String> retLanguage = new ArrayList<String>();
            for (String aItem: getLanguage()) {
                retLanguage.add(aItem);
            }
            ret.language = retLanguage;
        }
        ret.modified = modified;
        if (page == null) {
            ret.page = null;
        } else {
            List<FoafDocumentType> retPage = new ArrayList<FoafDocumentType>();
            for (FoafDocumentType aItem: getPage()) {
                retPage.add(((aItem == null)?null:aItem.clone()));
            }
            ret.page = retPage;
        }
        if (provenance == null) {
            ret.provenance = null;
        } else {
            List<DCProvenanceStatementType> retProvenance = new ArrayList<DCProvenanceStatementType>();
            for (DCProvenanceStatementType aItem: getProvenance()) {
                retProvenance.add(((aItem == null)?null:aItem.clone()));
            }
            ret.provenance = retProvenance;
        }
        if (publisher == null) {
            ret.publisher = null;
        } else {
            List<FoafAgentType> retPublisher = new ArrayList<FoafAgentType>();
            for (FoafAgentType aItem: getPublisher()) {
                retPublisher.add(((aItem == null)?null:aItem.clone()));
            }
            ret.publisher = retPublisher;
        }
        if (qualifiedAttribution == null) {
            ret.qualifiedAttribution = null;
        } else {
            List<AttributionType> retQualifiedAttribution = new ArrayList<AttributionType>();
            for (AttributionType aItem: getQualifiedAttribution()) {
                retQualifiedAttribution.add(((aItem == null)?null:aItem.clone()));
            }
            ret.qualifiedAttribution = retQualifiedAttribution;
        }
        if (qualifiedRelation == null) {
            ret.qualifiedRelation = null;
        } else {
            List<DCatAPRelationshipType> retQualifiedRelation = new ArrayList<DCatAPRelationshipType>();
            for (DCatAPRelationshipType aItem: getQualifiedRelation()) {
                retQualifiedRelation.add(((aItem == null)?null:aItem.clone()));
            }
            ret.qualifiedRelation = retQualifiedRelation;
        }
        if (relation == null) {
            ret.relation = null;
        } else {
            List<Object> retRelation = new ArrayList<Object>();
            for (Object aItem: getRelation()) {
                retRelation.add(aItem);
            }
            ret.relation = retRelation;
        }
        if (sample == null) {
            ret.sample = null;
        } else {
            List<DCatAPDistributionType> retSample = new ArrayList<DCatAPDistributionType>();
            for (DCatAPDistributionType aItem: getSample()) {
                retSample.add(((aItem == null)?null:aItem.clone()));
            }
            ret.sample = retSample;
        }
        if (source == null) {
            ret.source = null;
        } else {
            List<ConceptType> retSource = new ArrayList<ConceptType>();
            for (ConceptType aItem: getSource()) {
                retSource.add(((aItem == null)?null:aItem.clone()));
            }
            ret.source = retSource;
        }
        if (spatial == null) {
            ret.spatial = null;
        } else {
            List<DCLocationType> retSpatial = new ArrayList<DCLocationType>();
            for (DCLocationType aItem: getSpatial()) {
                retSpatial.add(((aItem == null)?null:aItem.clone()));
            }
            ret.spatial = retSpatial;
        }
        if (spatialResolutionInMeters == null) {
            ret.spatialResolutionInMeters = null;
        } else {
            List<BigDecimal> retSpatialResolutionInMeters = new ArrayList<BigDecimal>();
            for (BigDecimal aItem: getSpatialResolutionInMeters()) {
                retSpatialResolutionInMeters.add(aItem);
            }
            ret.spatialResolutionInMeters = retSpatialResolutionInMeters;
        }
        if (temporal == null) {
            ret.temporal = null;
        } else {
            List<DCPeriodOfTimeType> retTemporal = new ArrayList<DCPeriodOfTimeType>();
            for (DCPeriodOfTimeType aItem: getTemporal()) {
                retTemporal.add(((aItem == null)?null:aItem.clone()));
            }
            ret.temporal = retTemporal;
        }
        if (temporalResolution == null) {
            ret.temporalResolution = null;
        } else {
            List<Duration> retTemporalResolution = new ArrayList<Duration>();
            for (Duration aItem: getTemporalResolution()) {
                retTemporalResolution.add(aItem);
            }
            ret.temporalResolution = retTemporalResolution;
        }
        if (theme == null) {
            ret.theme = null;
        } else {
            List<ConceptType> retTheme = new ArrayList<ConceptType>();
            for (ConceptType aItem: getTheme()) {
                retTheme.add(((aItem == null)?null:aItem.clone()));
            }
            ret.theme = retTheme;
        }
        if (title == null) {
            ret.title = null;
        } else {
            List<String> retTitle = new ArrayList<String>();
            for (String aItem: getTitle()) {
                retTitle.add(aItem);
            }
            ret.title = retTitle;
        }
        ret.type = type;
        if (versionNotes == null) {
            ret.versionNotes = null;
        } else {
            List<PlainLiteral> retVersionNotes = new ArrayList<PlainLiteral>();
            for (PlainLiteral aItem: getVersionNotes()) {
                retVersionNotes.add(((aItem == null)?null:aItem.clone()));
            }
            ret.versionNotes = retVersionNotes;
        }
        if (wasGeneratedBy == null) {
            ret.wasGeneratedBy = null;
        } else {
            List<ActivityType> retWasGeneratedBy = new ArrayList<ActivityType>();
            for (ActivityType aItem: getWasGeneratedBy()) {
                retWasGeneratedBy.add(((aItem == null)?null:aItem.clone()));
            }
            ret.wasGeneratedBy = retWasGeneratedBy;
        }
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public DCatAPDatasetType clone() {
        DCatAPDatasetType ret = new DCatAPDatasetType();
        cloneTo(ret);
        return ret;
    }

}
