
package eu.toop.edm.jaxb.foaf;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.NormalizedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;


/**
 * <p>Java class for PersonType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="PersonType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{http://xmlns.com/foaf/0.1/}currentProject" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://xmlns.com/foaf/0.1/}lastName" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://xmlns.com/foaf/0.1/}familyName" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://xmlns.com/foaf/0.1/}family_name" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://xmlns.com/foaf/0.1/}firstName" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://xmlns.com/foaf/0.1/}geekcode" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://xmlns.com/foaf/0.1/}img" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://xmlns.com/foaf/0.1/}myersBriggs" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://xmlns.com/foaf/0.1/}pastProject" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://xmlns.com/foaf/0.1/}primaryTopic" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://xmlns.com/foaf/0.1/}publications" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://xmlns.com/foaf/0.1/}schoolInfoHomepage" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://xmlns.com/foaf/0.1/}surname" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://xmlns.com/foaf/0.1/}workInfoHomepage" maxOccurs="unbounded" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "PersonType", propOrder = {
    "currentProject",
    "lastName",
    "familyName",
    "family_Name",
    "firstName",
    "geekcode",
    "img",
    "myersBriggs",
    "pastProject",
    "primaryTopic",
    "publications",
    "schoolInfoHomepage",
    "surname",
    "workInfoHomepage"
})
@CodingStyleguideUnaware
public class FoafPersonType implements Serializable, IExplicitlyCloneable
{

    private List<Object> currentProject;
    private List<String> lastName;
    private List<String> familyName;
    @XmlElement(name = "family_name")
    private List<String> family_Name;
    private List<String> firstName;
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    @XmlSchemaType(name = "normalizedString")
    private List<String> geekcode;
    private List<byte[]> img;
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    @XmlSchemaType(name = "normalizedString")
    private List<String> myersBriggs;
    private List<Object> pastProject;
    private List<Object> primaryTopic;
    private List<FoafDocumentType> publications;
    private List<FoafDocumentType> schoolInfoHomepage;
    private List<String> surname;
    private List<FoafDocumentType> workInfoHomepage;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public FoafPersonType() {
    }

    /**
     * Gets the value of the currentProject property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the currentProject property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getCurrentProject().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Object }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<Object> getCurrentProject() {
        if (currentProject == null) {
            currentProject = new ArrayList<Object>();
        }
        return this.currentProject;
    }

    /**
     * Gets the value of the lastName property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the lastName property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getLastName().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<String> getLastName() {
        if (lastName == null) {
            lastName = new ArrayList<String>();
        }
        return this.lastName;
    }

    /**
     * Gets the value of the familyName property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the familyName property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getFamilyName().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<String> getFamilyName() {
        if (familyName == null) {
            familyName = new ArrayList<String>();
        }
        return this.familyName;
    }

    /**
     * Gets the value of the familyName property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the familyName property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getFamily_Name().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<String> getFamily_Name() {
        if (family_Name == null) {
            family_Name = new ArrayList<String>();
        }
        return this.family_Name;
    }

    /**
     * Gets the value of the firstName property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the firstName property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getFirstName().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<String> getFirstName() {
        if (firstName == null) {
            firstName = new ArrayList<String>();
        }
        return this.firstName;
    }

    /**
     * Gets the value of the geekcode property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the geekcode property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getGeekcode().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<String> getGeekcode() {
        if (geekcode == null) {
            geekcode = new ArrayList<String>();
        }
        return this.geekcode;
    }

    /**
     * Gets the value of the img property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the img property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getImg().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * byte[]
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<byte[]> getImg() {
        if (img == null) {
            img = new ArrayList<byte[]>();
        }
        return this.img;
    }

    /**
     * Gets the value of the myersBriggs property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the myersBriggs property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getMyersBriggs().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<String> getMyersBriggs() {
        if (myersBriggs == null) {
            myersBriggs = new ArrayList<String>();
        }
        return this.myersBriggs;
    }

    /**
     * Gets the value of the pastProject property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the pastProject property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPastProject().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Object }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<Object> getPastProject() {
        if (pastProject == null) {
            pastProject = new ArrayList<Object>();
        }
        return this.pastProject;
    }

    /**
     * Gets the value of the primaryTopic property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the primaryTopic property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPrimaryTopic().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Object }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<Object> getPrimaryTopic() {
        if (primaryTopic == null) {
            primaryTopic = new ArrayList<Object>();
        }
        return this.primaryTopic;
    }

    /**
     * Gets the value of the publications property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the publications property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPublications().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link FoafDocumentType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<FoafDocumentType> getPublications() {
        if (publications == null) {
            publications = new ArrayList<FoafDocumentType>();
        }
        return this.publications;
    }

    /**
     * Gets the value of the schoolInfoHomepage property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the schoolInfoHomepage property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSchoolInfoHomepage().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link FoafDocumentType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<FoafDocumentType> getSchoolInfoHomepage() {
        if (schoolInfoHomepage == null) {
            schoolInfoHomepage = new ArrayList<FoafDocumentType>();
        }
        return this.schoolInfoHomepage;
    }

    /**
     * Gets the value of the surname property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the surname property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSurname().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<String> getSurname() {
        if (surname == null) {
            surname = new ArrayList<String>();
        }
        return this.surname;
    }

    /**
     * Gets the value of the workInfoHomepage property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the workInfoHomepage property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getWorkInfoHomepage().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link FoafDocumentType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<FoafDocumentType> getWorkInfoHomepage() {
        if (workInfoHomepage == null) {
            workInfoHomepage = new ArrayList<FoafDocumentType>();
        }
        return this.workInfoHomepage;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final FoafPersonType rhs = ((FoafPersonType) o);
        if (!EqualsHelper.equalsCollection(currentProject, rhs.currentProject)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(familyName, rhs.familyName)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(family_Name, rhs.family_Name)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(firstName, rhs.firstName)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(geekcode, rhs.geekcode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(img, rhs.img)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(lastName, rhs.lastName)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(myersBriggs, rhs.myersBriggs)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(pastProject, rhs.pastProject)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(primaryTopic, rhs.primaryTopic)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(publications, rhs.publications)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(schoolInfoHomepage, rhs.schoolInfoHomepage)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(surname, rhs.surname)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(workInfoHomepage, rhs.workInfoHomepage)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(currentProject).append(familyName).append(family_Name).append(firstName).append(geekcode).append(img).append(lastName).append(myersBriggs).append(pastProject).append(primaryTopic).append(publications).append(schoolInfoHomepage).append(surname).append(workInfoHomepage).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("currentProject", currentProject).append("familyName", familyName).append("family_Name", family_Name).append("firstName", firstName).append("geekcode", geekcode).append("img", img).append("lastName", lastName).append("myersBriggs", myersBriggs).append("pastProject", pastProject).append("primaryTopic", primaryTopic).append("publications", publications).append("schoolInfoHomepage", schoolInfoHomepage).append("surname", surname).append("workInfoHomepage", workInfoHomepage).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setCurrentProject(
        @Nullable
        final List<Object> aList) {
        currentProject = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setLastName(
        @Nullable
        final List<String> aList) {
        lastName = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setFamilyName(
        @Nullable
        final List<String> aList) {
        familyName = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setFamily_Name(
        @Nullable
        final List<String> aList) {
        family_Name = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setFirstName(
        @Nullable
        final List<String> aList) {
        firstName = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setGeekcode(
        @Nullable
        final List<String> aList) {
        geekcode = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setImg(
        @Nullable
        final List<byte[]> aList) {
        img = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setMyersBriggs(
        @Nullable
        final List<String> aList) {
        myersBriggs = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPastProject(
        @Nullable
        final List<Object> aList) {
        pastProject = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPrimaryTopic(
        @Nullable
        final List<Object> aList) {
        primaryTopic = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPublications(
        @Nullable
        final List<FoafDocumentType> aList) {
        publications = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setSchoolInfoHomepage(
        @Nullable
        final List<FoafDocumentType> aList) {
        schoolInfoHomepage = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setSurname(
        @Nullable
        final List<String> aList) {
        surname = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setWorkInfoHomepage(
        @Nullable
        final List<FoafDocumentType> aList) {
        workInfoHomepage = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasCurrentProjectEntries() {
        return (!getCurrentProject().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoCurrentProjectEntries() {
        return getCurrentProject().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getCurrentProjectCount() {
        return getCurrentProject().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public Object getCurrentProjectAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getCurrentProject().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addCurrentProject(
        @Nonnull
        final Object elem) {
        getCurrentProject().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasLastNameEntries() {
        return (!getLastName().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoLastNameEntries() {
        return getLastName().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getLastNameCount() {
        return getLastName().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public String getLastNameAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getLastName().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addLastName(
        @Nonnull
        final String elem) {
        getLastName().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasFamilyNameEntries() {
        return (!getFamilyName().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoFamilyNameEntries() {
        return getFamilyName().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getFamilyNameCount() {
        return getFamilyName().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public String getFamilyNameAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getFamilyName().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addFamilyName(
        @Nonnull
        final String elem) {
        getFamilyName().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasFamily_NameEntries() {
        return (!getFamily_Name().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoFamily_NameEntries() {
        return getFamily_Name().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getFamily_NameCount() {
        return getFamily_Name().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public String getFamily_NameAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getFamily_Name().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addFamily_Name(
        @Nonnull
        final String elem) {
        getFamily_Name().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasFirstNameEntries() {
        return (!getFirstName().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoFirstNameEntries() {
        return getFirstName().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getFirstNameCount() {
        return getFirstName().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public String getFirstNameAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getFirstName().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addFirstName(
        @Nonnull
        final String elem) {
        getFirstName().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasGeekcodeEntries() {
        return (!getGeekcode().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoGeekcodeEntries() {
        return getGeekcode().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getGeekcodeCount() {
        return getGeekcode().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public String getGeekcodeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getGeekcode().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addGeekcode(
        @Nonnull
        final String elem) {
        getGeekcode().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasImgEntries() {
        return (!getImg().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoImgEntries() {
        return getImg().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getImgCount() {
        return getImg().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public byte[] getImgAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getImg().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addImg(
        @Nonnull
        final byte[] elem) {
        getImg().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasMyersBriggsEntries() {
        return (!getMyersBriggs().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoMyersBriggsEntries() {
        return getMyersBriggs().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getMyersBriggsCount() {
        return getMyersBriggs().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public String getMyersBriggsAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getMyersBriggs().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addMyersBriggs(
        @Nonnull
        final String elem) {
        getMyersBriggs().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPastProjectEntries() {
        return (!getPastProject().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPastProjectEntries() {
        return getPastProject().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPastProjectCount() {
        return getPastProject().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public Object getPastProjectAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPastProject().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPastProject(
        @Nonnull
        final Object elem) {
        getPastProject().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPrimaryTopicEntries() {
        return (!getPrimaryTopic().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPrimaryTopicEntries() {
        return getPrimaryTopic().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPrimaryTopicCount() {
        return getPrimaryTopic().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public Object getPrimaryTopicAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPrimaryTopic().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPrimaryTopic(
        @Nonnull
        final Object elem) {
        getPrimaryTopic().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPublicationsEntries() {
        return (!getPublications().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPublicationsEntries() {
        return getPublications().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPublicationsCount() {
        return getPublications().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public FoafDocumentType getPublicationsAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPublications().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPublications(
        @Nonnull
        final FoafDocumentType elem) {
        getPublications().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasSchoolInfoHomepageEntries() {
        return (!getSchoolInfoHomepage().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoSchoolInfoHomepageEntries() {
        return getSchoolInfoHomepage().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getSchoolInfoHomepageCount() {
        return getSchoolInfoHomepage().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public FoafDocumentType getSchoolInfoHomepageAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getSchoolInfoHomepage().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addSchoolInfoHomepage(
        @Nonnull
        final FoafDocumentType elem) {
        getSchoolInfoHomepage().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasSurnameEntries() {
        return (!getSurname().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoSurnameEntries() {
        return getSurname().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getSurnameCount() {
        return getSurname().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public String getSurnameAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getSurname().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addSurname(
        @Nonnull
        final String elem) {
        getSurname().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasWorkInfoHomepageEntries() {
        return (!getWorkInfoHomepage().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoWorkInfoHomepageEntries() {
        return getWorkInfoHomepage().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getWorkInfoHomepageCount() {
        return getWorkInfoHomepage().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public FoafDocumentType getWorkInfoHomepageAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getWorkInfoHomepage().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addWorkInfoHomepage(
        @Nonnull
        final FoafDocumentType elem) {
        getWorkInfoHomepage().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        FoafPersonType ret) {
        if (currentProject == null) {
            ret.currentProject = null;
        } else {
            List<Object> retCurrentProject = new ArrayList<Object>();
            for (Object aItem: getCurrentProject()) {
                retCurrentProject.add(aItem);
            }
            ret.currentProject = retCurrentProject;
        }
        if (familyName == null) {
            ret.familyName = null;
        } else {
            List<String> retFamilyName = new ArrayList<String>();
            for (String aItem: getFamilyName()) {
                retFamilyName.add(aItem);
            }
            ret.familyName = retFamilyName;
        }
        if (family_Name == null) {
            ret.family_Name = null;
        } else {
            List<String> retFamily_Name = new ArrayList<String>();
            for (String aItem: getFamily_Name()) {
                retFamily_Name.add(aItem);
            }
            ret.family_Name = retFamily_Name;
        }
        if (firstName == null) {
            ret.firstName = null;
        } else {
            List<String> retFirstName = new ArrayList<String>();
            for (String aItem: getFirstName()) {
                retFirstName.add(aItem);
            }
            ret.firstName = retFirstName;
        }
        if (geekcode == null) {
            ret.geekcode = null;
        } else {
            List<String> retGeekcode = new ArrayList<String>();
            for (String aItem: getGeekcode()) {
                retGeekcode.add(aItem);
            }
            ret.geekcode = retGeekcode;
        }
        if (img == null) {
            ret.img = null;
        } else {
            List<byte[]> retImg = new ArrayList<byte[]>();
            for (byte[] aItem: getImg()) {
                retImg.add(ArrayHelper.getCopy(aItem));
            }
            ret.img = retImg;
        }
        if (lastName == null) {
            ret.lastName = null;
        } else {
            List<String> retLastName = new ArrayList<String>();
            for (String aItem: getLastName()) {
                retLastName.add(aItem);
            }
            ret.lastName = retLastName;
        }
        if (myersBriggs == null) {
            ret.myersBriggs = null;
        } else {
            List<String> retMyersBriggs = new ArrayList<String>();
            for (String aItem: getMyersBriggs()) {
                retMyersBriggs.add(aItem);
            }
            ret.myersBriggs = retMyersBriggs;
        }
        if (pastProject == null) {
            ret.pastProject = null;
        } else {
            List<Object> retPastProject = new ArrayList<Object>();
            for (Object aItem: getPastProject()) {
                retPastProject.add(aItem);
            }
            ret.pastProject = retPastProject;
        }
        if (primaryTopic == null) {
            ret.primaryTopic = null;
        } else {
            List<Object> retPrimaryTopic = new ArrayList<Object>();
            for (Object aItem: getPrimaryTopic()) {
                retPrimaryTopic.add(aItem);
            }
            ret.primaryTopic = retPrimaryTopic;
        }
        if (publications == null) {
            ret.publications = null;
        } else {
            List<FoafDocumentType> retPublications = new ArrayList<FoafDocumentType>();
            for (FoafDocumentType aItem: getPublications()) {
                retPublications.add(((aItem == null)?null:aItem.clone()));
            }
            ret.publications = retPublications;
        }
        if (schoolInfoHomepage == null) {
            ret.schoolInfoHomepage = null;
        } else {
            List<FoafDocumentType> retSchoolInfoHomepage = new ArrayList<FoafDocumentType>();
            for (FoafDocumentType aItem: getSchoolInfoHomepage()) {
                retSchoolInfoHomepage.add(((aItem == null)?null:aItem.clone()));
            }
            ret.schoolInfoHomepage = retSchoolInfoHomepage;
        }
        if (surname == null) {
            ret.surname = null;
        } else {
            List<String> retSurname = new ArrayList<String>();
            for (String aItem: getSurname()) {
                retSurname.add(aItem);
            }
            ret.surname = retSurname;
        }
        if (workInfoHomepage == null) {
            ret.workInfoHomepage = null;
        } else {
            List<FoafDocumentType> retWorkInfoHomepage = new ArrayList<FoafDocumentType>();
            for (FoafDocumentType aItem: getWorkInfoHomepage()) {
                retWorkInfoHomepage.add(((aItem == null)?null:aItem.clone()));
            }
            ret.workInfoHomepage = retWorkInfoHomepage;
        }
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public FoafPersonType clone() {
        FoafPersonType ret = new FoafPersonType();
        cloneTo(ret);
        return ret;
    }

}
