
package eu.toop.edm.jaxb.spdx;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;


/**
 * <p>Java class for AlgorithmCodeSimpleType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="AlgorithmCodeSimpleType"&gt;
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string"&gt;
 *     &lt;enumeration value="Md5"/&gt;
 *     &lt;enumeration value="Sha1"/&gt;
 *     &lt;enumeration value="Sha256"/&gt;
 *   &lt;/restriction&gt;
 * &lt;/simpleType&gt;
 * </pre>
 * 
 */
@XmlType(name = "AlgorithmCodeSimpleType")
@XmlEnum
@CodingStyleguideUnaware
public enum AlgorithmCodeSimpleType {


    /**
     * Indicates the algorithm used was MD5
     * 
     */
    @XmlEnumValue("Md5")
    MD_5("Md5"),

    /**
     * Indicates the algorithm used was SHA-1
     * 
     */
    @XmlEnumValue("Sha1")
    SHA_1("Sha1"),

    /**
     * Indicates the algorithm used was SHA256
     * 
     */
    @XmlEnumValue("Sha256")
    SHA_256("Sha256");
    private final String value;

    AlgorithmCodeSimpleType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static AlgorithmCodeSimpleType fromValue(String v) {
        for (AlgorithmCodeSimpleType c: AlgorithmCodeSimpleType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
