
package eu.toop.edm.jaxb.vcard;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.xsds.xlink.XLinkActuateType;
import com.helger.xsds.xlink.XLinkShowType;
import com.helger.xsds.xlink.XLinkTypeType;


/**
 * <p>Java class for binaryElement complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="binaryElement"&gt;
 *   &lt;simpleContent&gt;
 *     &lt;extension base="&lt;http://www.w3.org/2001/XMLSchema&gt;base64Binary"&gt;
 *       &lt;attGroup ref="{http://www.w3.org/1999/xlink}simpleAttrs"/&gt;
 *       &lt;attribute name="ENCODING" default="b"&gt;
 *         &lt;simpleType&gt;
 *           &lt;list&gt;
 *             &lt;simpleType&gt;
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string"&gt;
 *                 &lt;enumeration value="b"/&gt;
 *                 &lt;enumeration value=""/&gt;
 *               &lt;/restriction&gt;
 *             &lt;/simpleType&gt;
 *           &lt;/list&gt;
 *         &lt;/simpleType&gt;
 *       &lt;/attribute&gt;
 *       &lt;attribute name="TYPE" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *       &lt;attribute ref="{http://www.w3.org/XML/1998/namespace}lang"/&gt;
 *     &lt;/extension&gt;
 *   &lt;/simpleContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "binaryElement", propOrder = {
    "value"
})
@CodingStyleguideUnaware
public class BinaryElement implements Serializable, IExplicitlyCloneable
{

    @XmlValue
    private byte[] value;
    @XmlAttribute(name = "ENCODING", namespace = "http://www.w3.org/2001/vcard-rdf/3.0#")
    private List<String> encoding;
    @XmlAttribute(name = "TYPE", namespace = "http://www.w3.org/2001/vcard-rdf/3.0#")
    private String vCardTYPE;
    @XmlAttribute(name = "lang", namespace = "http://www.w3.org/XML/1998/namespace")
    private String lang;
    @XmlAttribute(name = "type", namespace = "http://www.w3.org/1999/xlink")
    private XLinkTypeType type;
    @XmlAttribute(name = "href", namespace = "http://www.w3.org/1999/xlink")
    private String href;
    @XmlAttribute(name = "role", namespace = "http://www.w3.org/1999/xlink")
    private String role;
    @XmlAttribute(name = "arcrole", namespace = "http://www.w3.org/1999/xlink")
    private String arcrole;
    @XmlAttribute(name = "title", namespace = "http://www.w3.org/1999/xlink")
    private String title;
    @XmlAttribute(name = "show", namespace = "http://www.w3.org/1999/xlink")
    private XLinkShowType show;
    @XmlAttribute(name = "actuate", namespace = "http://www.w3.org/1999/xlink")
    private XLinkActuateType actuate;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public BinaryElement() {
    }

    /**
     * Constructor for value of type byte[]<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     */
    public BinaryElement(
        @Nullable
        final byte[] valueParam) {
        setValue(valueParam);
    }

    /**
     * Gets the value of the value property.
     * 
     * @return
     *     possible object is
     *     byte[]
     */
    @Nullable
    public byte[] getValue() {
        return value;
    }

    /**
     * Sets the value of the value property.
     * 
     * @param value
     *     allowed object is
     *     byte[]
     */
    public void setValue(
        @Nullable
        byte[] value) {
        this.value = value;
    }

    /**
     * Gets the value of the encoding property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the encoding property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getENCODING().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<String> getENCODING() {
        if (encoding == null) {
            encoding = new ArrayList<String>();
        }
        return this.encoding;
    }

    /**
     * Gets the value of the vCardTYPE property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getVCardTYPE() {
        return vCardTYPE;
    }

    /**
     * Sets the value of the vCardTYPE property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setVCardTYPE(
        @Nullable
        String value) {
        this.vCardTYPE = value;
    }

    /**
     * Gets the value of the lang property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getLang() {
        return lang;
    }

    /**
     * Sets the value of the lang property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setLang(
        @Nullable
        String value) {
        this.lang = value;
    }

    /**
     * Gets the value of the type property.
     * 
     * @return
     *     possible object is
     *     {@link XLinkTypeType }
     *     
     */
    @Nullable
    public XLinkTypeType getTYPE() {
        return type;
    }

    /**
     * Sets the value of the type property.
     * 
     * @param value
     *     allowed object is
     *     {@link XLinkTypeType }
     *     
     */
    public void setTYPE(
        @Nullable
        XLinkTypeType value) {
        this.type = value;
    }

    /**
     * Gets the value of the href property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getHref() {
        return href;
    }

    /**
     * Sets the value of the href property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setHref(
        @Nullable
        String value) {
        this.href = value;
    }

    /**
     * Gets the value of the role property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getRole() {
        return role;
    }

    /**
     * Sets the value of the role property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setRole(
        @Nullable
        String value) {
        this.role = value;
    }

    /**
     * Gets the value of the arcrole property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getArcrole() {
        return arcrole;
    }

    /**
     * Sets the value of the arcrole property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setArcrole(
        @Nullable
        String value) {
        this.arcrole = value;
    }

    /**
     * Gets the value of the title property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getTitle() {
        return title;
    }

    /**
     * Sets the value of the title property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTitle(
        @Nullable
        String value) {
        this.title = value;
    }

    /**
     * Gets the value of the show property.
     * 
     * @return
     *     possible object is
     *     {@link XLinkShowType }
     *     
     */
    @Nullable
    public XLinkShowType getShow() {
        return show;
    }

    /**
     * Sets the value of the show property.
     * 
     * @param value
     *     allowed object is
     *     {@link XLinkShowType }
     *     
     */
    public void setShow(
        @Nullable
        XLinkShowType value) {
        this.show = value;
    }

    /**
     * Gets the value of the actuate property.
     * 
     * @return
     *     possible object is
     *     {@link XLinkActuateType }
     *     
     */
    @Nullable
    public XLinkActuateType getActuate() {
        return actuate;
    }

    /**
     * Sets the value of the actuate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XLinkActuateType }
     *     
     */
    public void setActuate(
        @Nullable
        XLinkActuateType value) {
        this.actuate = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final BinaryElement rhs = ((BinaryElement) o);
        if (!EqualsHelper.equals(actuate, rhs.actuate)) {
            return false;
        }
        if (!EqualsHelper.equals(arcrole, rhs.arcrole)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(encoding, rhs.encoding)) {
            return false;
        }
        if (!EqualsHelper.equals(href, rhs.href)) {
            return false;
        }
        if (!EqualsHelper.equals(lang, rhs.lang)) {
            return false;
        }
        if (!EqualsHelper.equals(role, rhs.role)) {
            return false;
        }
        if (!EqualsHelper.equals(show, rhs.show)) {
            return false;
        }
        if (!EqualsHelper.equals(title, rhs.title)) {
            return false;
        }
        if (!EqualsHelper.equals(type, rhs.type)) {
            return false;
        }
        if (!EqualsHelper.equals(vCardTYPE, rhs.vCardTYPE)) {
            return false;
        }
        if (!EqualsHelper.equals(value, rhs.value)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(actuate).append(arcrole).append(encoding).append(href).append(lang).append(role).append(show).append(title).append(type).append(vCardTYPE).append(value).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("actuate", actuate).append("arcrole", arcrole).append("encoding", encoding).append("href", href).append("lang", lang).append("role", role).append("show", show).append("title", title).append("type", type).append("vCardTYPE", vCardTYPE).append("value", value).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setENCODING(
        @Nullable
        final List<String> aList) {
        encoding = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasENCODINGEntries() {
        return (!getENCODING().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoENCODINGEntries() {
        return getENCODING().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getENCODINGCount() {
        return getENCODING().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public String getENCODINGAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getENCODING().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addENCODING(
        @Nonnull
        final String elem) {
        getENCODING().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        BinaryElement ret) {
        ret.actuate = actuate;
        ret.arcrole = arcrole;
        if (encoding == null) {
            ret.encoding = null;
        } else {
            List<String> retENCODING = new ArrayList<String>();
            for (String aItem: getENCODING()) {
                retENCODING.add(aItem);
            }
            ret.encoding = retENCODING;
        }
        ret.href = href;
        ret.lang = lang;
        ret.role = role;
        ret.show = show;
        ret.title = title;
        ret.type = type;
        ret.vCardTYPE = vCardTYPE;
        ret.value = ArrayHelper.getCopy(value);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public BinaryElement clone() {
        BinaryElement ret = new BinaryElement();
        cloneTo(ret);
        return ret;
    }

}
