
package eu.toop.edm.jaxb.w3.cv.ac;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import eu.toop.edm.jaxb.w3.cv.bc.LocationGeographicIDType;
import eu.toop.edm.jaxb.w3.cv.bc.LocationGeographicNameType;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ABIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Location. Details&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;An identifiable geographic place.&lt;/ccts:Definition&gt;&lt;ccts:ObjectClass&gt;Core Location&lt;/ccts:ObjectClass&gt;&lt;/ccts:Component&gt;
 * </pre>
 * 
 * 
 * <p>Java class for CoreLocationType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="CoreLocationType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/BasicComponents}LocationGeographicName" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/BasicComponents}LocationGeographicID" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/AggregateComponents}LocationCoreAddress" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/AggregateComponents}LocationGeometry" maxOccurs="unbounded" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CoreLocationType", propOrder = {
    "locationGeographicName",
    "locationGeographicID",
    "locationCoreAddress",
    "locationGeometry"
})
@CodingStyleguideUnaware
public class CoreLocationType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "LocationGeographicName", namespace = "http://www.w3.org/ns/corevocabulary/BasicComponents")
    private LocationGeographicNameType locationGeographicName;
    @XmlElement(name = "LocationGeographicID", namespace = "http://www.w3.org/ns/corevocabulary/BasicComponents")
    private LocationGeographicIDType locationGeographicID;
    @XmlElement(name = "LocationCoreAddress")
    private List<CoreAddressType> locationCoreAddress;
    @XmlElement(name = "LocationGeometry")
    private List<GeometryType> locationGeometry;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public CoreLocationType() {
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Location. Location Geographic_ Name. Text&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A proper noun applied to a spatial object.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Location&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Location Geographic&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Name&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Text&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Text. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link LocationGeographicNameType }
     *     
     */
    @Nullable
    public LocationGeographicNameType getLocationGeographicName() {
        return locationGeographicName;
    }

    /**
     * Sets the value of the locationGeographicName property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocationGeographicNameType }
     *     
     */
    public void setLocationGeographicName(
        @Nullable
        LocationGeographicNameType value) {
        this.locationGeographicName = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Location. Location Geographic_ Identifier. Identifier&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A URI that identifies the location.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Location&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Location Geographic&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Identifier&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Identifier&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Identifier. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link LocationGeographicIDType }
     *     
     */
    @Nullable
    public LocationGeographicIDType getLocationGeographicID() {
        return locationGeographicID;
    }

    /**
     * Sets the value of the locationGeographicID property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocationGeographicIDType }
     *     
     */
    public void setLocationGeographicID(
        @Nullable
        LocationGeographicIDType value) {
        this.locationGeographicID = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Location. Location_ Core Address. Core Address&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;An address representing the location.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Location&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Location&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Core Address&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Core Address&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Core Address&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the locationCoreAddress property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the locationCoreAddress property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getLocationCoreAddress().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CoreAddressType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CoreAddressType> getLocationCoreAddress() {
        if (locationCoreAddress == null) {
            locationCoreAddress = new ArrayList<CoreAddressType>();
        }
        return this.locationCoreAddress;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Location. Location_ Geometry. Geometry&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A geometry representing the location.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Location&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Location&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Geometry&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Geometry&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Geometry&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the locationGeometry property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the locationGeometry property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getLocationGeometry().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link GeometryType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<GeometryType> getLocationGeometry() {
        if (locationGeometry == null) {
            locationGeometry = new ArrayList<GeometryType>();
        }
        return this.locationGeometry;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final CoreLocationType rhs = ((CoreLocationType) o);
        if (!EqualsHelper.equalsCollection(locationCoreAddress, rhs.locationCoreAddress)) {
            return false;
        }
        if (!EqualsHelper.equals(locationGeographicID, rhs.locationGeographicID)) {
            return false;
        }
        if (!EqualsHelper.equals(locationGeographicName, rhs.locationGeographicName)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(locationGeometry, rhs.locationGeometry)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(locationCoreAddress).append(locationGeographicID).append(locationGeographicName).append(locationGeometry).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("locationCoreAddress", locationCoreAddress).append("locationGeographicID", locationGeographicID).append("locationGeographicName", locationGeographicName).append("locationGeometry", locationGeometry).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setLocationCoreAddress(
        @Nullable
        final List<CoreAddressType> aList) {
        locationCoreAddress = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setLocationGeometry(
        @Nullable
        final List<GeometryType> aList) {
        locationGeometry = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasLocationCoreAddressEntries() {
        return (!getLocationCoreAddress().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoLocationCoreAddressEntries() {
        return getLocationCoreAddress().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getLocationCoreAddressCount() {
        return getLocationCoreAddress().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CoreAddressType getLocationCoreAddressAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getLocationCoreAddress().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addLocationCoreAddress(
        @Nonnull
        final CoreAddressType elem) {
        getLocationCoreAddress().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasLocationGeometryEntries() {
        return (!getLocationGeometry().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoLocationGeometryEntries() {
        return getLocationGeometry().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getLocationGeometryCount() {
        return getLocationGeometry().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public GeometryType getLocationGeometryAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getLocationGeometry().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addLocationGeometry(
        @Nonnull
        final GeometryType elem) {
        getLocationGeometry().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        CoreLocationType ret) {
        if (locationCoreAddress == null) {
            ret.locationCoreAddress = null;
        } else {
            List<CoreAddressType> retLocationCoreAddress = new ArrayList<CoreAddressType>();
            for (CoreAddressType aItem: getLocationCoreAddress()) {
                retLocationCoreAddress.add(((aItem == null)?null:aItem.clone()));
            }
            ret.locationCoreAddress = retLocationCoreAddress;
        }
        ret.locationGeographicID = ((locationGeographicID == null)?null:locationGeographicID.clone());
        ret.locationGeographicName = ((locationGeographicName == null)?null:locationGeographicName.clone());
        if (locationGeometry == null) {
            ret.locationGeometry = null;
        } else {
            List<GeometryType> retLocationGeometry = new ArrayList<GeometryType>();
            for (GeometryType aItem: getLocationGeometry()) {
                retLocationGeometry.add(((aItem == null)?null:aItem.clone()));
            }
            ret.locationGeometry = retLocationGeometry;
        }
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public CoreLocationType clone() {
        CoreLocationType ret = new CoreLocationType();
        cloneTo(ret);
        return ret;
    }

}
