
package eu.toop.edm.jaxb.w3.cv.ac;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import eu.toop.edm.jaxb.w3.cv.bc.PersonAlternativeNameType;
import eu.toop.edm.jaxb.w3.cv.bc.PersonBirthDateType;
import eu.toop.edm.jaxb.w3.cv.bc.PersonBirthNameType;
import eu.toop.edm.jaxb.w3.cv.bc.PersonDeathDateType;
import eu.toop.edm.jaxb.w3.cv.bc.PersonFamilyNameType;
import eu.toop.edm.jaxb.w3.cv.bc.PersonFullNameType;
import eu.toop.edm.jaxb.w3.cv.bc.PersonGenderCodeType;
import eu.toop.edm.jaxb.w3.cv.bc.PersonGivenNameType;
import eu.toop.edm.jaxb.w3.cv.bc.PersonIDType;
import eu.toop.edm.jaxb.w3.cv.bc.PersonPatronymicNameType;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ABIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Person. Details&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A natural person.&lt;/ccts:Definition&gt;&lt;ccts:ObjectClass&gt;Core Person&lt;/ccts:ObjectClass&gt;&lt;/ccts:Component&gt;
 * </pre>
 * 
 * 
 * <p>Java class for CorePersonType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="CorePersonType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/BasicComponents}PersonID" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/BasicComponents}PersonFullName" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/BasicComponents}PersonFamilyName" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/BasicComponents}PersonGivenName" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/BasicComponents}PersonPatronymicName" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/BasicComponents}PersonAlternativeName" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/BasicComponents}PersonGenderCode" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/BasicComponents}PersonBirthName" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/BasicComponents}PersonBirthDate" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/BasicComponents}PersonDeathDate" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/AggregateComponents}PersonCountryOfBirthCoreLocation" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/AggregateComponents}PersonCountryOfDeathCoreLocation" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/AggregateComponents}PersonPlaceOfBirthCoreLocation" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/AggregateComponents}PersonPlaceOfDeathCoreLocation" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/AggregateComponents}PersonCitizenshipJurisdiction" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/AggregateComponents}PersonResidencyJurisdiction" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/AggregateComponents}PersonCoreAddress" maxOccurs="unbounded" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CorePersonType", propOrder = {
    "personID",
    "personFullName",
    "personFamilyName",
    "personGivenName",
    "personPatronymicName",
    "personAlternativeName",
    "personGenderCode",
    "personBirthName",
    "personBirthDate",
    "personDeathDate",
    "personCountryOfBirthCoreLocation",
    "personCountryOfDeathCoreLocation",
    "personPlaceOfBirthCoreLocation",
    "personPlaceOfDeathCoreLocation",
    "personCitizenshipJurisdiction",
    "personResidencyJurisdiction",
    "personCoreAddress"
})
@CodingStyleguideUnaware
public class CorePersonType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "PersonID", namespace = "http://www.w3.org/ns/corevocabulary/BasicComponents")
    private List<PersonIDType> personID;
    @XmlElement(name = "PersonFullName", namespace = "http://www.w3.org/ns/corevocabulary/BasicComponents")
    private List<PersonFullNameType> personFullName;
    @XmlElement(name = "PersonFamilyName", namespace = "http://www.w3.org/ns/corevocabulary/BasicComponents")
    private List<PersonFamilyNameType> personFamilyName;
    @XmlElement(name = "PersonGivenName", namespace = "http://www.w3.org/ns/corevocabulary/BasicComponents")
    private List<PersonGivenNameType> personGivenName;
    @XmlElement(name = "PersonPatronymicName", namespace = "http://www.w3.org/ns/corevocabulary/BasicComponents")
    private List<PersonPatronymicNameType> personPatronymicName;
    @XmlElement(name = "PersonAlternativeName", namespace = "http://www.w3.org/ns/corevocabulary/BasicComponents")
    private List<PersonAlternativeNameType> personAlternativeName;
    @XmlElement(name = "PersonGenderCode", namespace = "http://www.w3.org/ns/corevocabulary/BasicComponents")
    private List<PersonGenderCodeType> personGenderCode;
    @XmlElement(name = "PersonBirthName", namespace = "http://www.w3.org/ns/corevocabulary/BasicComponents")
    private List<PersonBirthNameType> personBirthName;
    @XmlElement(name = "PersonBirthDate", namespace = "http://www.w3.org/ns/corevocabulary/BasicComponents")
    private List<PersonBirthDateType> personBirthDate;
    @XmlElement(name = "PersonDeathDate", namespace = "http://www.w3.org/ns/corevocabulary/BasicComponents")
    private List<PersonDeathDateType> personDeathDate;
    @XmlElement(name = "PersonCountryOfBirthCoreLocation")
    private List<CoreLocationType> personCountryOfBirthCoreLocation;
    @XmlElement(name = "PersonCountryOfDeathCoreLocation")
    private List<CoreLocationType> personCountryOfDeathCoreLocation;
    @XmlElement(name = "PersonPlaceOfBirthCoreLocation")
    private List<CoreLocationType> personPlaceOfBirthCoreLocation;
    @XmlElement(name = "PersonPlaceOfDeathCoreLocation")
    private List<CoreLocationType> personPlaceOfDeathCoreLocation;
    @XmlElement(name = "PersonCitizenshipJurisdiction")
    private List<JurisdictionType> personCitizenshipJurisdiction;
    @XmlElement(name = "PersonResidencyJurisdiction")
    private List<JurisdictionType> personResidencyJurisdiction;
    @XmlElement(name = "PersonCoreAddress")
    private List<CoreAddressType> personCoreAddress;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public CorePersonType() {
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Person. Person Identifier. Identifier&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A formally-issued identifier for the person.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Person&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Person Identifier&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Identifier&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Identifier. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the personID property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the personID property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPersonID().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PersonIDType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PersonIDType> getPersonID() {
        if (personID == null) {
            personID = new ArrayList<PersonIDType>();
        }
        return this.personID;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Person. Person_ Full Name. Name&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The complete name of the person as one string.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Person&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Person&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Full Name&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Name&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Name. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the personFullName property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the personFullName property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPersonFullName().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PersonFullNameType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PersonFullNameType> getPersonFullName() {
        if (personFullName == null) {
            personFullName = new ArrayList<PersonFullNameType>();
        }
        return this.personFullName;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Person. Person_ Family Name. Name&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The denominator(s) that identify the person within a family.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Person&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Person&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Family Name&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Name&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Name. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the personFamilyName property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the personFamilyName property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPersonFamilyName().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PersonFamilyNameType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PersonFamilyNameType> getPersonFamilyName() {
        if (personFamilyName == null) {
            personFamilyName = new ArrayList<PersonFamilyNameType>();
        }
        return this.personFamilyName;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Person. Person_ Given Name. Name&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A name that is usually shared by members of a family.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Person&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Person&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Given Name&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Name&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Name. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the personGivenName property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the personGivenName property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPersonGivenName().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PersonGivenNameType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PersonGivenNameType> getPersonGivenName() {
        if (personGivenName == null) {
            personGivenName = new ArrayList<PersonGivenNameType>();
        }
        return this.personGivenName;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Person. Person_ Patronymic Name. Name&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A name referring to the father's given name.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Person&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Person&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Patronymic Name&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Name&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Name. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the personPatronymicName property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the personPatronymicName property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPersonPatronymicName().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PersonPatronymicNameType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PersonPatronymicNameType> getPersonPatronymicName() {
        if (personPatronymicName == null) {
            personPatronymicName = new ArrayList<PersonPatronymicNameType>();
        }
        return this.personPatronymicName;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Person. Person_ Alternative Name. Name&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A name by which the person is known other than her given name and/or full name.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Person&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Person&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Alternative Name&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Name&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Name. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the personAlternativeName property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the personAlternativeName property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPersonAlternativeName().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PersonAlternativeNameType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PersonAlternativeNameType> getPersonAlternativeName() {
        if (personAlternativeName == null) {
            personAlternativeName = new ArrayList<PersonAlternativeNameType>();
        }
        return this.personAlternativeName;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Person. Person_ Gender Code. Code&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The gender of the person.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Person&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Person&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Gender Code&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Code&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Code. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the personGenderCode property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the personGenderCode property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPersonGenderCode().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PersonGenderCodeType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PersonGenderCodeType> getPersonGenderCode() {
        if (personGenderCode == null) {
            personGenderCode = new ArrayList<PersonGenderCodeType>();
        }
        return this.personGenderCode;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Person. Person_ Birth Name. Name&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The full name of the person at the time of her birth, irrespective of any subsequent changes.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Person&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Person&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Birth Name&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Name&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Name. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the personBirthName property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the personBirthName property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPersonBirthName().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PersonBirthNameType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PersonBirthNameType> getPersonBirthName() {
        if (personBirthName == null) {
            personBirthName = new ArrayList<PersonBirthNameType>();
        }
        return this.personBirthName;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Person. Person_ Birth Date. Date&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The date on which the person was born.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Person&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Person&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Birth Date&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Date&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Date. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the personBirthDate property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the personBirthDate property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPersonBirthDate().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PersonBirthDateType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PersonBirthDateType> getPersonBirthDate() {
        if (personBirthDate == null) {
            personBirthDate = new ArrayList<PersonBirthDateType>();
        }
        return this.personBirthDate;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Person. Person_ Death Date. Date&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The date on which the person deceased.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Person&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Person&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Death Date&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Date&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Date. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the personDeathDate property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the personDeathDate property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPersonDeathDate().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PersonDeathDateType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PersonDeathDateType> getPersonDeathDate() {
        if (personDeathDate == null) {
            personDeathDate = new ArrayList<PersonDeathDateType>();
        }
        return this.personDeathDate;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Person. Person Country Of Birth_ Core Location. Core Location&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The country where the person was born.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Person&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Person Country Of Birth&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Core Location&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Core Location&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Core Location&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the personCountryOfBirthCoreLocation property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the personCountryOfBirthCoreLocation property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPersonCountryOfBirthCoreLocation().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CoreLocationType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CoreLocationType> getPersonCountryOfBirthCoreLocation() {
        if (personCountryOfBirthCoreLocation == null) {
            personCountryOfBirthCoreLocation = new ArrayList<CoreLocationType>();
        }
        return this.personCountryOfBirthCoreLocation;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Person. Person Country Of Death_ Core Location. Core Location&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The country where the person deceased.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Person&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Person Country Of Death&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Core Location&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Core Location&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Core Location&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the personCountryOfDeathCoreLocation property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the personCountryOfDeathCoreLocation property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPersonCountryOfDeathCoreLocation().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CoreLocationType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CoreLocationType> getPersonCountryOfDeathCoreLocation() {
        if (personCountryOfDeathCoreLocation == null) {
            personCountryOfDeathCoreLocation = new ArrayList<CoreLocationType>();
        }
        return this.personCountryOfDeathCoreLocation;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Person. Person Place Of Birth_ Core Location. Core Location&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The location where the person was born.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Person&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Person Place Of Birth&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Core Location&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Core Location&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Core Location&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the personPlaceOfBirthCoreLocation property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the personPlaceOfBirthCoreLocation property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPersonPlaceOfBirthCoreLocation().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CoreLocationType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CoreLocationType> getPersonPlaceOfBirthCoreLocation() {
        if (personPlaceOfBirthCoreLocation == null) {
            personPlaceOfBirthCoreLocation = new ArrayList<CoreLocationType>();
        }
        return this.personPlaceOfBirthCoreLocation;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Person. Person Place Of Death_ Core Location. Core Location&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The location where the person deceased.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Person&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Person Place Of Death&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Core Location&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Core Location&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Core Location&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the personPlaceOfDeathCoreLocation property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the personPlaceOfDeathCoreLocation property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPersonPlaceOfDeathCoreLocation().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CoreLocationType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CoreLocationType> getPersonPlaceOfDeathCoreLocation() {
        if (personPlaceOfDeathCoreLocation == null) {
            personPlaceOfDeathCoreLocation = new ArrayList<CoreLocationType>();
        }
        return this.personPlaceOfDeathCoreLocation;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Person. Person Citizenship_ Jurisdiction. Jurisdiction&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The jurisdiction that has conferred citizenship rights on the person.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Person&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Person Citizenship&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Jurisdiction&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Jurisdiction&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Jurisdiction&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the personCitizenshipJurisdiction property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the personCitizenshipJurisdiction property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPersonCitizenshipJurisdiction().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JurisdictionType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<JurisdictionType> getPersonCitizenshipJurisdiction() {
        if (personCitizenshipJurisdiction == null) {
            personCitizenshipJurisdiction = new ArrayList<JurisdictionType>();
        }
        return this.personCitizenshipJurisdiction;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Person. Person Residency_ Jurisdiction. Jurisdiction&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The jurisdiction in which the person resides, typically providing the person with a subset of the rights of a citizen.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Person&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Person Residency&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Jurisdiction&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Jurisdiction&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Jurisdiction&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the personResidencyJurisdiction property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the personResidencyJurisdiction property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPersonResidencyJurisdiction().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JurisdictionType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<JurisdictionType> getPersonResidencyJurisdiction() {
        if (personResidencyJurisdiction == null) {
            personResidencyJurisdiction = new ArrayList<JurisdictionType>();
        }
        return this.personResidencyJurisdiction;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Person. Person_ Core Address. Core Address&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;An address related to the person.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Person&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Person&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Core Address&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Core Address&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Core Address&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the personCoreAddress property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the personCoreAddress property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPersonCoreAddress().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CoreAddressType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CoreAddressType> getPersonCoreAddress() {
        if (personCoreAddress == null) {
            personCoreAddress = new ArrayList<CoreAddressType>();
        }
        return this.personCoreAddress;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final CorePersonType rhs = ((CorePersonType) o);
        if (!EqualsHelper.equalsCollection(personAlternativeName, rhs.personAlternativeName)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(personBirthDate, rhs.personBirthDate)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(personBirthName, rhs.personBirthName)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(personCitizenshipJurisdiction, rhs.personCitizenshipJurisdiction)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(personCoreAddress, rhs.personCoreAddress)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(personCountryOfBirthCoreLocation, rhs.personCountryOfBirthCoreLocation)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(personCountryOfDeathCoreLocation, rhs.personCountryOfDeathCoreLocation)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(personDeathDate, rhs.personDeathDate)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(personFamilyName, rhs.personFamilyName)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(personFullName, rhs.personFullName)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(personGenderCode, rhs.personGenderCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(personGivenName, rhs.personGivenName)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(personID, rhs.personID)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(personPatronymicName, rhs.personPatronymicName)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(personPlaceOfBirthCoreLocation, rhs.personPlaceOfBirthCoreLocation)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(personPlaceOfDeathCoreLocation, rhs.personPlaceOfDeathCoreLocation)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(personResidencyJurisdiction, rhs.personResidencyJurisdiction)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(personAlternativeName).append(personBirthDate).append(personBirthName).append(personCitizenshipJurisdiction).append(personCoreAddress).append(personCountryOfBirthCoreLocation).append(personCountryOfDeathCoreLocation).append(personDeathDate).append(personFamilyName).append(personFullName).append(personGenderCode).append(personGivenName).append(personID).append(personPatronymicName).append(personPlaceOfBirthCoreLocation).append(personPlaceOfDeathCoreLocation).append(personResidencyJurisdiction).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("personAlternativeName", personAlternativeName).append("personBirthDate", personBirthDate).append("personBirthName", personBirthName).append("personCitizenshipJurisdiction", personCitizenshipJurisdiction).append("personCoreAddress", personCoreAddress).append("personCountryOfBirthCoreLocation", personCountryOfBirthCoreLocation).append("personCountryOfDeathCoreLocation", personCountryOfDeathCoreLocation).append("personDeathDate", personDeathDate).append("personFamilyName", personFamilyName).append("personFullName", personFullName).append("personGenderCode", personGenderCode).append("personGivenName", personGivenName).append("personID", personID).append("personPatronymicName", personPatronymicName).append("personPlaceOfBirthCoreLocation", personPlaceOfBirthCoreLocation).append("personPlaceOfDeathCoreLocation", personPlaceOfDeathCoreLocation).append("personResidencyJurisdiction", personResidencyJurisdiction).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPersonID(
        @Nullable
        final List<PersonIDType> aList) {
        personID = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPersonFullName(
        @Nullable
        final List<PersonFullNameType> aList) {
        personFullName = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPersonFamilyName(
        @Nullable
        final List<PersonFamilyNameType> aList) {
        personFamilyName = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPersonGivenName(
        @Nullable
        final List<PersonGivenNameType> aList) {
        personGivenName = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPersonPatronymicName(
        @Nullable
        final List<PersonPatronymicNameType> aList) {
        personPatronymicName = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPersonAlternativeName(
        @Nullable
        final List<PersonAlternativeNameType> aList) {
        personAlternativeName = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPersonGenderCode(
        @Nullable
        final List<PersonGenderCodeType> aList) {
        personGenderCode = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPersonBirthName(
        @Nullable
        final List<PersonBirthNameType> aList) {
        personBirthName = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPersonBirthDate(
        @Nullable
        final List<PersonBirthDateType> aList) {
        personBirthDate = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPersonDeathDate(
        @Nullable
        final List<PersonDeathDateType> aList) {
        personDeathDate = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPersonCountryOfBirthCoreLocation(
        @Nullable
        final List<CoreLocationType> aList) {
        personCountryOfBirthCoreLocation = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPersonCountryOfDeathCoreLocation(
        @Nullable
        final List<CoreLocationType> aList) {
        personCountryOfDeathCoreLocation = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPersonPlaceOfBirthCoreLocation(
        @Nullable
        final List<CoreLocationType> aList) {
        personPlaceOfBirthCoreLocation = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPersonPlaceOfDeathCoreLocation(
        @Nullable
        final List<CoreLocationType> aList) {
        personPlaceOfDeathCoreLocation = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPersonCitizenshipJurisdiction(
        @Nullable
        final List<JurisdictionType> aList) {
        personCitizenshipJurisdiction = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPersonResidencyJurisdiction(
        @Nullable
        final List<JurisdictionType> aList) {
        personResidencyJurisdiction = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPersonCoreAddress(
        @Nullable
        final List<CoreAddressType> aList) {
        personCoreAddress = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPersonIDEntries() {
        return (!getPersonID().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPersonIDEntries() {
        return getPersonID().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPersonIDCount() {
        return getPersonID().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PersonIDType getPersonIDAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPersonID().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPersonID(
        @Nonnull
        final PersonIDType elem) {
        getPersonID().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPersonFullNameEntries() {
        return (!getPersonFullName().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPersonFullNameEntries() {
        return getPersonFullName().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPersonFullNameCount() {
        return getPersonFullName().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PersonFullNameType getPersonFullNameAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPersonFullName().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPersonFullName(
        @Nonnull
        final PersonFullNameType elem) {
        getPersonFullName().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPersonFamilyNameEntries() {
        return (!getPersonFamilyName().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPersonFamilyNameEntries() {
        return getPersonFamilyName().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPersonFamilyNameCount() {
        return getPersonFamilyName().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PersonFamilyNameType getPersonFamilyNameAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPersonFamilyName().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPersonFamilyName(
        @Nonnull
        final PersonFamilyNameType elem) {
        getPersonFamilyName().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPersonGivenNameEntries() {
        return (!getPersonGivenName().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPersonGivenNameEntries() {
        return getPersonGivenName().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPersonGivenNameCount() {
        return getPersonGivenName().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PersonGivenNameType getPersonGivenNameAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPersonGivenName().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPersonGivenName(
        @Nonnull
        final PersonGivenNameType elem) {
        getPersonGivenName().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPersonPatronymicNameEntries() {
        return (!getPersonPatronymicName().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPersonPatronymicNameEntries() {
        return getPersonPatronymicName().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPersonPatronymicNameCount() {
        return getPersonPatronymicName().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PersonPatronymicNameType getPersonPatronymicNameAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPersonPatronymicName().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPersonPatronymicName(
        @Nonnull
        final PersonPatronymicNameType elem) {
        getPersonPatronymicName().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPersonAlternativeNameEntries() {
        return (!getPersonAlternativeName().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPersonAlternativeNameEntries() {
        return getPersonAlternativeName().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPersonAlternativeNameCount() {
        return getPersonAlternativeName().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PersonAlternativeNameType getPersonAlternativeNameAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPersonAlternativeName().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPersonAlternativeName(
        @Nonnull
        final PersonAlternativeNameType elem) {
        getPersonAlternativeName().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPersonGenderCodeEntries() {
        return (!getPersonGenderCode().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPersonGenderCodeEntries() {
        return getPersonGenderCode().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPersonGenderCodeCount() {
        return getPersonGenderCode().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PersonGenderCodeType getPersonGenderCodeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPersonGenderCode().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPersonGenderCode(
        @Nonnull
        final PersonGenderCodeType elem) {
        getPersonGenderCode().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPersonBirthNameEntries() {
        return (!getPersonBirthName().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPersonBirthNameEntries() {
        return getPersonBirthName().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPersonBirthNameCount() {
        return getPersonBirthName().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PersonBirthNameType getPersonBirthNameAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPersonBirthName().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPersonBirthName(
        @Nonnull
        final PersonBirthNameType elem) {
        getPersonBirthName().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPersonBirthDateEntries() {
        return (!getPersonBirthDate().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPersonBirthDateEntries() {
        return getPersonBirthDate().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPersonBirthDateCount() {
        return getPersonBirthDate().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PersonBirthDateType getPersonBirthDateAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPersonBirthDate().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPersonBirthDate(
        @Nonnull
        final PersonBirthDateType elem) {
        getPersonBirthDate().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPersonDeathDateEntries() {
        return (!getPersonDeathDate().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPersonDeathDateEntries() {
        return getPersonDeathDate().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPersonDeathDateCount() {
        return getPersonDeathDate().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PersonDeathDateType getPersonDeathDateAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPersonDeathDate().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPersonDeathDate(
        @Nonnull
        final PersonDeathDateType elem) {
        getPersonDeathDate().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPersonCountryOfBirthCoreLocationEntries() {
        return (!getPersonCountryOfBirthCoreLocation().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPersonCountryOfBirthCoreLocationEntries() {
        return getPersonCountryOfBirthCoreLocation().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPersonCountryOfBirthCoreLocationCount() {
        return getPersonCountryOfBirthCoreLocation().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CoreLocationType getPersonCountryOfBirthCoreLocationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPersonCountryOfBirthCoreLocation().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPersonCountryOfBirthCoreLocation(
        @Nonnull
        final CoreLocationType elem) {
        getPersonCountryOfBirthCoreLocation().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPersonCountryOfDeathCoreLocationEntries() {
        return (!getPersonCountryOfDeathCoreLocation().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPersonCountryOfDeathCoreLocationEntries() {
        return getPersonCountryOfDeathCoreLocation().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPersonCountryOfDeathCoreLocationCount() {
        return getPersonCountryOfDeathCoreLocation().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CoreLocationType getPersonCountryOfDeathCoreLocationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPersonCountryOfDeathCoreLocation().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPersonCountryOfDeathCoreLocation(
        @Nonnull
        final CoreLocationType elem) {
        getPersonCountryOfDeathCoreLocation().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPersonPlaceOfBirthCoreLocationEntries() {
        return (!getPersonPlaceOfBirthCoreLocation().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPersonPlaceOfBirthCoreLocationEntries() {
        return getPersonPlaceOfBirthCoreLocation().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPersonPlaceOfBirthCoreLocationCount() {
        return getPersonPlaceOfBirthCoreLocation().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CoreLocationType getPersonPlaceOfBirthCoreLocationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPersonPlaceOfBirthCoreLocation().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPersonPlaceOfBirthCoreLocation(
        @Nonnull
        final CoreLocationType elem) {
        getPersonPlaceOfBirthCoreLocation().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPersonPlaceOfDeathCoreLocationEntries() {
        return (!getPersonPlaceOfDeathCoreLocation().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPersonPlaceOfDeathCoreLocationEntries() {
        return getPersonPlaceOfDeathCoreLocation().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPersonPlaceOfDeathCoreLocationCount() {
        return getPersonPlaceOfDeathCoreLocation().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CoreLocationType getPersonPlaceOfDeathCoreLocationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPersonPlaceOfDeathCoreLocation().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPersonPlaceOfDeathCoreLocation(
        @Nonnull
        final CoreLocationType elem) {
        getPersonPlaceOfDeathCoreLocation().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPersonCitizenshipJurisdictionEntries() {
        return (!getPersonCitizenshipJurisdiction().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPersonCitizenshipJurisdictionEntries() {
        return getPersonCitizenshipJurisdiction().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPersonCitizenshipJurisdictionCount() {
        return getPersonCitizenshipJurisdiction().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public JurisdictionType getPersonCitizenshipJurisdictionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPersonCitizenshipJurisdiction().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPersonCitizenshipJurisdiction(
        @Nonnull
        final JurisdictionType elem) {
        getPersonCitizenshipJurisdiction().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPersonResidencyJurisdictionEntries() {
        return (!getPersonResidencyJurisdiction().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPersonResidencyJurisdictionEntries() {
        return getPersonResidencyJurisdiction().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPersonResidencyJurisdictionCount() {
        return getPersonResidencyJurisdiction().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public JurisdictionType getPersonResidencyJurisdictionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPersonResidencyJurisdiction().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPersonResidencyJurisdiction(
        @Nonnull
        final JurisdictionType elem) {
        getPersonResidencyJurisdiction().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPersonCoreAddressEntries() {
        return (!getPersonCoreAddress().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPersonCoreAddressEntries() {
        return getPersonCoreAddress().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPersonCoreAddressCount() {
        return getPersonCoreAddress().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CoreAddressType getPersonCoreAddressAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPersonCoreAddress().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPersonCoreAddress(
        @Nonnull
        final CoreAddressType elem) {
        getPersonCoreAddress().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        CorePersonType ret) {
        if (personAlternativeName == null) {
            ret.personAlternativeName = null;
        } else {
            List<PersonAlternativeNameType> retPersonAlternativeName = new ArrayList<PersonAlternativeNameType>();
            for (PersonAlternativeNameType aItem: getPersonAlternativeName()) {
                retPersonAlternativeName.add(((aItem == null)?null:aItem.clone()));
            }
            ret.personAlternativeName = retPersonAlternativeName;
        }
        if (personBirthDate == null) {
            ret.personBirthDate = null;
        } else {
            List<PersonBirthDateType> retPersonBirthDate = new ArrayList<PersonBirthDateType>();
            for (PersonBirthDateType aItem: getPersonBirthDate()) {
                retPersonBirthDate.add(((aItem == null)?null:aItem.clone()));
            }
            ret.personBirthDate = retPersonBirthDate;
        }
        if (personBirthName == null) {
            ret.personBirthName = null;
        } else {
            List<PersonBirthNameType> retPersonBirthName = new ArrayList<PersonBirthNameType>();
            for (PersonBirthNameType aItem: getPersonBirthName()) {
                retPersonBirthName.add(((aItem == null)?null:aItem.clone()));
            }
            ret.personBirthName = retPersonBirthName;
        }
        if (personCitizenshipJurisdiction == null) {
            ret.personCitizenshipJurisdiction = null;
        } else {
            List<JurisdictionType> retPersonCitizenshipJurisdiction = new ArrayList<JurisdictionType>();
            for (JurisdictionType aItem: getPersonCitizenshipJurisdiction()) {
                retPersonCitizenshipJurisdiction.add(((aItem == null)?null:aItem.clone()));
            }
            ret.personCitizenshipJurisdiction = retPersonCitizenshipJurisdiction;
        }
        if (personCoreAddress == null) {
            ret.personCoreAddress = null;
        } else {
            List<CoreAddressType> retPersonCoreAddress = new ArrayList<CoreAddressType>();
            for (CoreAddressType aItem: getPersonCoreAddress()) {
                retPersonCoreAddress.add(((aItem == null)?null:aItem.clone()));
            }
            ret.personCoreAddress = retPersonCoreAddress;
        }
        if (personCountryOfBirthCoreLocation == null) {
            ret.personCountryOfBirthCoreLocation = null;
        } else {
            List<CoreLocationType> retPersonCountryOfBirthCoreLocation = new ArrayList<CoreLocationType>();
            for (CoreLocationType aItem: getPersonCountryOfBirthCoreLocation()) {
                retPersonCountryOfBirthCoreLocation.add(((aItem == null)?null:aItem.clone()));
            }
            ret.personCountryOfBirthCoreLocation = retPersonCountryOfBirthCoreLocation;
        }
        if (personCountryOfDeathCoreLocation == null) {
            ret.personCountryOfDeathCoreLocation = null;
        } else {
            List<CoreLocationType> retPersonCountryOfDeathCoreLocation = new ArrayList<CoreLocationType>();
            for (CoreLocationType aItem: getPersonCountryOfDeathCoreLocation()) {
                retPersonCountryOfDeathCoreLocation.add(((aItem == null)?null:aItem.clone()));
            }
            ret.personCountryOfDeathCoreLocation = retPersonCountryOfDeathCoreLocation;
        }
        if (personDeathDate == null) {
            ret.personDeathDate = null;
        } else {
            List<PersonDeathDateType> retPersonDeathDate = new ArrayList<PersonDeathDateType>();
            for (PersonDeathDateType aItem: getPersonDeathDate()) {
                retPersonDeathDate.add(((aItem == null)?null:aItem.clone()));
            }
            ret.personDeathDate = retPersonDeathDate;
        }
        if (personFamilyName == null) {
            ret.personFamilyName = null;
        } else {
            List<PersonFamilyNameType> retPersonFamilyName = new ArrayList<PersonFamilyNameType>();
            for (PersonFamilyNameType aItem: getPersonFamilyName()) {
                retPersonFamilyName.add(((aItem == null)?null:aItem.clone()));
            }
            ret.personFamilyName = retPersonFamilyName;
        }
        if (personFullName == null) {
            ret.personFullName = null;
        } else {
            List<PersonFullNameType> retPersonFullName = new ArrayList<PersonFullNameType>();
            for (PersonFullNameType aItem: getPersonFullName()) {
                retPersonFullName.add(((aItem == null)?null:aItem.clone()));
            }
            ret.personFullName = retPersonFullName;
        }
        if (personGenderCode == null) {
            ret.personGenderCode = null;
        } else {
            List<PersonGenderCodeType> retPersonGenderCode = new ArrayList<PersonGenderCodeType>();
            for (PersonGenderCodeType aItem: getPersonGenderCode()) {
                retPersonGenderCode.add(((aItem == null)?null:aItem.clone()));
            }
            ret.personGenderCode = retPersonGenderCode;
        }
        if (personGivenName == null) {
            ret.personGivenName = null;
        } else {
            List<PersonGivenNameType> retPersonGivenName = new ArrayList<PersonGivenNameType>();
            for (PersonGivenNameType aItem: getPersonGivenName()) {
                retPersonGivenName.add(((aItem == null)?null:aItem.clone()));
            }
            ret.personGivenName = retPersonGivenName;
        }
        if (personID == null) {
            ret.personID = null;
        } else {
            List<PersonIDType> retPersonID = new ArrayList<PersonIDType>();
            for (PersonIDType aItem: getPersonID()) {
                retPersonID.add(((aItem == null)?null:aItem.clone()));
            }
            ret.personID = retPersonID;
        }
        if (personPatronymicName == null) {
            ret.personPatronymicName = null;
        } else {
            List<PersonPatronymicNameType> retPersonPatronymicName = new ArrayList<PersonPatronymicNameType>();
            for (PersonPatronymicNameType aItem: getPersonPatronymicName()) {
                retPersonPatronymicName.add(((aItem == null)?null:aItem.clone()));
            }
            ret.personPatronymicName = retPersonPatronymicName;
        }
        if (personPlaceOfBirthCoreLocation == null) {
            ret.personPlaceOfBirthCoreLocation = null;
        } else {
            List<CoreLocationType> retPersonPlaceOfBirthCoreLocation = new ArrayList<CoreLocationType>();
            for (CoreLocationType aItem: getPersonPlaceOfBirthCoreLocation()) {
                retPersonPlaceOfBirthCoreLocation.add(((aItem == null)?null:aItem.clone()));
            }
            ret.personPlaceOfBirthCoreLocation = retPersonPlaceOfBirthCoreLocation;
        }
        if (personPlaceOfDeathCoreLocation == null) {
            ret.personPlaceOfDeathCoreLocation = null;
        } else {
            List<CoreLocationType> retPersonPlaceOfDeathCoreLocation = new ArrayList<CoreLocationType>();
            for (CoreLocationType aItem: getPersonPlaceOfDeathCoreLocation()) {
                retPersonPlaceOfDeathCoreLocation.add(((aItem == null)?null:aItem.clone()));
            }
            ret.personPlaceOfDeathCoreLocation = retPersonPlaceOfDeathCoreLocation;
        }
        if (personResidencyJurisdiction == null) {
            ret.personResidencyJurisdiction = null;
        } else {
            List<JurisdictionType> retPersonResidencyJurisdiction = new ArrayList<JurisdictionType>();
            for (JurisdictionType aItem: getPersonResidencyJurisdiction()) {
                retPersonResidencyJurisdiction.add(((aItem == null)?null:aItem.clone()));
            }
            ret.personResidencyJurisdiction = retPersonResidencyJurisdiction;
        }
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public CorePersonType clone() {
        CorePersonType ret = new CorePersonType();
        cloneTo(ret);
        return ret;
    }

}
