
package eu.toop.edm.jaxb.w3.cv.ac;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import eu.toop.edm.jaxb.w3.cv.bc.PublicServiceDescriptionType;
import eu.toop.edm.jaxb.w3.cv.bc.PublicServiceHomepageIDType;
import eu.toop.edm.jaxb.w3.cv.bc.PublicServiceLanguageCodeType;
import eu.toop.edm.jaxb.w3.cv.bc.PublicServiceNameType;
import eu.toop.edm.jaxb.w3.cv.bc.PublicServiceTypeCodeType;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ABIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Public Service. Details&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A set of deeds and acts performed by or on behalf of a public agency for the benefit of a citizen, a business or another public agency.&lt;/ccts:Definition&gt;&lt;ccts:ObjectClass&gt;Core Public Service&lt;/ccts:ObjectClass&gt;&lt;/ccts:Component&gt;
 * </pre>
 * 
 * 
 * <p>Java class for CorePublicServiceType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="CorePublicServiceType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/BasicComponents}PublicServiceName" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/BasicComponents}PublicServiceDescription" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/BasicComponents}PublicServiceTypeCode" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/BasicComponents}PublicServiceLanguageCode" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/BasicComponents}PublicServiceHomepageID" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/AggregateComponents}PublicServiceChannel" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/AggregateComponents}PublicServicePhysicallyAvailableAtCoreLocation" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/AggregateComponents}RequiresCorePublicService" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/AggregateComponents}RelatedCorePublicService" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/AggregateComponents}PublicServiceInput" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/AggregateComponents}PublicServiceProducesOutput" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/AggregateComponents}PublicServiceFollowsRule" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/AggregateComponents}PublicServiceSpatialCoreLocation" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/AggregateComponents}PublicServiceTemporalPeriodOfTime" maxOccurs="unbounded" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CorePublicServiceType", propOrder = {
    "publicServiceName",
    "publicServiceDescription",
    "publicServiceTypeCode",
    "publicServiceLanguageCode",
    "publicServiceHomepageID",
    "publicServiceChannel",
    "publicServicePhysicallyAvailableAtCoreLocation",
    "requiresCorePublicService",
    "relatedCorePublicService",
    "publicServiceInput",
    "publicServiceProducesOutput",
    "publicServiceFollowsRule",
    "publicServiceSpatialCoreLocation",
    "publicServiceTemporalPeriodOfTime"
})
@CodingStyleguideUnaware
public class CorePublicServiceType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "PublicServiceName", namespace = "http://www.w3.org/ns/corevocabulary/BasicComponents")
    private List<PublicServiceNameType> publicServiceName;
    @XmlElement(name = "PublicServiceDescription", namespace = "http://www.w3.org/ns/corevocabulary/BasicComponents")
    private List<PublicServiceDescriptionType> publicServiceDescription;
    @XmlElement(name = "PublicServiceTypeCode", namespace = "http://www.w3.org/ns/corevocabulary/BasicComponents")
    private List<PublicServiceTypeCodeType> publicServiceTypeCode;
    @XmlElement(name = "PublicServiceLanguageCode", namespace = "http://www.w3.org/ns/corevocabulary/BasicComponents")
    private List<PublicServiceLanguageCodeType> publicServiceLanguageCode;
    @XmlElement(name = "PublicServiceHomepageID", namespace = "http://www.w3.org/ns/corevocabulary/BasicComponents")
    private List<PublicServiceHomepageIDType> publicServiceHomepageID;
    @XmlElement(name = "PublicServiceChannel")
    private List<ChannelType> publicServiceChannel;
    @XmlElement(name = "PublicServicePhysicallyAvailableAtCoreLocation")
    private List<CoreLocationType> publicServicePhysicallyAvailableAtCoreLocation;
    @XmlElement(name = "RequiresCorePublicService")
    private List<CorePublicServiceType> requiresCorePublicService;
    @XmlElement(name = "RelatedCorePublicService")
    private List<CorePublicServiceType> relatedCorePublicService;
    @XmlElement(name = "PublicServiceInput")
    private List<InputType> publicServiceInput;
    @XmlElement(name = "PublicServiceProducesOutput")
    private List<OutputType> publicServiceProducesOutput;
    @XmlElement(name = "PublicServiceFollowsRule")
    private List<RuleType> publicServiceFollowsRule;
    @XmlElement(name = "PublicServiceSpatialCoreLocation")
    private List<CoreLocationType> publicServiceSpatialCoreLocation;
    @XmlElement(name = "PublicServiceTemporalPeriodOfTime")
    private List<PeriodOfTimeType> publicServiceTemporalPeriodOfTime;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public CorePublicServiceType() {
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Public Service. Public Service Name. Text&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The name of the service.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Public Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Public Service Name&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Text&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Text. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the publicServiceName property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the publicServiceName property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPublicServiceName().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PublicServiceNameType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PublicServiceNameType> getPublicServiceName() {
        if (publicServiceName == null) {
            publicServiceName = new ArrayList<PublicServiceNameType>();
        }
        return this.publicServiceName;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Public Service. Public Service Description. Text&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A free text description of the service.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Public Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Public Service Description&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Text&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Text. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the publicServiceDescription property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the publicServiceDescription property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPublicServiceDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PublicServiceDescriptionType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PublicServiceDescriptionType> getPublicServiceDescription() {
        if (publicServiceDescription == null) {
            publicServiceDescription = new ArrayList<PublicServiceDescriptionType>();
        }
        return this.publicServiceDescription;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Public Service. Public Service Type. Code&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The type of service.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Public Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Public Service Type&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Code&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Code. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the publicServiceTypeCode property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the publicServiceTypeCode property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPublicServiceTypeCode().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PublicServiceTypeCodeType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PublicServiceTypeCodeType> getPublicServiceTypeCode() {
        if (publicServiceTypeCode == null) {
            publicServiceTypeCode = new ArrayList<PublicServiceTypeCodeType>();
        }
        return this.publicServiceTypeCode;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Public Service. Public Service Language. Code&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The language(s) in which the service is available.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Public Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Public Service Language&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Code&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Code. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the publicServiceLanguageCode property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the publicServiceLanguageCode property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPublicServiceLanguageCode().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PublicServiceLanguageCodeType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PublicServiceLanguageCodeType> getPublicServiceLanguageCode() {
        if (publicServiceLanguageCode == null) {
            publicServiceLanguageCode = new ArrayList<PublicServiceLanguageCodeType>();
        }
        return this.publicServiceLanguageCode;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Public Service. Public Service Homepage. Identifier&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The Web page through which the service may be available.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Public Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Public Service Homepage&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Identifier&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Identifier. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the publicServiceHomepageID property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the publicServiceHomepageID property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPublicServiceHomepageID().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PublicServiceHomepageIDType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PublicServiceHomepageIDType> getPublicServiceHomepageID() {
        if (publicServiceHomepageID == null) {
            publicServiceHomepageID = new ArrayList<PublicServiceHomepageIDType>();
        }
        return this.publicServiceHomepageID;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Public Service. Public Service_ Channel. Channel&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A medium through which an agent interacts with the service.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Public Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Public Service&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Channel&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Channel&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Channel&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the publicServiceChannel property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the publicServiceChannel property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPublicServiceChannel().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ChannelType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ChannelType> getPublicServiceChannel() {
        if (publicServiceChannel == null) {
            publicServiceChannel = new ArrayList<ChannelType>();
        }
        return this.publicServiceChannel;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Public Service. Public Service Physically Available At_ Core Location. Core Location&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A physical location at which a user may interact with the service.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Public Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Public Service Physically Available At&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Core Location&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Core Location&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Core Location&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the publicServicePhysicallyAvailableAtCoreLocation property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the publicServicePhysicallyAvailableAtCoreLocation property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPublicServicePhysicallyAvailableAtCoreLocation().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CoreLocationType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CoreLocationType> getPublicServicePhysicallyAvailableAtCoreLocation() {
        if (publicServicePhysicallyAvailableAtCoreLocation == null) {
            publicServicePhysicallyAvailableAtCoreLocation = new ArrayList<CoreLocationType>();
        }
        return this.publicServicePhysicallyAvailableAtCoreLocation;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Public Service. Requires_ Core Public Service. Core Public Service&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;Another public service required by this service.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Public Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Requires&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Core Public Service&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Core Public Service&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Core Public Service&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the requiresCorePublicService property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the requiresCorePublicService property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getRequiresCorePublicService().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CorePublicServiceType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CorePublicServiceType> getRequiresCorePublicService() {
        if (requiresCorePublicService == null) {
            requiresCorePublicService = new ArrayList<CorePublicServiceType>();
        }
        return this.requiresCorePublicService;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Public Service. Related_ Core Public Service. Core Public Service&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;Another public service related to this service, without being required by this service.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Public Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Related&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Core Public Service&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Core Public Service&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Core Public Service&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the relatedCorePublicService property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the relatedCorePublicService property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getRelatedCorePublicService().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CorePublicServiceType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CorePublicServiceType> getRelatedCorePublicService() {
        if (relatedCorePublicService == null) {
            relatedCorePublicService = new ArrayList<CorePublicServiceType>();
        }
        return this.relatedCorePublicService;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Public Service. Public Service_ Input. Input&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A resource required by the service in order to operate.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Public Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Public Service&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Input&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Input&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Input&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the publicServiceInput property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the publicServiceInput property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPublicServiceInput().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link InputType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<InputType> getPublicServiceInput() {
        if (publicServiceInput == null) {
            publicServiceInput = new ArrayList<InputType>();
        }
        return this.publicServiceInput;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Public Service. Public Service Produces_ Output. Output&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A resource produced by the service.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Public Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Public Service Produces&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Output&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Output&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Output&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the publicServiceProducesOutput property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the publicServiceProducesOutput property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPublicServiceProducesOutput().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link OutputType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<OutputType> getPublicServiceProducesOutput() {
        if (publicServiceProducesOutput == null) {
            publicServiceProducesOutput = new ArrayList<OutputType>();
        }
        return this.publicServiceProducesOutput;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Public Service. Public Service Follows_ Rule. Rule&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A rule under which the public service operates.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Public Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Public Service Follows&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Rule&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Rule&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Rule&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the publicServiceFollowsRule property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the publicServiceFollowsRule property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPublicServiceFollowsRule().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link RuleType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<RuleType> getPublicServiceFollowsRule() {
        if (publicServiceFollowsRule == null) {
            publicServiceFollowsRule = new ArrayList<RuleType>();
        }
        return this.publicServiceFollowsRule;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Public Service. Public Service Spatial_ Core Location. Core Location&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The area in which the service is available.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Public Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Public Service Spatial&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Core Location&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Core Location&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Core Location&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the publicServiceSpatialCoreLocation property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the publicServiceSpatialCoreLocation property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPublicServiceSpatialCoreLocation().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CoreLocationType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CoreLocationType> getPublicServiceSpatialCoreLocation() {
        if (publicServiceSpatialCoreLocation == null) {
            publicServiceSpatialCoreLocation = new ArrayList<CoreLocationType>();
        }
        return this.publicServiceSpatialCoreLocation;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Core Public Service. Public Service Temporal_ Period Of Time. Period Of Time&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The time frame in which the service is available.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Core Public Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Public Service Temporal&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Period Of Time&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Period Of Time&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Period Of Time&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the publicServiceTemporalPeriodOfTime property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the publicServiceTemporalPeriodOfTime property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPublicServiceTemporalPeriodOfTime().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PeriodOfTimeType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PeriodOfTimeType> getPublicServiceTemporalPeriodOfTime() {
        if (publicServiceTemporalPeriodOfTime == null) {
            publicServiceTemporalPeriodOfTime = new ArrayList<PeriodOfTimeType>();
        }
        return this.publicServiceTemporalPeriodOfTime;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final CorePublicServiceType rhs = ((CorePublicServiceType) o);
        if (!EqualsHelper.equalsCollection(publicServiceChannel, rhs.publicServiceChannel)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(publicServiceDescription, rhs.publicServiceDescription)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(publicServiceFollowsRule, rhs.publicServiceFollowsRule)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(publicServiceHomepageID, rhs.publicServiceHomepageID)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(publicServiceInput, rhs.publicServiceInput)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(publicServiceLanguageCode, rhs.publicServiceLanguageCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(publicServiceName, rhs.publicServiceName)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(publicServicePhysicallyAvailableAtCoreLocation, rhs.publicServicePhysicallyAvailableAtCoreLocation)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(publicServiceProducesOutput, rhs.publicServiceProducesOutput)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(publicServiceSpatialCoreLocation, rhs.publicServiceSpatialCoreLocation)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(publicServiceTemporalPeriodOfTime, rhs.publicServiceTemporalPeriodOfTime)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(publicServiceTypeCode, rhs.publicServiceTypeCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(relatedCorePublicService, rhs.relatedCorePublicService)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(requiresCorePublicService, rhs.requiresCorePublicService)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(publicServiceChannel).append(publicServiceDescription).append(publicServiceFollowsRule).append(publicServiceHomepageID).append(publicServiceInput).append(publicServiceLanguageCode).append(publicServiceName).append(publicServicePhysicallyAvailableAtCoreLocation).append(publicServiceProducesOutput).append(publicServiceSpatialCoreLocation).append(publicServiceTemporalPeriodOfTime).append(publicServiceTypeCode).append(relatedCorePublicService).append(requiresCorePublicService).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("publicServiceChannel", publicServiceChannel).append("publicServiceDescription", publicServiceDescription).append("publicServiceFollowsRule", publicServiceFollowsRule).append("publicServiceHomepageID", publicServiceHomepageID).append("publicServiceInput", publicServiceInput).append("publicServiceLanguageCode", publicServiceLanguageCode).append("publicServiceName", publicServiceName).append("publicServicePhysicallyAvailableAtCoreLocation", publicServicePhysicallyAvailableAtCoreLocation).append("publicServiceProducesOutput", publicServiceProducesOutput).append("publicServiceSpatialCoreLocation", publicServiceSpatialCoreLocation).append("publicServiceTemporalPeriodOfTime", publicServiceTemporalPeriodOfTime).append("publicServiceTypeCode", publicServiceTypeCode).append("relatedCorePublicService", relatedCorePublicService).append("requiresCorePublicService", requiresCorePublicService).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPublicServiceName(
        @Nullable
        final List<PublicServiceNameType> aList) {
        publicServiceName = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPublicServiceDescription(
        @Nullable
        final List<PublicServiceDescriptionType> aList) {
        publicServiceDescription = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPublicServiceTypeCode(
        @Nullable
        final List<PublicServiceTypeCodeType> aList) {
        publicServiceTypeCode = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPublicServiceLanguageCode(
        @Nullable
        final List<PublicServiceLanguageCodeType> aList) {
        publicServiceLanguageCode = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPublicServiceHomepageID(
        @Nullable
        final List<PublicServiceHomepageIDType> aList) {
        publicServiceHomepageID = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPublicServiceChannel(
        @Nullable
        final List<ChannelType> aList) {
        publicServiceChannel = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPublicServicePhysicallyAvailableAtCoreLocation(
        @Nullable
        final List<CoreLocationType> aList) {
        publicServicePhysicallyAvailableAtCoreLocation = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setRequiresCorePublicService(
        @Nullable
        final List<CorePublicServiceType> aList) {
        requiresCorePublicService = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setRelatedCorePublicService(
        @Nullable
        final List<CorePublicServiceType> aList) {
        relatedCorePublicService = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPublicServiceInput(
        @Nullable
        final List<InputType> aList) {
        publicServiceInput = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPublicServiceProducesOutput(
        @Nullable
        final List<OutputType> aList) {
        publicServiceProducesOutput = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPublicServiceFollowsRule(
        @Nullable
        final List<RuleType> aList) {
        publicServiceFollowsRule = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPublicServiceSpatialCoreLocation(
        @Nullable
        final List<CoreLocationType> aList) {
        publicServiceSpatialCoreLocation = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPublicServiceTemporalPeriodOfTime(
        @Nullable
        final List<PeriodOfTimeType> aList) {
        publicServiceTemporalPeriodOfTime = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPublicServiceNameEntries() {
        return (!getPublicServiceName().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPublicServiceNameEntries() {
        return getPublicServiceName().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPublicServiceNameCount() {
        return getPublicServiceName().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PublicServiceNameType getPublicServiceNameAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPublicServiceName().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPublicServiceName(
        @Nonnull
        final PublicServiceNameType elem) {
        getPublicServiceName().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPublicServiceDescriptionEntries() {
        return (!getPublicServiceDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPublicServiceDescriptionEntries() {
        return getPublicServiceDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPublicServiceDescriptionCount() {
        return getPublicServiceDescription().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PublicServiceDescriptionType getPublicServiceDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPublicServiceDescription().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPublicServiceDescription(
        @Nonnull
        final PublicServiceDescriptionType elem) {
        getPublicServiceDescription().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPublicServiceTypeCodeEntries() {
        return (!getPublicServiceTypeCode().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPublicServiceTypeCodeEntries() {
        return getPublicServiceTypeCode().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPublicServiceTypeCodeCount() {
        return getPublicServiceTypeCode().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PublicServiceTypeCodeType getPublicServiceTypeCodeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPublicServiceTypeCode().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPublicServiceTypeCode(
        @Nonnull
        final PublicServiceTypeCodeType elem) {
        getPublicServiceTypeCode().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPublicServiceLanguageCodeEntries() {
        return (!getPublicServiceLanguageCode().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPublicServiceLanguageCodeEntries() {
        return getPublicServiceLanguageCode().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPublicServiceLanguageCodeCount() {
        return getPublicServiceLanguageCode().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PublicServiceLanguageCodeType getPublicServiceLanguageCodeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPublicServiceLanguageCode().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPublicServiceLanguageCode(
        @Nonnull
        final PublicServiceLanguageCodeType elem) {
        getPublicServiceLanguageCode().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPublicServiceHomepageIDEntries() {
        return (!getPublicServiceHomepageID().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPublicServiceHomepageIDEntries() {
        return getPublicServiceHomepageID().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPublicServiceHomepageIDCount() {
        return getPublicServiceHomepageID().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PublicServiceHomepageIDType getPublicServiceHomepageIDAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPublicServiceHomepageID().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPublicServiceHomepageID(
        @Nonnull
        final PublicServiceHomepageIDType elem) {
        getPublicServiceHomepageID().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPublicServiceChannelEntries() {
        return (!getPublicServiceChannel().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPublicServiceChannelEntries() {
        return getPublicServiceChannel().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPublicServiceChannelCount() {
        return getPublicServiceChannel().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ChannelType getPublicServiceChannelAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPublicServiceChannel().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPublicServiceChannel(
        @Nonnull
        final ChannelType elem) {
        getPublicServiceChannel().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPublicServicePhysicallyAvailableAtCoreLocationEntries() {
        return (!getPublicServicePhysicallyAvailableAtCoreLocation().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPublicServicePhysicallyAvailableAtCoreLocationEntries() {
        return getPublicServicePhysicallyAvailableAtCoreLocation().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPublicServicePhysicallyAvailableAtCoreLocationCount() {
        return getPublicServicePhysicallyAvailableAtCoreLocation().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CoreLocationType getPublicServicePhysicallyAvailableAtCoreLocationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPublicServicePhysicallyAvailableAtCoreLocation().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPublicServicePhysicallyAvailableAtCoreLocation(
        @Nonnull
        final CoreLocationType elem) {
        getPublicServicePhysicallyAvailableAtCoreLocation().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasRequiresCorePublicServiceEntries() {
        return (!getRequiresCorePublicService().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoRequiresCorePublicServiceEntries() {
        return getRequiresCorePublicService().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getRequiresCorePublicServiceCount() {
        return getRequiresCorePublicService().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CorePublicServiceType getRequiresCorePublicServiceAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getRequiresCorePublicService().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addRequiresCorePublicService(
        @Nonnull
        final CorePublicServiceType elem) {
        getRequiresCorePublicService().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasRelatedCorePublicServiceEntries() {
        return (!getRelatedCorePublicService().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoRelatedCorePublicServiceEntries() {
        return getRelatedCorePublicService().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getRelatedCorePublicServiceCount() {
        return getRelatedCorePublicService().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CorePublicServiceType getRelatedCorePublicServiceAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getRelatedCorePublicService().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addRelatedCorePublicService(
        @Nonnull
        final CorePublicServiceType elem) {
        getRelatedCorePublicService().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPublicServiceInputEntries() {
        return (!getPublicServiceInput().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPublicServiceInputEntries() {
        return getPublicServiceInput().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPublicServiceInputCount() {
        return getPublicServiceInput().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public InputType getPublicServiceInputAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPublicServiceInput().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPublicServiceInput(
        @Nonnull
        final InputType elem) {
        getPublicServiceInput().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPublicServiceProducesOutputEntries() {
        return (!getPublicServiceProducesOutput().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPublicServiceProducesOutputEntries() {
        return getPublicServiceProducesOutput().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPublicServiceProducesOutputCount() {
        return getPublicServiceProducesOutput().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public OutputType getPublicServiceProducesOutputAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPublicServiceProducesOutput().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPublicServiceProducesOutput(
        @Nonnull
        final OutputType elem) {
        getPublicServiceProducesOutput().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPublicServiceFollowsRuleEntries() {
        return (!getPublicServiceFollowsRule().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPublicServiceFollowsRuleEntries() {
        return getPublicServiceFollowsRule().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPublicServiceFollowsRuleCount() {
        return getPublicServiceFollowsRule().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public RuleType getPublicServiceFollowsRuleAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPublicServiceFollowsRule().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPublicServiceFollowsRule(
        @Nonnull
        final RuleType elem) {
        getPublicServiceFollowsRule().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPublicServiceSpatialCoreLocationEntries() {
        return (!getPublicServiceSpatialCoreLocation().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPublicServiceSpatialCoreLocationEntries() {
        return getPublicServiceSpatialCoreLocation().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPublicServiceSpatialCoreLocationCount() {
        return getPublicServiceSpatialCoreLocation().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CoreLocationType getPublicServiceSpatialCoreLocationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPublicServiceSpatialCoreLocation().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPublicServiceSpatialCoreLocation(
        @Nonnull
        final CoreLocationType elem) {
        getPublicServiceSpatialCoreLocation().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPublicServiceTemporalPeriodOfTimeEntries() {
        return (!getPublicServiceTemporalPeriodOfTime().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPublicServiceTemporalPeriodOfTimeEntries() {
        return getPublicServiceTemporalPeriodOfTime().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPublicServiceTemporalPeriodOfTimeCount() {
        return getPublicServiceTemporalPeriodOfTime().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PeriodOfTimeType getPublicServiceTemporalPeriodOfTimeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPublicServiceTemporalPeriodOfTime().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPublicServiceTemporalPeriodOfTime(
        @Nonnull
        final PeriodOfTimeType elem) {
        getPublicServiceTemporalPeriodOfTime().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        CorePublicServiceType ret) {
        if (publicServiceChannel == null) {
            ret.publicServiceChannel = null;
        } else {
            List<ChannelType> retPublicServiceChannel = new ArrayList<ChannelType>();
            for (ChannelType aItem: getPublicServiceChannel()) {
                retPublicServiceChannel.add(((aItem == null)?null:aItem.clone()));
            }
            ret.publicServiceChannel = retPublicServiceChannel;
        }
        if (publicServiceDescription == null) {
            ret.publicServiceDescription = null;
        } else {
            List<PublicServiceDescriptionType> retPublicServiceDescription = new ArrayList<PublicServiceDescriptionType>();
            for (PublicServiceDescriptionType aItem: getPublicServiceDescription()) {
                retPublicServiceDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.publicServiceDescription = retPublicServiceDescription;
        }
        if (publicServiceFollowsRule == null) {
            ret.publicServiceFollowsRule = null;
        } else {
            List<RuleType> retPublicServiceFollowsRule = new ArrayList<RuleType>();
            for (RuleType aItem: getPublicServiceFollowsRule()) {
                retPublicServiceFollowsRule.add(((aItem == null)?null:aItem.clone()));
            }
            ret.publicServiceFollowsRule = retPublicServiceFollowsRule;
        }
        if (publicServiceHomepageID == null) {
            ret.publicServiceHomepageID = null;
        } else {
            List<PublicServiceHomepageIDType> retPublicServiceHomepageID = new ArrayList<PublicServiceHomepageIDType>();
            for (PublicServiceHomepageIDType aItem: getPublicServiceHomepageID()) {
                retPublicServiceHomepageID.add(((aItem == null)?null:aItem.clone()));
            }
            ret.publicServiceHomepageID = retPublicServiceHomepageID;
        }
        if (publicServiceInput == null) {
            ret.publicServiceInput = null;
        } else {
            List<InputType> retPublicServiceInput = new ArrayList<InputType>();
            for (InputType aItem: getPublicServiceInput()) {
                retPublicServiceInput.add(((aItem == null)?null:aItem.clone()));
            }
            ret.publicServiceInput = retPublicServiceInput;
        }
        if (publicServiceLanguageCode == null) {
            ret.publicServiceLanguageCode = null;
        } else {
            List<PublicServiceLanguageCodeType> retPublicServiceLanguageCode = new ArrayList<PublicServiceLanguageCodeType>();
            for (PublicServiceLanguageCodeType aItem: getPublicServiceLanguageCode()) {
                retPublicServiceLanguageCode.add(((aItem == null)?null:aItem.clone()));
            }
            ret.publicServiceLanguageCode = retPublicServiceLanguageCode;
        }
        if (publicServiceName == null) {
            ret.publicServiceName = null;
        } else {
            List<PublicServiceNameType> retPublicServiceName = new ArrayList<PublicServiceNameType>();
            for (PublicServiceNameType aItem: getPublicServiceName()) {
                retPublicServiceName.add(((aItem == null)?null:aItem.clone()));
            }
            ret.publicServiceName = retPublicServiceName;
        }
        if (publicServicePhysicallyAvailableAtCoreLocation == null) {
            ret.publicServicePhysicallyAvailableAtCoreLocation = null;
        } else {
            List<CoreLocationType> retPublicServicePhysicallyAvailableAtCoreLocation = new ArrayList<CoreLocationType>();
            for (CoreLocationType aItem: getPublicServicePhysicallyAvailableAtCoreLocation()) {
                retPublicServicePhysicallyAvailableAtCoreLocation.add(((aItem == null)?null:aItem.clone()));
            }
            ret.publicServicePhysicallyAvailableAtCoreLocation = retPublicServicePhysicallyAvailableAtCoreLocation;
        }
        if (publicServiceProducesOutput == null) {
            ret.publicServiceProducesOutput = null;
        } else {
            List<OutputType> retPublicServiceProducesOutput = new ArrayList<OutputType>();
            for (OutputType aItem: getPublicServiceProducesOutput()) {
                retPublicServiceProducesOutput.add(((aItem == null)?null:aItem.clone()));
            }
            ret.publicServiceProducesOutput = retPublicServiceProducesOutput;
        }
        if (publicServiceSpatialCoreLocation == null) {
            ret.publicServiceSpatialCoreLocation = null;
        } else {
            List<CoreLocationType> retPublicServiceSpatialCoreLocation = new ArrayList<CoreLocationType>();
            for (CoreLocationType aItem: getPublicServiceSpatialCoreLocation()) {
                retPublicServiceSpatialCoreLocation.add(((aItem == null)?null:aItem.clone()));
            }
            ret.publicServiceSpatialCoreLocation = retPublicServiceSpatialCoreLocation;
        }
        if (publicServiceTemporalPeriodOfTime == null) {
            ret.publicServiceTemporalPeriodOfTime = null;
        } else {
            List<PeriodOfTimeType> retPublicServiceTemporalPeriodOfTime = new ArrayList<PeriodOfTimeType>();
            for (PeriodOfTimeType aItem: getPublicServiceTemporalPeriodOfTime()) {
                retPublicServiceTemporalPeriodOfTime.add(((aItem == null)?null:aItem.clone()));
            }
            ret.publicServiceTemporalPeriodOfTime = retPublicServiceTemporalPeriodOfTime;
        }
        if (publicServiceTypeCode == null) {
            ret.publicServiceTypeCode = null;
        } else {
            List<PublicServiceTypeCodeType> retPublicServiceTypeCode = new ArrayList<PublicServiceTypeCodeType>();
            for (PublicServiceTypeCodeType aItem: getPublicServiceTypeCode()) {
                retPublicServiceTypeCode.add(((aItem == null)?null:aItem.clone()));
            }
            ret.publicServiceTypeCode = retPublicServiceTypeCode;
        }
        if (relatedCorePublicService == null) {
            ret.relatedCorePublicService = null;
        } else {
            List<CorePublicServiceType> retRelatedCorePublicService = new ArrayList<CorePublicServiceType>();
            for (CorePublicServiceType aItem: getRelatedCorePublicService()) {
                retRelatedCorePublicService.add(((aItem == null)?null:aItem.clone()));
            }
            ret.relatedCorePublicService = retRelatedCorePublicService;
        }
        if (requiresCorePublicService == null) {
            ret.requiresCorePublicService = null;
        } else {
            List<CorePublicServiceType> retRequiresCorePublicService = new ArrayList<CorePublicServiceType>();
            for (CorePublicServiceType aItem: getRequiresCorePublicService()) {
                retRequiresCorePublicService.add(((aItem == null)?null:aItem.clone()));
            }
            ret.requiresCorePublicService = retRequiresCorePublicService;
        }
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public CorePublicServiceType clone() {
        CorePublicServiceType ret = new CorePublicServiceType();
        cloneTo(ret);
        return ret;
    }

}
