
package eu.toop.edm.jaxb.w3.cv.ac;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ABIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Formal Framework. Details&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;Legislation, policy, or policies lying behind the rules that govern a public service.&lt;/ccts:Definition&gt;&lt;ccts:ObjectClass&gt;Formal Framework&lt;/ccts:ObjectClass&gt;&lt;/ccts:Component&gt;
 * </pre>
 * 
 * 
 * <p>Java class for FormalFrameworkType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="FormalFrameworkType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/AggregateComponents}CreatorAgent" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/AggregateComponents}RelatedFormalFramework" maxOccurs="unbounded" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "FormalFrameworkType", propOrder = {
    "creatorAgent",
    "relatedFormalFramework"
})
@CodingStyleguideUnaware
public class FormalFrameworkType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "CreatorAgent")
    private List<AgentType> creatorAgent;
    @XmlElement(name = "RelatedFormalFramework")
    private List<FormalFrameworkType> relatedFormalFramework;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public FormalFrameworkType() {
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Formal Framework. Creator_ Agent. Agent&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The public body responsible for the formal framework.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Formal Framework&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Creator&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Agent&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Agent&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Agent&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the creatorAgent property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the creatorAgent property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getCreatorAgent().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AgentType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AgentType> getCreatorAgent() {
        if (creatorAgent == null) {
            creatorAgent = new ArrayList<AgentType>();
        }
        return this.creatorAgent;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Formal Framework. Related_ Formal Framework. Formal Framework&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A formal framework related to this framework.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Formal Framework&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Related&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Formal Framework&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Formal Framework&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Formal Framework&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the relatedFormalFramework property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the relatedFormalFramework property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getRelatedFormalFramework().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link FormalFrameworkType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<FormalFrameworkType> getRelatedFormalFramework() {
        if (relatedFormalFramework == null) {
            relatedFormalFramework = new ArrayList<FormalFrameworkType>();
        }
        return this.relatedFormalFramework;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final FormalFrameworkType rhs = ((FormalFrameworkType) o);
        if (!EqualsHelper.equalsCollection(creatorAgent, rhs.creatorAgent)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(relatedFormalFramework, rhs.relatedFormalFramework)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(creatorAgent).append(relatedFormalFramework).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("creatorAgent", creatorAgent).append("relatedFormalFramework", relatedFormalFramework).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setCreatorAgent(
        @Nullable
        final List<AgentType> aList) {
        creatorAgent = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setRelatedFormalFramework(
        @Nullable
        final List<FormalFrameworkType> aList) {
        relatedFormalFramework = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasCreatorAgentEntries() {
        return (!getCreatorAgent().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoCreatorAgentEntries() {
        return getCreatorAgent().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getCreatorAgentCount() {
        return getCreatorAgent().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AgentType getCreatorAgentAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getCreatorAgent().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addCreatorAgent(
        @Nonnull
        final AgentType elem) {
        getCreatorAgent().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasRelatedFormalFrameworkEntries() {
        return (!getRelatedFormalFramework().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoRelatedFormalFrameworkEntries() {
        return getRelatedFormalFramework().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getRelatedFormalFrameworkCount() {
        return getRelatedFormalFramework().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public FormalFrameworkType getRelatedFormalFrameworkAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getRelatedFormalFramework().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addRelatedFormalFramework(
        @Nonnull
        final FormalFrameworkType elem) {
        getRelatedFormalFramework().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        FormalFrameworkType ret) {
        if (creatorAgent == null) {
            ret.creatorAgent = null;
        } else {
            List<AgentType> retCreatorAgent = new ArrayList<AgentType>();
            for (AgentType aItem: getCreatorAgent()) {
                retCreatorAgent.add(((aItem == null)?null:aItem.clone()));
            }
            ret.creatorAgent = retCreatorAgent;
        }
        if (relatedFormalFramework == null) {
            ret.relatedFormalFramework = null;
        } else {
            List<FormalFrameworkType> retRelatedFormalFramework = new ArrayList<FormalFrameworkType>();
            for (FormalFrameworkType aItem: getRelatedFormalFramework()) {
                retRelatedFormalFramework.add(((aItem == null)?null:aItem.clone()));
            }
            ret.relatedFormalFramework = retRelatedFormalFramework;
        }
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public FormalFrameworkType clone() {
        FormalFrameworkType ret = new FormalFrameworkType();
        cloneTo(ret);
        return ret;
    }

}
