
package eu.toop.edm.jaxb.w3.cv.ac;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import eu.toop.edm.jaxb.w3.cv.bc.RuleIDType;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ABIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Rule. Details&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A document that sets out the specific rules, guidelines, or procedures that a public service follows.&lt;/ccts:Definition&gt;&lt;ccts:ObjectClass&gt;Rule&lt;/ccts:ObjectClass&gt;&lt;/ccts:Component&gt;
 * </pre>
 * 
 * 
 * <p>Java class for RuleType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="RuleType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/BasicComponents}RuleID" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/AggregateComponents}CreatorAgent" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/ns/corevocabulary/AggregateComponents}ImplementsFormalFramework" maxOccurs="unbounded" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "RuleType", propOrder = {
    "ruleID",
    "creatorAgent",
    "implementsFormalFramework"
})
@CodingStyleguideUnaware
public class RuleType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "RuleID", namespace = "http://www.w3.org/ns/corevocabulary/BasicComponents")
    private List<RuleIDType> ruleID;
    @XmlElement(name = "CreatorAgent")
    private List<AgentType> creatorAgent;
    @XmlElement(name = "ImplementsFormalFramework")
    private List<FormalFrameworkType> implementsFormalFramework;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public RuleType() {
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Rule. Rule Identifier. Identifier&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;Identifier for the rule.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Rule&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Rule Identifier&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Identifier&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Identifier. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the ruleID property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the ruleID property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getRuleID().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link RuleIDType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<RuleIDType> getRuleID() {
        if (ruleID == null) {
            ruleID = new ArrayList<RuleIDType>();
        }
        return this.ruleID;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Rule. Creator_ Agent. Agent&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The organization that is responsible for the rule.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Rule&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Creator&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Agent&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Agent&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Agent&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the creatorAgent property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the creatorAgent property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getCreatorAgent().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AgentType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AgentType> getCreatorAgent() {
        if (creatorAgent == null) {
            creatorAgent = new ArrayList<AgentType>();
        }
        return this.creatorAgent;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cva="http://www.w3.org/ns/corevocabulary/AggregateComponents" xmlns:cvb="http://www.w3.org/ns/corevocabulary/BasicComponents" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Rule. Implements_ Formal Framework. Formal Framework&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The formal framework under which the rule is defined.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Rule&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Implements&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Formal Framework&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Formal Framework&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Formal Framework&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the implementsFormalFramework property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the implementsFormalFramework property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getImplementsFormalFramework().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link FormalFrameworkType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<FormalFrameworkType> getImplementsFormalFramework() {
        if (implementsFormalFramework == null) {
            implementsFormalFramework = new ArrayList<FormalFrameworkType>();
        }
        return this.implementsFormalFramework;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final RuleType rhs = ((RuleType) o);
        if (!EqualsHelper.equalsCollection(creatorAgent, rhs.creatorAgent)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(implementsFormalFramework, rhs.implementsFormalFramework)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(ruleID, rhs.ruleID)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(creatorAgent).append(implementsFormalFramework).append(ruleID).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("creatorAgent", creatorAgent).append("implementsFormalFramework", implementsFormalFramework).append("ruleID", ruleID).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setRuleID(
        @Nullable
        final List<RuleIDType> aList) {
        ruleID = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setCreatorAgent(
        @Nullable
        final List<AgentType> aList) {
        creatorAgent = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setImplementsFormalFramework(
        @Nullable
        final List<FormalFrameworkType> aList) {
        implementsFormalFramework = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasRuleIDEntries() {
        return (!getRuleID().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoRuleIDEntries() {
        return getRuleID().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getRuleIDCount() {
        return getRuleID().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public RuleIDType getRuleIDAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getRuleID().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addRuleID(
        @Nonnull
        final RuleIDType elem) {
        getRuleID().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasCreatorAgentEntries() {
        return (!getCreatorAgent().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoCreatorAgentEntries() {
        return getCreatorAgent().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getCreatorAgentCount() {
        return getCreatorAgent().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AgentType getCreatorAgentAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getCreatorAgent().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addCreatorAgent(
        @Nonnull
        final AgentType elem) {
        getCreatorAgent().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasImplementsFormalFrameworkEntries() {
        return (!getImplementsFormalFramework().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoImplementsFormalFrameworkEntries() {
        return getImplementsFormalFramework().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getImplementsFormalFrameworkCount() {
        return getImplementsFormalFramework().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public FormalFrameworkType getImplementsFormalFrameworkAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getImplementsFormalFramework().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addImplementsFormalFramework(
        @Nonnull
        final FormalFrameworkType elem) {
        getImplementsFormalFramework().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        RuleType ret) {
        if (creatorAgent == null) {
            ret.creatorAgent = null;
        } else {
            List<AgentType> retCreatorAgent = new ArrayList<AgentType>();
            for (AgentType aItem: getCreatorAgent()) {
                retCreatorAgent.add(((aItem == null)?null:aItem.clone()));
            }
            ret.creatorAgent = retCreatorAgent;
        }
        if (implementsFormalFramework == null) {
            ret.implementsFormalFramework = null;
        } else {
            List<FormalFrameworkType> retImplementsFormalFramework = new ArrayList<FormalFrameworkType>();
            for (FormalFrameworkType aItem: getImplementsFormalFramework()) {
                retImplementsFormalFramework.add(((aItem == null)?null:aItem.clone()));
            }
            ret.implementsFormalFramework = retImplementsFormalFramework;
        }
        if (ruleID == null) {
            ret.ruleID = null;
        } else {
            List<RuleIDType> retRuleID = new ArrayList<RuleIDType>();
            for (RuleIDType aItem: getRuleID()) {
                retRuleID.add(((aItem == null)?null:aItem.clone()));
            }
            ret.ruleID = retRuleID;
        }
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public RuleType clone() {
        RuleType ret = new RuleType();
        cloneTo(ret);
        return ret;
    }

}
