/*
 * Decompiled with CFR 0.152.
 */
package eu.vaadinonkotlin.security;

import eu.vaadinonkotlin.security.AccessRejectedException;
import eu.vaadinonkotlin.security.AllowAll;
import eu.vaadinonkotlin.security.AllowAllUsers;
import eu.vaadinonkotlin.security.AllowRoles;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0014\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0016J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H&J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\b\u0010\f\u001a\u00020\nH&\u00a8\u0006\r"}, d2={"Leu/vaadinonkotlin/security/LoggedInUserResolver;", "", "checkPermissionsOnClass", "", "viewClass", "Ljava/lang/Class;", "getCurrentUserRoles", "", "", "hasRole", "", "role", "isLoggedIn", "vok-security"})
public interface LoggedInUserResolver {
    public boolean isLoggedIn();

    @NotNull
    public Set<String> getCurrentUserRoles();

    public boolean hasRole(@NotNull String var1);

    public void checkPermissionsOnClass(@NotNull Class<?> var1);

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        public static boolean hasRole(LoggedInUserResolver $this, @NotNull String role) {
            Intrinsics.checkParameterIsNotNull((Object)role, (String)"role");
            return $this.getCurrentUserRoles().contains(role);
        }

        /*
         * WARNING - void declaration
         */
        public static void checkPermissionsOnClass(LoggedInUserResolver $this, @NotNull Class<?> viewClass) {
            Object element$iv$iv$iv;
            Iterable $receiver$iv$iv;
            Intrinsics.checkParameterIsNotNull(viewClass, (String)"viewClass");
            List annotationClasses = CollectionsKt.listOf((Object[])new Class[]{AllowRoles.class, AllowAll.class, AllowAllUsers.class});
            Iterable $receiver$iv = annotationClasses;
            Object object = $receiver$iv;
            Object destination$iv$iv = new ArrayList();
            Iterator $receiver$iv$iv$iv = $receiver$iv$iv;
            Iterator iterator = $receiver$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object a;
                element$iv$iv$iv = iterator.next();
                Object element$iv$iv = element$iv$iv$iv;
                Class it = (Class)element$iv$iv;
                if (viewClass.getAnnotation(it) == null) continue;
                Object it$iv$iv = a;
                destination$iv$iv.add(it$iv$iv);
            }
            List annotations = (List)destination$iv$iv;
            if (annotations.isEmpty()) {
                Object object2;
                Class<?> clazz;
                $receiver$iv = annotationClasses;
                CharSequence charSequence = new StringBuilder().append("The view ").append(viewClass.getSimpleName()).append(" is missing one of the ");
                $receiver$iv$iv = $receiver$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    element$iv$iv$iv = (Class)item$iv$iv;
                    clazz = destination$iv$iv;
                    object2 = it.getSimpleName();
                    clazz.add((String)object2);
                }
                clazz = (List)destination$iv$iv;
                String string = charSequence.append(clazz).append(" annotation").toString();
                clazz = viewClass;
                charSequence = string;
                Object object3 = object2 = SetsKt.emptySet();
                Class<?> clazz2 = clazz;
                CharSequence charSequence2 = charSequence;
                throw (Throwable)new AccessRejectedException((String)charSequence2, clazz2, (Set<String>)object3);
            }
            boolean bl = $receiver$iv = annotations.size() == 1;
            if (!$receiver$iv) {
                destination$iv$iv = "The view " + viewClass.getSimpleName() + " contains multiple security annotations which is illegal: " + annotations;
                throw (Throwable)new IllegalArgumentException(destination$iv$iv.toString());
            }
            Annotation annotation = (Annotation)annotations.get(0);
            object = annotation;
            if (!(object instanceof AllowAll)) {
                if (object instanceof AllowAllUsers) {
                    if (!$this.isLoggedIn()) {
                        Set set;
                        Class<?> clazz = viewClass;
                        String string = "Cannot access " + viewClass.getSimpleName() + ", you're not logged in";
                        Set set2 = set = SetsKt.emptySet();
                        Class<?> clazz3 = clazz;
                        String string2 = string;
                        throw (Throwable)new AccessRejectedException(string2, clazz3, set2);
                    }
                } else if (object instanceof AllowRoles) {
                    if (!$this.isLoggedIn()) {
                        Set set;
                        Class<?> clazz = viewClass;
                        String string = "Cannot access " + viewClass.getSimpleName() + ", you're not logged in";
                        Set set3 = set = SetsKt.emptySet();
                        Class<?> clazz4 = clazz;
                        String string3 = string;
                        throw (Throwable)new AccessRejectedException(string3, clazz4, set3);
                    }
                    Set requiredRoles = ArraysKt.toSet((Object[])((AllowRoles)annotation).roles());
                    if (requiredRoles.isEmpty()) {
                        Set set;
                        Class<?> clazz = viewClass;
                        String string = "Cannot access " + viewClass.getSimpleName() + ", nobody can access it";
                        Set set4 = set = SetsKt.emptySet();
                        Class<?> clazz5 = clazz;
                        String string4 = string;
                        throw (Throwable)new AccessRejectedException(string4, clazz5, set4);
                    }
                    Set<String> currentUserRoles = $this.getCurrentUserRoles();
                    if (CollectionsKt.intersect((Iterable)requiredRoles, (Iterable)currentUserRoles).isEmpty()) {
                        throw (Throwable)new AccessRejectedException("Can not access " + viewClass.getSimpleName() + ", you are not " + CollectionsKt.joinToString$default((Iterable)requiredRoles, (CharSequence)" or ", null, null, (int)0, null, null, (int)62, null), viewClass, requiredRoles);
                    }
                }
            }
        }
    }
}

