/*
 * Decompiled with CFR 0.152.
 */
package eu.vaadinonkotlin.security;

import eu.vaadinonkotlin.security.AccessRejectedException;
import eu.vaadinonkotlin.security.AllowAll;
import eu.vaadinonkotlin.security.AllowAllUsers;
import eu.vaadinonkotlin.security.AllowRoles;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0014\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0016J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H&J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\b\u0010\f\u001a\u00020\nH&\u00a8\u0006\r"}, d2={"Leu/vaadinonkotlin/security/LoggedInUserResolver;", "", "checkPermissionsOnClass", "", "viewClass", "Ljava/lang/Class;", "getCurrentUserRoles", "", "", "hasRole", "", "role", "isLoggedIn", "vok-security"})
public interface LoggedInUserResolver {
    public boolean isLoggedIn();

    @NotNull
    public Set<String> getCurrentUserRoles();

    public boolean hasRole(@NotNull String var1);

    public void checkPermissionsOnClass(@NotNull Class<?> var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        public static boolean hasRole(LoggedInUserResolver $this, @NotNull String role) {
            Intrinsics.checkParameterIsNotNull((Object)role, (String)"role");
            return $this.getCurrentUserRoles().contains(role);
        }

        /*
         * WARNING - void declaration
         */
        public static void checkPermissionsOnClass(LoggedInUserResolver $this, @NotNull Class<?> viewClass) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkParameterIsNotNull(viewClass, (String)"viewClass");
            List annotationClasses = CollectionsKt.listOf((Object[])new Class[]{AllowRoles.class, AllowAll.class, AllowAllUsers.class});
            Iterable $this$mapNotNull$iv = annotationClasses;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Object object = $this$forEach$iv$iv$iv.iterator();
            while (object.hasNext()) {
                Object a;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = object.next();
                boolean bl = false;
                Class it = (Class)element$iv$iv;
                boolean bl2 = false;
                if (viewClass.getAnnotation(it) == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                Object it$iv$iv = a;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List annotations = (List)destination$iv$iv;
            if (annotations.isEmpty()) {
                Object object2;
                Object object3;
                void $this$mapTo$iv$iv2;
                void $this$map$iv22;
                $this$mapNotNull$iv = annotationClasses;
                CharSequence charSequence = new StringBuilder().append("The view ").append(viewClass.getSimpleName()).append(" is missing one of the ");
                boolean $i$f$map = false;
                $this$mapNotNullTo$iv$iv = $this$map$iv22;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv22, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    object = (Class)item$iv$iv;
                    object3 = destination$iv$iv;
                    boolean bl = false;
                    object2 = it.getSimpleName();
                    object3.add(object2);
                }
                object3 = (List)destination$iv$iv;
                String string = charSequence.append(object3).append(" annotation").toString();
                object3 = viewClass;
                charSequence = string;
                boolean $this$map$iv22 = false;
                Object object4 = object2 = SetsKt.emptySet();
                Object object5 = object3;
                CharSequence charSequence2 = charSequence;
                throw (Throwable)new AccessRejectedException((String)charSequence2, (Class<?>)object5, (Set<String>)object4);
            }
            boolean $this$map$iv22 = annotations.size() == 1;
            boolean bl = false;
            boolean $this$mapTo$iv$iv2 = false;
            if (!$this$map$iv22) {
                boolean bl6 = false;
                String $this$mapTo$iv$iv2 = "The view " + viewClass.getSimpleName() + " contains multiple security annotations which is illegal: " + annotations;
                throw (Throwable)new IllegalArgumentException($this$mapTo$iv$iv2.toString());
            }
            Annotation annotation = (Annotation)annotations.get(0);
            Annotation annotation2 = annotation;
            if (!(annotation2 instanceof AllowAll)) {
                if (annotation2 instanceof AllowAllUsers) {
                    if (!$this.isLoggedIn()) {
                        Set set;
                        Class<?> clazz = viewClass;
                        String string = "Cannot access " + viewClass.getSimpleName() + ", you're not logged in";
                        $this$mapTo$iv$iv2 = false;
                        Set set2 = set = SetsKt.emptySet();
                        Class<?> clazz2 = clazz;
                        String string2 = string;
                        throw (Throwable)new AccessRejectedException(string2, clazz2, set2);
                    }
                } else if (annotation2 instanceof AllowRoles) {
                    if (!$this.isLoggedIn()) {
                        Set set;
                        Class<?> clazz = viewClass;
                        String string = "Cannot access " + viewClass.getSimpleName() + ", you're not logged in";
                        $this$mapTo$iv$iv2 = false;
                        Set set3 = set = SetsKt.emptySet();
                        Class<?> clazz3 = clazz;
                        String string3 = string;
                        throw (Throwable)new AccessRejectedException(string3, clazz3, set3);
                    }
                    Set requiredRoles = ArraysKt.toSet((Object[])((AllowRoles)annotation).roles());
                    if (requiredRoles.isEmpty()) {
                        Set set;
                        Class<?> clazz = viewClass;
                        String string = "Cannot access " + viewClass.getSimpleName() + ", nobody can access it";
                        boolean bl6 = false;
                        Set set4 = set = SetsKt.emptySet();
                        Class<?> clazz4 = clazz;
                        String string4 = string;
                        throw (Throwable)new AccessRejectedException(string4, clazz4, set4);
                    }
                    Set<String> currentUserRoles = $this.getCurrentUserRoles();
                    if (CollectionsKt.intersect((Iterable)requiredRoles, (Iterable)currentUserRoles).isEmpty()) {
                        throw (Throwable)new AccessRejectedException("Can not access " + viewClass.getSimpleName() + ", you are not " + CollectionsKt.joinToString$default((Iterable)requiredRoles, (CharSequence)" or ", null, null, (int)0, null, null, (int)62, null), viewClass, requiredRoles);
                    }
                }
            }
        }
    }
}

