/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j;

import eu.verdelhan.ta4j.Strategy;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.TimeSeriesManager;
import eu.verdelhan.ta4j.Trade;
import eu.verdelhan.ta4j.TradingRecord;
import java.util.List;

public interface AnalysisCriterion {
    public double calculate(TimeSeries var1, Trade var2);

    public double calculate(TimeSeries var1, TradingRecord var2);

    default public Strategy chooseBest(TimeSeriesManager manager, List<Strategy> strategies) {
        Strategy bestStrategy = strategies.get(0);
        double bestCriterionValue = this.calculate(manager.getTimeSeries(), manager.run(bestStrategy));
        for (int i = 1; i < strategies.size(); ++i) {
            Strategy currentStrategy = strategies.get(i);
            double currentCriterionValue = this.calculate(manager.getTimeSeries(), manager.run(currentStrategy));
            if (!this.betterThan(currentCriterionValue, bestCriterionValue)) continue;
            bestStrategy = currentStrategy;
            bestCriterionValue = currentCriterionValue;
        }
        return bestStrategy;
    }

    public boolean betterThan(double var1, double var3);
}

