/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j;

import eu.verdelhan.ta4j.Rule;
import eu.verdelhan.ta4j.Strategy;
import eu.verdelhan.ta4j.TradingRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseStrategy
implements Strategy {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private Rule entryRule;
    private Rule exitRule;
    private int unstablePeriod;

    public BaseStrategy(Rule entryRule, Rule exitRule) {
        this(entryRule, exitRule, 0);
    }

    public BaseStrategy(Rule entryRule, Rule exitRule, int unstablePeriod) {
        if (entryRule == null || exitRule == null) {
            throw new IllegalArgumentException("Rules cannot be null");
        }
        if (unstablePeriod < 0) {
            throw new IllegalArgumentException("Unstable period tick count must be >= 0");
        }
        this.entryRule = entryRule;
        this.exitRule = exitRule;
        this.unstablePeriod = unstablePeriod;
    }

    @Override
    public Rule getEntryRule() {
        return this.entryRule;
    }

    @Override
    public Rule getExitRule() {
        return this.exitRule;
    }

    @Override
    public void setUnstablePeriod(int unstablePeriod) {
        this.unstablePeriod = unstablePeriod;
    }

    @Override
    public boolean isUnstableAt(int index) {
        return index < this.unstablePeriod;
    }

    @Override
    public boolean shouldEnter(int index, TradingRecord tradingRecord) {
        boolean enter = Strategy.super.shouldEnter(index, tradingRecord);
        this.traceShouldEnter(index, enter);
        return enter;
    }

    @Override
    public boolean shouldExit(int index, TradingRecord tradingRecord) {
        boolean exit = Strategy.super.shouldExit(index, tradingRecord);
        this.traceShouldExit(index, exit);
        return exit;
    }

    protected void traceShouldEnter(int index, boolean enter) {
        this.log.trace(">>> {}#shouldEnter({}): {}", new Object[]{this.getClass().getSimpleName(), index, enter});
    }

    protected void traceShouldExit(int index, boolean exit) {
        this.log.trace(">>> {}#shouldExit({}): {}", new Object[]{this.getClass().getSimpleName(), index, exit});
    }
}

