/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Tick;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;

public class BaseTick
implements Tick {
    private static final long serialVersionUID = 8038383777467488147L;
    private Duration timePeriod;
    private ZonedDateTime endTime;
    private ZonedDateTime beginTime;
    private Decimal openPrice = null;
    private Decimal closePrice = null;
    private Decimal maxPrice = null;
    private Decimal minPrice = null;
    private Decimal amount = Decimal.ZERO;
    private Decimal volume = Decimal.ZERO;
    private int trades = 0;

    public BaseTick(Duration timePeriod, ZonedDateTime endTime) {
        this.checkTimeArguments(timePeriod, endTime);
        this.timePeriod = timePeriod;
        this.endTime = endTime;
        this.beginTime = endTime.minus(timePeriod);
    }

    public BaseTick(ZonedDateTime endTime, double openPrice, double highPrice, double lowPrice, double closePrice, double volume) {
        this(endTime, Decimal.valueOf(openPrice), Decimal.valueOf(highPrice), Decimal.valueOf(lowPrice), Decimal.valueOf(closePrice), Decimal.valueOf(volume));
    }

    public BaseTick(ZonedDateTime endTime, String openPrice, String highPrice, String lowPrice, String closePrice, String volume) {
        this(endTime, Decimal.valueOf(openPrice), Decimal.valueOf(highPrice), Decimal.valueOf(lowPrice), Decimal.valueOf(closePrice), Decimal.valueOf(volume));
    }

    public BaseTick(ZonedDateTime endTime, Decimal openPrice, Decimal highPrice, Decimal lowPrice, Decimal closePrice, Decimal volume) {
        this(Duration.ofDays(1L), endTime, openPrice, highPrice, lowPrice, closePrice, volume);
    }

    public BaseTick(Duration timePeriod, ZonedDateTime endTime, Decimal openPrice, Decimal highPrice, Decimal lowPrice, Decimal closePrice, Decimal volume) {
        this(timePeriod, endTime, openPrice, highPrice, lowPrice, closePrice, volume, Decimal.ZERO);
    }

    public BaseTick(Duration timePeriod, ZonedDateTime endTime, Decimal openPrice, Decimal highPrice, Decimal lowPrice, Decimal closePrice, Decimal volume, Decimal amount) {
        this.checkTimeArguments(timePeriod, endTime);
        this.timePeriod = timePeriod;
        this.endTime = endTime;
        this.beginTime = endTime.minus(timePeriod);
        this.openPrice = openPrice;
        this.maxPrice = highPrice;
        this.minPrice = lowPrice;
        this.closePrice = closePrice;
        this.volume = volume;
        this.amount = amount;
    }

    @Override
    public Decimal getOpenPrice() {
        return this.openPrice;
    }

    @Override
    public Decimal getMinPrice() {
        return this.minPrice;
    }

    @Override
    public Decimal getMaxPrice() {
        return this.maxPrice;
    }

    @Override
    public Decimal getClosePrice() {
        return this.closePrice;
    }

    @Override
    public Decimal getVolume() {
        return this.volume;
    }

    @Override
    public int getTrades() {
        return this.trades;
    }

    @Override
    public Decimal getAmount() {
        return this.amount;
    }

    @Override
    public Duration getTimePeriod() {
        return this.timePeriod;
    }

    @Override
    public ZonedDateTime getBeginTime() {
        return this.beginTime;
    }

    @Override
    public ZonedDateTime getEndTime() {
        return this.endTime;
    }

    @Override
    public void addTrade(Decimal tradeVolume, Decimal tradePrice) {
        if (this.openPrice == null) {
            this.openPrice = tradePrice;
        }
        this.closePrice = tradePrice;
        if (this.maxPrice == null) {
            this.maxPrice = tradePrice;
        } else {
            Decimal decimal = this.maxPrice = this.maxPrice.isLessThan(tradePrice) ? tradePrice : this.maxPrice;
        }
        this.minPrice = this.minPrice == null ? tradePrice : (this.minPrice.isGreaterThan(tradePrice) ? tradePrice : this.minPrice);
        this.volume = this.volume.plus(tradeVolume);
        this.amount = this.amount.plus(tradeVolume.multipliedBy(tradePrice));
        ++this.trades;
    }

    public String toString() {
        return String.format("{end time: %1s, close price: %2$f, open price: %3$f, min price: %4$f, max price: %5$f, volume: %6$f}", this.endTime.withZoneSameInstant(ZoneId.systemDefault()), this.closePrice.toDouble(), this.openPrice.toDouble(), this.minPrice.toDouble(), this.maxPrice.toDouble(), this.volume.toDouble());
    }

    private void checkTimeArguments(Duration timePeriod, ZonedDateTime endTime) {
        if (timePeriod == null) {
            throw new IllegalArgumentException("Time period cannot be null");
        }
        if (endTime == null) {
            throw new IllegalArgumentException("End time cannot be null");
        }
    }
}

