/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j;

import eu.verdelhan.ta4j.Tick;
import eu.verdelhan.ta4j.TimeSeries;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseTimeSeries
implements TimeSeries {
    private static final long serialVersionUID = -1878027009398790126L;
    private static final String UNNAMED_SERIES_NAME = "unamed_series";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String name;
    private int seriesBeginIndex = -1;
    private int seriesEndIndex = -1;
    private final List<Tick> ticks;
    private int maximumTickCount = Integer.MAX_VALUE;
    private int removedTicksCount = 0;
    private boolean constrained = false;

    public BaseTimeSeries() {
        this(UNNAMED_SERIES_NAME);
    }

    public BaseTimeSeries(String name) {
        this(name, new ArrayList<Tick>());
    }

    public BaseTimeSeries(List<Tick> ticks) {
        this(UNNAMED_SERIES_NAME, ticks);
    }

    public BaseTimeSeries(String name, List<Tick> ticks) {
        this(name, ticks, 0, ticks.size() - 1, false);
    }

    public BaseTimeSeries(TimeSeries defaultSeries, int seriesBeginIndex, int seriesEndIndex) {
        this(defaultSeries.getName(), defaultSeries.getTickData(), seriesBeginIndex, seriesEndIndex, true);
        if (defaultSeries.getTickData() == null || defaultSeries.getTickData().isEmpty()) {
            throw new IllegalArgumentException("Cannot create a constrained series from a time series with a null/empty list of ticks");
        }
        if (defaultSeries.getMaximumTickCount() != Integer.MAX_VALUE) {
            throw new IllegalStateException("Cannot create a constrained series from a time series for which a maximum tick count has been set");
        }
    }

    private BaseTimeSeries(String name, List<Tick> ticks, int seriesBeginIndex, int seriesEndIndex, boolean constrained) {
        this.name = name;
        ArrayList arrayList = this.ticks = ticks == null ? new ArrayList() : ticks;
        if (ticks.isEmpty()) {
            this.seriesBeginIndex = -1;
            this.seriesEndIndex = -1;
            this.constrained = false;
            return;
        }
        if (seriesEndIndex < seriesBeginIndex - 1) {
            throw new IllegalArgumentException("End index must be >= to begin index - 1");
        }
        if (seriesEndIndex >= ticks.size()) {
            throw new IllegalArgumentException("End index must be < to the tick list size");
        }
        this.seriesBeginIndex = seriesBeginIndex;
        this.seriesEndIndex = seriesEndIndex;
        this.constrained = constrained;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Tick getTick(int i) {
        int innerIndex = i - this.removedTicksCount;
        if (innerIndex < 0) {
            if (i < 0) {
                throw new IndexOutOfBoundsException(BaseTimeSeries.buildOutOfBoundsMessage(this, i));
            }
            this.log.trace("Time series `{}` ({} ticks): tick {} already removed, use {}-th instead", new Object[]{this.name, this.ticks.size(), i, this.removedTicksCount});
            if (this.ticks.isEmpty()) {
                throw new IndexOutOfBoundsException(BaseTimeSeries.buildOutOfBoundsMessage(this, this.removedTicksCount));
            }
            innerIndex = 0;
        } else if (innerIndex >= this.ticks.size()) {
            throw new IndexOutOfBoundsException(BaseTimeSeries.buildOutOfBoundsMessage(this, i));
        }
        return this.ticks.get(innerIndex);
    }

    @Override
    public int getTickCount() {
        if (this.seriesEndIndex < 0) {
            return 0;
        }
        int startIndex = Math.max(this.removedTicksCount, this.seriesBeginIndex);
        return this.seriesEndIndex - startIndex + 1;
    }

    @Override
    public List<Tick> getTickData() {
        return this.ticks;
    }

    @Override
    public int getBeginIndex() {
        return this.seriesBeginIndex;
    }

    @Override
    public int getEndIndex() {
        return this.seriesEndIndex;
    }

    @Override
    public void setMaximumTickCount(int maximumTickCount) {
        if (this.constrained) {
            throw new IllegalStateException("Cannot set a maximum tick count on a constrained time series");
        }
        if (maximumTickCount <= 0) {
            throw new IllegalArgumentException("Maximum tick count must be strictly positive");
        }
        this.maximumTickCount = maximumTickCount;
        this.removeExceedingTicks();
    }

    @Override
    public int getMaximumTickCount() {
        return this.maximumTickCount;
    }

    @Override
    public int getRemovedTicksCount() {
        return this.removedTicksCount;
    }

    @Override
    public void addTick(Tick tick) {
        if (tick == null) {
            throw new IllegalArgumentException("Cannot add null tick");
        }
        int lastTickIndex = this.ticks.size() - 1;
        if (!this.ticks.isEmpty()) {
            ZonedDateTime seriesEndTime = this.ticks.get(lastTickIndex).getEndTime();
            if (!tick.getEndTime().isAfter(seriesEndTime)) {
                throw new IllegalArgumentException("Cannot add a tick with end time <= to series end time");
            }
        }
        this.ticks.add(tick);
        if (this.seriesBeginIndex == -1) {
            this.seriesBeginIndex = 0;
        }
        ++this.seriesEndIndex;
        this.removeExceedingTicks();
    }

    private void removeExceedingTicks() {
        int tickCount = this.ticks.size();
        if (tickCount > this.maximumTickCount) {
            int nbTicksToRemove = tickCount - this.maximumTickCount;
            for (int i = 0; i < nbTicksToRemove; ++i) {
                this.ticks.remove(0);
            }
            this.removedTicksCount += nbTicksToRemove;
        }
    }

    private static String buildOutOfBoundsMessage(BaseTimeSeries series, int index) {
        return "Size of series: " + series.ticks.size() + " ticks, " + series.removedTicksCount + " ticks removed, index = " + index;
    }
}

