/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Order;
import eu.verdelhan.ta4j.Trade;
import eu.verdelhan.ta4j.TradingRecord;
import java.util.ArrayList;
import java.util.List;

public class BaseTradingRecord
implements TradingRecord {
    private static final long serialVersionUID = -4436851731855891220L;
    private List<Order> orders = new ArrayList<Order>();
    private List<Order> buyOrders = new ArrayList<Order>();
    private List<Order> sellOrders = new ArrayList<Order>();
    private List<Order> entryOrders = new ArrayList<Order>();
    private List<Order> exitOrders = new ArrayList<Order>();
    private List<Trade> trades = new ArrayList<Trade>();
    private Order.OrderType startingType;
    private Trade currentTrade;

    public BaseTradingRecord() {
        this(Order.OrderType.BUY);
    }

    public BaseTradingRecord(Order.OrderType entryOrderType) {
        if (entryOrderType == null) {
            throw new IllegalArgumentException("Starting type must not be null");
        }
        this.startingType = entryOrderType;
        this.currentTrade = new Trade(entryOrderType);
    }

    public BaseTradingRecord(Order ... orders) {
        this(orders[0].getType());
        for (Order o : orders) {
            boolean newOrderWillBeAnEntry = this.currentTrade.isNew();
            if (newOrderWillBeAnEntry && o.getType() != this.startingType) {
                this.currentTrade = new Trade(o.getType());
            }
            Order newOrder = this.currentTrade.operate(o.getIndex(), o.getPrice(), o.getAmount());
            this.recordOrder(newOrder, newOrderWillBeAnEntry);
        }
    }

    @Override
    public Trade getCurrentTrade() {
        return this.currentTrade;
    }

    @Override
    public void operate(int index, Decimal price, Decimal amount) {
        if (this.currentTrade.isClosed()) {
            throw new IllegalStateException("Current trade should not be closed");
        }
        boolean newOrderWillBeAnEntry = this.currentTrade.isNew();
        Order newOrder = this.currentTrade.operate(index, price, amount);
        this.recordOrder(newOrder, newOrderWillBeAnEntry);
    }

    @Override
    public boolean enter(int index, Decimal price, Decimal amount) {
        if (this.currentTrade.isNew()) {
            this.operate(index, price, amount);
            return true;
        }
        return false;
    }

    @Override
    public final boolean exit(int index, Decimal price, Decimal amount) {
        if (this.currentTrade.isOpened()) {
            this.operate(index, price, amount);
            return true;
        }
        return false;
    }

    @Override
    public List<Trade> getTrades() {
        return this.trades;
    }

    @Override
    public Order getLastOrder() {
        if (!this.orders.isEmpty()) {
            return this.orders.get(this.orders.size() - 1);
        }
        return null;
    }

    @Override
    public Order getLastOrder(Order.OrderType orderType) {
        if (Order.OrderType.BUY.equals((Object)orderType) && !this.buyOrders.isEmpty()) {
            return this.buyOrders.get(this.buyOrders.size() - 1);
        }
        if (Order.OrderType.SELL.equals((Object)orderType) && !this.sellOrders.isEmpty()) {
            return this.sellOrders.get(this.sellOrders.size() - 1);
        }
        return null;
    }

    @Override
    public Order getLastEntry() {
        if (!this.entryOrders.isEmpty()) {
            return this.entryOrders.get(this.entryOrders.size() - 1);
        }
        return null;
    }

    @Override
    public Order getLastExit() {
        if (!this.exitOrders.isEmpty()) {
            return this.exitOrders.get(this.exitOrders.size() - 1);
        }
        return null;
    }

    private void recordOrder(Order order, boolean isEntry) {
        if (order == null) {
            throw new IllegalArgumentException("Order should not be null");
        }
        if (isEntry) {
            this.entryOrders.add(order);
        } else {
            this.exitOrders.add(order);
        }
        this.orders.add(order);
        if (Order.OrderType.BUY.equals((Object)order.getType())) {
            this.buyOrders.add(order);
        } else if (Order.OrderType.SELL.equals((Object)order.getType())) {
            this.sellOrders.add(order);
        }
        if (this.currentTrade.isClosed()) {
            this.trades.add(this.currentTrade);
            this.currentTrade = new Trade(this.startingType);
        }
    }
}

