/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Objects;

public final class Decimal
implements Comparable<Decimal>,
Serializable {
    private static final long serialVersionUID = 2225130444465033658L;
    public static final MathContext MATH_CONTEXT = new MathContext(32, RoundingMode.HALF_UP);
    public static final Decimal NaN = new Decimal();
    public static final Decimal ZERO = Decimal.valueOf(0);
    public static final Decimal ONE = Decimal.valueOf(1);
    public static final Decimal TWO = Decimal.valueOf(2);
    public static final Decimal THREE = Decimal.valueOf(3);
    public static final Decimal TEN = Decimal.valueOf(10);
    public static final Decimal HUNDRED = Decimal.valueOf(100);
    public static final Decimal THOUSAND = Decimal.valueOf(1000);
    private final BigDecimal delegate;

    private Decimal() {
        this.delegate = null;
    }

    private Decimal(String val) {
        this.delegate = new BigDecimal(val, MATH_CONTEXT);
    }

    private Decimal(double val) {
        this.delegate = new BigDecimal(val, MATH_CONTEXT);
    }

    private Decimal(int val) {
        this.delegate = new BigDecimal(val, MATH_CONTEXT);
    }

    private Decimal(long val) {
        this.delegate = new BigDecimal(val, MATH_CONTEXT);
    }

    private Decimal(BigDecimal val) {
        this.delegate = val;
    }

    public Decimal plus(Decimal augend) {
        if (this == NaN || augend == NaN) {
            return NaN;
        }
        return new Decimal(this.delegate.add(augend.delegate, MATH_CONTEXT));
    }

    public Decimal minus(Decimal subtrahend) {
        if (this == NaN || subtrahend == NaN) {
            return NaN;
        }
        return new Decimal(this.delegate.subtract(subtrahend.delegate, MATH_CONTEXT));
    }

    public Decimal multipliedBy(Decimal multiplicand) {
        if (this == NaN || multiplicand == NaN) {
            return NaN;
        }
        return new Decimal(this.delegate.multiply(multiplicand.delegate, MATH_CONTEXT));
    }

    public Decimal dividedBy(Decimal divisor) {
        if (this == NaN || divisor == NaN || divisor.isZero()) {
            return NaN;
        }
        return new Decimal(this.delegate.divide(divisor.delegate, MATH_CONTEXT));
    }

    public Decimal remainder(Decimal divisor) {
        if (this == NaN || divisor == NaN || divisor.isZero()) {
            return NaN;
        }
        return new Decimal(this.delegate.remainder(divisor.delegate, MATH_CONTEXT));
    }

    public Decimal pow(int n) {
        if (this == NaN) {
            return NaN;
        }
        return new Decimal(this.delegate.pow(n, MATH_CONTEXT));
    }

    public Decimal log() {
        if (this == NaN) {
            return NaN;
        }
        return new Decimal(StrictMath.log(this.delegate.doubleValue()));
    }

    public Decimal sqrt() {
        if (this == NaN) {
            return NaN;
        }
        return new Decimal(StrictMath.sqrt(this.delegate.doubleValue()));
    }

    public Decimal abs() {
        if (this == NaN) {
            return NaN;
        }
        return new Decimal(this.delegate.abs());
    }

    public boolean isZero() {
        if (this == NaN) {
            return false;
        }
        return this.compareTo(ZERO) == 0;
    }

    public boolean isPositive() {
        if (this == NaN) {
            return false;
        }
        return this.compareTo(ZERO) > 0;
    }

    public boolean isPositiveOrZero() {
        if (this == NaN) {
            return false;
        }
        return this.compareTo(ZERO) >= 0;
    }

    public boolean isNaN() {
        return this == NaN;
    }

    public boolean isNegative() {
        if (this == NaN) {
            return false;
        }
        return this.compareTo(ZERO) < 0;
    }

    public boolean isNegativeOrZero() {
        if (this == NaN) {
            return false;
        }
        return this.compareTo(ZERO) <= 0;
    }

    public boolean isEqual(Decimal other) {
        if (this == NaN || other == NaN) {
            return false;
        }
        return this.compareTo(other) == 0;
    }

    public boolean isGreaterThan(Decimal other) {
        if (this == NaN || other == NaN) {
            return false;
        }
        return this.compareTo(other) > 0;
    }

    public boolean isGreaterThanOrEqual(Decimal other) {
        if (this == NaN || other == NaN) {
            return false;
        }
        return this.compareTo(other) > -1;
    }

    public boolean isLessThan(Decimal other) {
        if (this == NaN || other == NaN) {
            return false;
        }
        return this.compareTo(other) < 0;
    }

    public boolean isLessThanOrEqual(Decimal other) {
        if (this == NaN || other == NaN) {
            return false;
        }
        return this.compareTo(other) < 1;
    }

    @Override
    public int compareTo(Decimal other) {
        if (this == NaN || other == NaN) {
            return 0;
        }
        return this.delegate.compareTo(other.delegate);
    }

    public Decimal min(Decimal other) {
        if (this == NaN || other == NaN) {
            return NaN;
        }
        return this.compareTo(other) <= 0 ? this : other;
    }

    public Decimal max(Decimal other) {
        if (this == NaN || other == NaN) {
            return NaN;
        }
        return this.compareTo(other) >= 0 ? this : other;
    }

    public double toDouble() {
        if (this == NaN) {
            return Double.NaN;
        }
        return this.delegate.doubleValue();
    }

    public String toString() {
        if (this == NaN) {
            return "NaN";
        }
        return this.delegate.toString();
    }

    public int hashCode() {
        return Objects.hash(this.delegate);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Decimal)) {
            return false;
        }
        Decimal other = (Decimal)obj;
        return this.delegate == other.delegate || this.delegate != null && this.delegate.compareTo(other.delegate) == 0;
    }

    public static Decimal valueOf(String val) {
        if ("NaN".equals(val)) {
            return NaN;
        }
        return new Decimal(val);
    }

    public static Decimal valueOf(double val) {
        if (Double.isNaN(val)) {
            return NaN;
        }
        return new Decimal(val);
    }

    public static Decimal valueOf(int val) {
        return new Decimal(val);
    }

    public static Decimal valueOf(long val) {
        return new Decimal(val);
    }
}

