/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j;

import eu.verdelhan.ta4j.Decimal;
import java.io.Serializable;
import java.util.Objects;

public class Order
implements Serializable {
    private static final long serialVersionUID = -905474949010114150L;
    private OrderType type;
    private int index;
    private Decimal price = Decimal.NaN;
    private Decimal amount = Decimal.NaN;

    protected Order(int index, OrderType type) {
        this.type = type;
        this.index = index;
    }

    protected Order(int index, OrderType type, Decimal price, Decimal amount) {
        this(index, type);
        this.price = price;
        this.amount = amount;
    }

    public OrderType getType() {
        return this.type;
    }

    public boolean isBuy() {
        return this.type == OrderType.BUY;
    }

    public boolean isSell() {
        return this.type == OrderType.SELL;
    }

    public int getIndex() {
        return this.index;
    }

    public Decimal getPrice() {
        return this.price;
    }

    public Decimal getAmount() {
        return this.amount;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.index, this.price, this.amount});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Order other = (Order)obj;
        if (this.type != other.type) {
            return false;
        }
        if (this.index != other.index) {
            return false;
        }
        if (!(this.price == other.price || this.price != null && this.price.equals(other.price))) {
            return false;
        }
        return this.amount == other.amount || this.amount != null && this.amount.equals(other.amount);
    }

    public String toString() {
        return "Order{type=" + (Object)((Object)this.type) + ", index=" + this.index + ", price=" + this.price + ", amount=" + this.amount + '}';
    }

    public static Order buyAt(int index) {
        return new Order(index, OrderType.BUY);
    }

    public static Order buyAt(int index, Decimal price, Decimal amount) {
        return new Order(index, OrderType.BUY, price, amount);
    }

    public static Order sellAt(int index) {
        return new Order(index, OrderType.SELL);
    }

    public static Order sellAt(int index, Decimal price, Decimal amount) {
        return new Order(index, OrderType.SELL, price, amount);
    }

    public static enum OrderType {
        BUY{

            @Override
            public OrderType complementType() {
                return SELL;
            }
        }
        ,
        SELL{

            @Override
            public OrderType complementType() {
                return BUY;
            }
        };


        public abstract OrderType complementType();
    }
}

