/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j;

import eu.verdelhan.ta4j.Rule;
import eu.verdelhan.ta4j.Trade;
import eu.verdelhan.ta4j.TradingRecord;

public interface Strategy {
    public Rule getEntryRule();

    public Rule getExitRule();

    public void setUnstablePeriod(int var1);

    public boolean isUnstableAt(int var1);

    default public boolean shouldOperate(int index, TradingRecord tradingRecord) {
        Trade trade = tradingRecord.getCurrentTrade();
        if (trade.isNew()) {
            return this.shouldEnter(index, tradingRecord);
        }
        if (trade.isOpened()) {
            return this.shouldExit(index, tradingRecord);
        }
        return false;
    }

    default public boolean shouldEnter(int index) {
        return this.shouldEnter(index, null);
    }

    default public boolean shouldEnter(int index, TradingRecord tradingRecord) {
        if (this.isUnstableAt(index)) {
            return false;
        }
        boolean enter = this.getEntryRule().isSatisfied(index, tradingRecord);
        return enter;
    }

    default public boolean shouldExit(int index) {
        return this.shouldExit(index, null);
    }

    default public boolean shouldExit(int index, TradingRecord tradingRecord) {
        if (this.isUnstableAt(index)) {
            return false;
        }
        boolean exit = this.getExitRule().isSatisfied(index, tradingRecord);
        return exit;
    }
}

