/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j;

import eu.verdelhan.ta4j.Decimal;
import java.io.Serializable;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public interface Tick
extends Serializable {
    public Decimal getOpenPrice();

    public Decimal getMinPrice();

    public Decimal getMaxPrice();

    public Decimal getClosePrice();

    public Decimal getVolume();

    public int getTrades();

    public Decimal getAmount();

    public Duration getTimePeriod();

    public ZonedDateTime getBeginTime();

    public ZonedDateTime getEndTime();

    default public boolean inPeriod(ZonedDateTime timestamp) {
        return timestamp != null && !timestamp.isBefore(this.getBeginTime()) && timestamp.isBefore(this.getEndTime());
    }

    default public String getDateName() {
        return this.getEndTime().format(DateTimeFormatter.ISO_DATE_TIME);
    }

    default public String getSimpleDateName() {
        return this.getEndTime().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
    }

    default public boolean isBearish() {
        Decimal openPrice = this.getOpenPrice();
        Decimal closePrice = this.getClosePrice();
        return openPrice != null && closePrice != null && closePrice.isLessThan(openPrice);
    }

    default public boolean isBullish() {
        Decimal openPrice = this.getOpenPrice();
        Decimal closePrice = this.getClosePrice();
        return openPrice != null && closePrice != null && openPrice.isLessThan(closePrice);
    }

    default public void addTrade(double tradeVolume, double tradePrice) {
        this.addTrade(Decimal.valueOf(tradeVolume), Decimal.valueOf(tradePrice));
    }

    default public void addTrade(String tradeVolume, String tradePrice) {
        this.addTrade(Decimal.valueOf(tradeVolume), Decimal.valueOf(tradePrice));
    }

    public void addTrade(Decimal var1, Decimal var2);
}

