/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j;

import eu.verdelhan.ta4j.Tick;
import java.io.Serializable;
import java.time.format.DateTimeFormatter;
import java.util.List;

public interface TimeSeries
extends Serializable {
    public String getName();

    public Tick getTick(int var1);

    default public Tick getFirstTick() {
        return this.getTick(this.getBeginIndex());
    }

    default public Tick getLastTick() {
        return this.getTick(this.getEndIndex());
    }

    public int getTickCount();

    default public boolean isEmpty() {
        return this.getTickCount() == 0;
    }

    public List<Tick> getTickData();

    public int getBeginIndex();

    public int getEndIndex();

    default public String getSeriesPeriodDescription() {
        StringBuilder sb = new StringBuilder();
        if (!this.getTickData().isEmpty()) {
            Tick firstTick = this.getFirstTick();
            Tick lastTick = this.getLastTick();
            sb.append(firstTick.getEndTime().format(DateTimeFormatter.ISO_DATE_TIME)).append(" - ").append(lastTick.getEndTime().format(DateTimeFormatter.ISO_DATE_TIME));
        }
        return sb.toString();
    }

    public void setMaximumTickCount(int var1);

    public int getMaximumTickCount();

    public int getRemovedTicksCount();

    public void addTick(Tick var1);
}

