/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j;

import eu.verdelhan.ta4j.BaseTradingRecord;
import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Order;
import eu.verdelhan.ta4j.Strategy;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.TradingRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeSeriesManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private TimeSeries timeSeries;

    public TimeSeriesManager() {
    }

    public TimeSeriesManager(TimeSeries timeSeries) {
        this.timeSeries = timeSeries;
    }

    public void setTimeSeries(TimeSeries timeSeries) {
        this.timeSeries = timeSeries;
    }

    public TimeSeries getTimeSeries() {
        return this.timeSeries;
    }

    public TradingRecord run(Strategy strategy) {
        return this.run(strategy, Order.OrderType.BUY);
    }

    public TradingRecord run(Strategy strategy, int startIndex, int finishIndex) {
        return this.run(strategy, Order.OrderType.BUY, Decimal.NaN, startIndex, finishIndex);
    }

    public TradingRecord run(Strategy strategy, Order.OrderType orderType) {
        return this.run(strategy, orderType, Decimal.NaN);
    }

    public TradingRecord run(Strategy strategy, Order.OrderType orderType, int startIndex, int finishIndex) {
        return this.run(strategy, orderType, Decimal.NaN, startIndex, finishIndex);
    }

    public TradingRecord run(Strategy strategy, Order.OrderType orderType, Decimal amount) {
        return this.run(strategy, orderType, amount, this.timeSeries.getBeginIndex(), this.timeSeries.getEndIndex());
    }

    public TradingRecord run(Strategy strategy, Order.OrderType orderType, Decimal amount, int startIndex, int finishIndex) {
        int runBeginIndex = Math.max(startIndex, this.timeSeries.getBeginIndex());
        int runEndIndex = Math.min(finishIndex, this.timeSeries.getEndIndex());
        this.log.trace("Running strategy (indexes: {} -> {}): {} (starting with {})", new Object[]{runBeginIndex, runEndIndex, strategy, orderType});
        BaseTradingRecord tradingRecord = new BaseTradingRecord(orderType);
        for (int i = runBeginIndex; i <= runEndIndex; ++i) {
            if (!strategy.shouldOperate(i, tradingRecord)) continue;
            tradingRecord.operate(i, this.timeSeries.getTick(i).getClosePrice(), amount);
        }
        if (!tradingRecord.isClosed()) {
            int seriesMaxSize = Math.max(this.timeSeries.getEndIndex() + 1, this.timeSeries.getTickData().size());
            for (int i = runEndIndex + 1; i < seriesMaxSize; ++i) {
                if (!strategy.shouldOperate(i, tradingRecord)) continue;
                tradingRecord.operate(i, this.timeSeries.getTick(i).getClosePrice(), amount);
                break;
            }
        }
        return tradingRecord;
    }
}

