/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Order;
import java.io.Serializable;
import java.util.Objects;

public class Trade
implements Serializable {
    private static final long serialVersionUID = -5484709075767220358L;
    private Order entry;
    private Order exit;
    private Order.OrderType startingType;

    public Trade() {
        this(Order.OrderType.BUY);
    }

    public Trade(Order.OrderType startingType) {
        if (startingType == null) {
            throw new IllegalArgumentException("Starting type must not be null");
        }
        this.startingType = startingType;
    }

    public Trade(Order entry, Order exit) {
        if (entry.getType().equals((Object)exit.getType())) {
            throw new IllegalArgumentException("Both orders must have different types");
        }
        this.startingType = entry.getType();
        this.entry = entry;
        this.exit = exit;
    }

    public Order getEntry() {
        return this.entry;
    }

    public Order getExit() {
        return this.exit;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Trade) {
            Trade t = (Trade)obj;
            return this.entry.equals(t.getEntry()) && this.exit.equals(t.getExit());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.entry, this.exit);
    }

    public Order operate(int index) {
        return this.operate(index, Decimal.NaN, Decimal.NaN);
    }

    public Order operate(int index, Decimal price, Decimal amount) {
        Order order = null;
        if (this.isNew()) {
            this.entry = order = new Order(index, this.startingType, price, amount);
        } else if (this.isOpened()) {
            if (index < this.entry.getIndex()) {
                throw new IllegalStateException("The index i is less than the entryOrder index");
            }
            this.exit = order = new Order(index, this.startingType.complementType(), price, amount);
        }
        return order;
    }

    public boolean isClosed() {
        return this.entry != null && this.exit != null;
    }

    public boolean isOpened() {
        return this.entry != null && this.exit == null;
    }

    public boolean isNew() {
        return this.entry == null && this.exit == null;
    }

    public String toString() {
        return "Entry: " + this.entry + " exit: " + this.exit;
    }
}

