/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Order;
import eu.verdelhan.ta4j.Trade;
import java.io.Serializable;
import java.util.List;

public interface TradingRecord
extends Serializable {
    public Trade getCurrentTrade();

    default public void operate(int index) {
        this.operate(index, Decimal.NaN, Decimal.NaN);
    }

    public void operate(int var1, Decimal var2, Decimal var3);

    default public boolean enter(int index) {
        return this.enter(index, Decimal.NaN, Decimal.NaN);
    }

    public boolean enter(int var1, Decimal var2, Decimal var3);

    default public boolean exit(int index) {
        return this.exit(index, Decimal.NaN, Decimal.NaN);
    }

    public boolean exit(int var1, Decimal var2, Decimal var3);

    default public boolean isClosed() {
        return !this.getCurrentTrade().isOpened();
    }

    public List<Trade> getTrades();

    default public int getTradeCount() {
        return this.getTrades().size();
    }

    default public Trade getLastTrade() {
        List<Trade> trades = this.getTrades();
        if (!trades.isEmpty()) {
            return trades.get(trades.size() - 1);
        }
        return null;
    }

    public Order getLastOrder();

    public Order getLastOrder(Order.OrderType var1);

    public Order getLastEntry();

    public Order getLastExit();
}

