/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.analysis;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.Trade;
import eu.verdelhan.ta4j.TradingRecord;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class CashFlow
implements Indicator<Decimal> {
    private final TimeSeries timeSeries;
    private List<Decimal> values = new ArrayList<Decimal>(Arrays.asList(Decimal.ONE));

    public CashFlow(TimeSeries timeSeries, Trade trade) {
        this.timeSeries = timeSeries;
        this.calculate(trade);
        this.fillToTheEnd();
    }

    public CashFlow(TimeSeries timeSeries, TradingRecord tradingRecord) {
        this.timeSeries = timeSeries;
        this.calculate(tradingRecord);
        this.fillToTheEnd();
    }

    @Override
    public Decimal getValue(int index) {
        return this.values.get(index);
    }

    @Override
    public TimeSeries getTimeSeries() {
        return this.timeSeries;
    }

    public int getSize() {
        return this.timeSeries.getTickCount();
    }

    private void calculate(Trade trade) {
        int entryIndex = trade.getEntry().getIndex();
        int begin = entryIndex + 1;
        if (begin > this.values.size()) {
            Decimal lastValue = this.values.get(this.values.size() - 1);
            this.values.addAll(Collections.nCopies(begin - this.values.size(), lastValue));
        }
        int end = trade.getExit().getIndex();
        for (int i = Math.max(begin, 1); i <= end; ++i) {
            Decimal ratio = trade.getEntry().isBuy() ? this.timeSeries.getTick(i).getClosePrice().dividedBy(this.timeSeries.getTick(entryIndex).getClosePrice()) : this.timeSeries.getTick(entryIndex).getClosePrice().dividedBy(this.timeSeries.getTick(i).getClosePrice());
            this.values.add(this.values.get(entryIndex).multipliedBy(ratio));
        }
    }

    private void calculate(TradingRecord tradingRecord) {
        for (Trade trade : tradingRecord.getTrades()) {
            this.calculate(trade);
        }
    }

    private void fillToTheEnd() {
        if (this.timeSeries.getEndIndex() >= this.values.size()) {
            Decimal lastValue = this.values.get(this.values.size() - 1);
            this.values.addAll(Collections.nCopies(this.timeSeries.getEndIndex() - this.values.size() + 1, lastValue));
        }
    }
}

