/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.analysis.criteria;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.Trade;
import eu.verdelhan.ta4j.TradingRecord;
import eu.verdelhan.ta4j.analysis.criteria.AbstractAnalysisCriterion;

public class AverageProfitableTradesCriterion
extends AbstractAnalysisCriterion {
    @Override
    public double calculate(TimeSeries series, Trade trade) {
        int entryIndex = trade.getEntry().getIndex();
        int exitIndex = trade.getExit().getIndex();
        Decimal result = trade.getEntry().isBuy() ? series.getTick(exitIndex).getClosePrice().dividedBy(series.getTick(entryIndex).getClosePrice()) : series.getTick(entryIndex).getClosePrice().dividedBy(series.getTick(exitIndex).getClosePrice());
        return result.isGreaterThan(Decimal.ONE) ? 1.0 : 0.0;
    }

    @Override
    public double calculate(TimeSeries series, TradingRecord tradingRecord) {
        int numberOfProfitable = 0;
        for (Trade trade : tradingRecord.getTrades()) {
            int entryIndex = trade.getEntry().getIndex();
            int exitIndex = trade.getExit().getIndex();
            Decimal result = trade.getEntry().isBuy() ? series.getTick(exitIndex).getClosePrice().dividedBy(series.getTick(entryIndex).getClosePrice()) : series.getTick(entryIndex).getClosePrice().dividedBy(series.getTick(exitIndex).getClosePrice());
            if (!result.isGreaterThan(Decimal.ONE)) continue;
            ++numberOfProfitable;
        }
        return (double)numberOfProfitable / (double)tradingRecord.getTradeCount();
    }

    @Override
    public boolean betterThan(double criterionValue1, double criterionValue2) {
        return criterionValue1 > criterionValue2;
    }
}

