/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.analysis.criteria;

import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.Trade;
import eu.verdelhan.ta4j.TradingRecord;
import eu.verdelhan.ta4j.analysis.criteria.AbstractAnalysisCriterion;

public class BuyAndHoldCriterion
extends AbstractAnalysisCriterion {
    @Override
    public double calculate(TimeSeries series, TradingRecord tradingRecord) {
        return series.getTick(series.getEndIndex()).getClosePrice().dividedBy(series.getTick(series.getBeginIndex()).getClosePrice()).toDouble();
    }

    @Override
    public double calculate(TimeSeries series, Trade trade) {
        int entryIndex = trade.getEntry().getIndex();
        int exitIndex = trade.getExit().getIndex();
        if (trade.getEntry().isBuy()) {
            return series.getTick(exitIndex).getClosePrice().dividedBy(series.getTick(entryIndex).getClosePrice()).toDouble();
        }
        return series.getTick(entryIndex).getClosePrice().dividedBy(series.getTick(exitIndex).getClosePrice()).toDouble();
    }

    @Override
    public boolean betterThan(double criterionValue1, double criterionValue2) {
        return criterionValue1 > criterionValue2;
    }
}

