/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.indicators.CachedIndicator;
import eu.verdelhan.ta4j.indicators.helpers.ClosePriceIndicator;
import eu.verdelhan.ta4j.indicators.helpers.LowestValueIndicator;

public class AroonDownIndicator
extends CachedIndicator<Decimal> {
    private final int timeFrame;
    private final ClosePriceIndicator closePriceIndicator;
    private final LowestValueIndicator lowestClosePriceIndicator;

    public AroonDownIndicator(TimeSeries series, int timeFrame) {
        super(series);
        this.timeFrame = timeFrame;
        this.closePriceIndicator = new ClosePriceIndicator(series);
        this.lowestClosePriceIndicator = new LowestValueIndicator(this.closePriceIndicator, timeFrame);
    }

    @Override
    protected Decimal calculate(int index) {
        int realTimeFrame = Math.min(this.timeFrame, index + 1);
        int endIndex = index - realTimeFrame;
        int nbTicks = 0;
        for (int i = index; i > endIndex && !((Decimal)this.closePriceIndicator.getValue(i)).isEqual((Decimal)this.lowestClosePriceIndicator.getValue(index)); --i) {
            ++nbTicks;
        }
        return Decimal.valueOf(realTimeFrame - nbTicks).dividedBy(Decimal.valueOf(realTimeFrame)).multipliedBy(Decimal.HUNDRED);
    }
}

