/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.indicators.CachedIndicator;
import eu.verdelhan.ta4j.indicators.helpers.ClosePriceIndicator;
import eu.verdelhan.ta4j.indicators.helpers.HighestValueIndicator;

public class AroonUpIndicator
extends CachedIndicator<Decimal> {
    private final int timeFrame;
    private final ClosePriceIndicator closePriceIndicator;
    private final HighestValueIndicator highestClosePriceIndicator;

    public AroonUpIndicator(TimeSeries series, int timeFrame) {
        super(series);
        this.timeFrame = timeFrame;
        this.closePriceIndicator = new ClosePriceIndicator(series);
        this.highestClosePriceIndicator = new HighestValueIndicator(this.closePriceIndicator, timeFrame);
    }

    @Override
    protected Decimal calculate(int index) {
        int realTimeFrame = Math.min(this.timeFrame, index + 1);
        int endIndex = index - realTimeFrame;
        int nbTicks = 0;
        for (int i = index; i > endIndex && !((Decimal)this.closePriceIndicator.getValue(i)).isEqual((Decimal)this.highestClosePriceIndicator.getValue(index)); --i) {
            ++nbTicks;
        }
        return Decimal.valueOf(realTimeFrame - nbTicks).dividedBy(Decimal.valueOf(realTimeFrame)).multipliedBy(Decimal.HUNDRED);
    }
}

