/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.indicators.DirectionalMovementIndicator;
import eu.verdelhan.ta4j.indicators.RecursiveCachedIndicator;

public class AverageDirectionalMovementIndicator
extends RecursiveCachedIndicator<Decimal> {
    private final int timeFrame;
    private final DirectionalMovementIndicator dm;

    public AverageDirectionalMovementIndicator(TimeSeries series, int timeFrame) {
        super(series);
        this.timeFrame = timeFrame;
        this.dm = new DirectionalMovementIndicator(series, timeFrame);
    }

    @Override
    protected Decimal calculate(int index) {
        if (index == 0) {
            return Decimal.ONE;
        }
        Decimal nbPeriods = Decimal.valueOf(this.timeFrame);
        Decimal nbPeriodsMinusOne = Decimal.valueOf(this.timeFrame - 1);
        return ((Decimal)this.getValue(index - 1)).multipliedBy(nbPeriodsMinusOne).dividedBy(nbPeriods).plus(((Decimal)this.dm.getValue(index)).dividedBy(nbPeriods));
    }
}

