/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.indicators.CachedIndicator;
import eu.verdelhan.ta4j.indicators.helpers.CumulatedGainsIndicator;
import eu.verdelhan.ta4j.indicators.helpers.CumulatedLossesIndicator;

public class CMOIndicator
extends CachedIndicator<Decimal> {
    private final CumulatedGainsIndicator cumulatedGains;
    private final CumulatedLossesIndicator cumulatedLosses;

    public CMOIndicator(Indicator<Decimal> price, int timeFrame) {
        super(price);
        this.cumulatedGains = new CumulatedGainsIndicator(price, timeFrame);
        this.cumulatedLosses = new CumulatedLossesIndicator(price, timeFrame);
    }

    @Override
    protected Decimal calculate(int index) {
        Decimal sumOfGains = (Decimal)this.cumulatedGains.getValue(index);
        Decimal sumOfLosses = (Decimal)this.cumulatedLosses.getValue(index);
        return sumOfGains.minus(sumOfLosses).dividedBy(sumOfGains.plus(sumOfLosses)).multipliedBy(Decimal.HUNDRED);
    }
}

