/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.indicators.CachedIndicator;
import eu.verdelhan.ta4j.indicators.helpers.AverageTrueRangeIndicator;
import eu.verdelhan.ta4j.indicators.helpers.HighestValueIndicator;
import eu.verdelhan.ta4j.indicators.helpers.MaxPriceIndicator;

public class ChandelierExitLongIndicator
extends CachedIndicator<Decimal> {
    private final HighestValueIndicator high;
    private final AverageTrueRangeIndicator atr;
    private final Decimal k;

    public ChandelierExitLongIndicator(TimeSeries series) {
        this(series, 22, Decimal.THREE);
    }

    public ChandelierExitLongIndicator(TimeSeries series, int timeFrame, Decimal k) {
        super(series);
        this.high = new HighestValueIndicator(new MaxPriceIndicator(series), timeFrame);
        this.atr = new AverageTrueRangeIndicator(series, timeFrame);
        this.k = k;
    }

    @Override
    protected Decimal calculate(int index) {
        return ((Decimal)this.high.getValue(index)).minus(((Decimal)this.atr.getValue(index)).multipliedBy(this.k));
    }
}

