/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.indicators.RecursiveCachedIndicator;
import eu.verdelhan.ta4j.indicators.SMAIndicator;

public class EMAIndicator
extends RecursiveCachedIndicator<Decimal> {
    private final Indicator<Decimal> indicator;
    private final int timeFrame;
    private final Decimal multiplier;

    public EMAIndicator(Indicator<Decimal> indicator, int timeFrame) {
        super(indicator);
        this.indicator = indicator;
        this.timeFrame = timeFrame;
        this.multiplier = Decimal.TWO.dividedBy(Decimal.valueOf(timeFrame + 1));
    }

    @Override
    protected Decimal calculate(int index) {
        if (index + 1 < this.timeFrame) {
            return (Decimal)new SMAIndicator(this.indicator, this.timeFrame).getValue(index);
        }
        if (index == 0) {
            return this.indicator.getValue(0);
        }
        Decimal emaPrev = (Decimal)this.getValue(index - 1);
        return this.indicator.getValue(index).minus(emaPrev).multipliedBy(this.multiplier).plus(emaPrev);
    }
}

