/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.indicators.CachedIndicator;
import eu.verdelhan.ta4j.indicators.EMAIndicator;

public class MACDIndicator
extends CachedIndicator<Decimal> {
    private final EMAIndicator shortTermEma;
    private final EMAIndicator longTermEma;

    public MACDIndicator(Indicator<Decimal> indicator, int shortTimeFrame, int longTimeFrame) {
        super(indicator);
        if (shortTimeFrame > longTimeFrame) {
            throw new IllegalArgumentException("Long term period count must be greater than short term period count");
        }
        this.shortTermEma = new EMAIndicator(indicator, shortTimeFrame);
        this.longTermEma = new EMAIndicator(indicator, longTimeFrame);
    }

    @Override
    protected Decimal calculate(int index) {
        return ((Decimal)this.shortTermEma.getValue(index)).minus((Decimal)this.longTermEma.getValue(index));
    }
}

