/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.indicators.CachedIndicator;
import eu.verdelhan.ta4j.indicators.EMAIndicator;
import eu.verdelhan.ta4j.indicators.helpers.DifferenceIndicator;
import eu.verdelhan.ta4j.indicators.helpers.MaxPriceIndicator;
import eu.verdelhan.ta4j.indicators.helpers.MinPriceIndicator;

public class MassIndexIndicator
extends CachedIndicator<Decimal> {
    private EMAIndicator singleEma;
    private EMAIndicator doubleEma;
    private int timeFrame;

    public MassIndexIndicator(TimeSeries series, int emaTimeFrame, int timeFrame) {
        super(series);
        DifferenceIndicator highLowDifferential = new DifferenceIndicator(new MaxPriceIndicator(series), new MinPriceIndicator(series));
        this.singleEma = new EMAIndicator(highLowDifferential, emaTimeFrame);
        this.doubleEma = new EMAIndicator(this.singleEma, emaTimeFrame);
        this.timeFrame = timeFrame;
    }

    @Override
    protected Decimal calculate(int index) {
        int startIndex = Math.max(0, index - this.timeFrame + 1);
        Decimal massIndex = Decimal.ZERO;
        for (int i = startIndex; i <= index; ++i) {
            Decimal emaRatio = ((Decimal)this.singleEma.getValue(i)).dividedBy((Decimal)this.doubleEma.getValue(i));
            massIndex = massIndex.plus(emaRatio);
        }
        return massIndex;
    }
}

