/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.indicators.CachedIndicator;
import eu.verdelhan.ta4j.indicators.SMAIndicator;

public class RAVIIndicator
extends CachedIndicator<Decimal> {
    private final SMAIndicator shortSma;
    private final SMAIndicator longSma;

    public RAVIIndicator(Indicator<Decimal> price, int shortSmaTimeFrame, int longSmaTimeFrame) {
        super(price);
        this.shortSma = new SMAIndicator(price, shortSmaTimeFrame);
        this.longSma = new SMAIndicator(price, longSmaTimeFrame);
    }

    @Override
    protected Decimal calculate(int index) {
        Decimal shortMA = (Decimal)this.shortSma.getValue(index);
        Decimal longMA = (Decimal)this.longSma.getValue(index);
        return shortMA.minus(longMA).dividedBy(longMA).multipliedBy(Decimal.HUNDRED);
    }
}

