/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.indicators.CachedIndicator;
import eu.verdelhan.ta4j.indicators.helpers.AverageGainIndicator;
import eu.verdelhan.ta4j.indicators.helpers.AverageLossIndicator;

public class RSIIndicator
extends CachedIndicator<Decimal> {
    private Indicator<Decimal> averageGainIndicator;
    private Indicator<Decimal> averageLossIndicator;

    public RSIIndicator(Indicator<Decimal> indicator, int timeFrame) {
        this((Indicator<Decimal>)new AverageGainIndicator(indicator, timeFrame), new AverageLossIndicator(indicator, timeFrame));
    }

    public RSIIndicator(Indicator<Decimal> avgGainIndicator, Indicator<Decimal> avgLossIndicator) {
        super(avgGainIndicator);
        this.averageGainIndicator = avgGainIndicator;
        this.averageLossIndicator = avgLossIndicator;
    }

    @Override
    protected Decimal calculate(int index) {
        if (index == 0) {
            return Decimal.ZERO;
        }
        Decimal averageLoss = this.averageLossIndicator.getValue(index);
        if (averageLoss.isZero()) {
            return Decimal.HUNDRED;
        }
        Decimal averageGain = this.averageGainIndicator.getValue(index);
        Decimal relativeStrength = averageGain.dividedBy(averageLoss);
        Decimal ratio = Decimal.HUNDRED.dividedBy(Decimal.ONE.plus(relativeStrength));
        return Decimal.HUNDRED.minus(ratio);
    }
}

