/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.indicators.CachedIndicator;
import eu.verdelhan.ta4j.indicators.helpers.AverageTrueRangeIndicator;
import eu.verdelhan.ta4j.indicators.helpers.MaxPriceIndicator;
import eu.verdelhan.ta4j.indicators.helpers.MinPriceIndicator;

public class RandomWalkIndexHighIndicator
extends CachedIndicator<Decimal> {
    private final MaxPriceIndicator maxPrice;
    private final MinPriceIndicator minPrice;
    private final AverageTrueRangeIndicator averageTrueRange;
    private final Decimal sqrtTimeFrame;
    private final int timeFrame;

    public RandomWalkIndexHighIndicator(TimeSeries series, int timeFrame) {
        super(series);
        this.timeFrame = timeFrame;
        this.maxPrice = new MaxPriceIndicator(series);
        this.minPrice = new MinPriceIndicator(series);
        this.averageTrueRange = new AverageTrueRangeIndicator(series, timeFrame);
        this.sqrtTimeFrame = Decimal.valueOf(timeFrame).sqrt();
    }

    @Override
    protected Decimal calculate(int index) {
        return ((Decimal)this.maxPrice.getValue(index)).minus((Decimal)this.minPrice.getValue(Math.max(0, index - this.timeFrame))).dividedBy(((Decimal)this.averageTrueRange.getValue(index)).multipliedBy(this.sqrtTimeFrame));
    }
}

