/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators;

import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.indicators.CachedIndicator;

public abstract class RecursiveCachedIndicator<T>
extends CachedIndicator<T> {
    private static final int RECURSION_THRESHOLD = 100;

    public RecursiveCachedIndicator(TimeSeries series) {
        super(series);
    }

    public RecursiveCachedIndicator(Indicator indicator) {
        this(indicator.getTimeSeries());
    }

    @Override
    public T getValue(int index) {
        int removedTicksCount;
        int startIndex;
        int seriesEndIndex;
        TimeSeries series = this.getTimeSeries();
        if (series != null && index <= (seriesEndIndex = series.getEndIndex()) && index - (startIndex = Math.max(removedTicksCount = series.getRemovedTicksCount(), this.highestResultIndex)) > 100) {
            for (int prevIdx = startIndex; prevIdx < index; ++prevIdx) {
                super.getValue(prevIdx);
            }
        }
        return super.getValue(index);
    }
}

