/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.indicators.CachedIndicator;
import eu.verdelhan.ta4j.indicators.helpers.ClosePriceIndicator;
import eu.verdelhan.ta4j.indicators.helpers.HighestValueIndicator;
import eu.verdelhan.ta4j.indicators.helpers.LowestValueIndicator;
import eu.verdelhan.ta4j.indicators.helpers.MaxPriceIndicator;
import eu.verdelhan.ta4j.indicators.helpers.MinPriceIndicator;

public class StochasticOscillatorKIndicator
extends CachedIndicator<Decimal> {
    private final Indicator<Decimal> indicator;
    private final int timeFrame;
    private MaxPriceIndicator maxPriceIndicator;
    private MinPriceIndicator minPriceIndicator;

    public StochasticOscillatorKIndicator(TimeSeries timeSeries, int timeFrame) {
        this(new ClosePriceIndicator(timeSeries), timeFrame, new MaxPriceIndicator(timeSeries), new MinPriceIndicator(timeSeries));
    }

    public StochasticOscillatorKIndicator(Indicator<Decimal> indicator, int timeFrame, MaxPriceIndicator maxPriceIndicator, MinPriceIndicator minPriceIndicator) {
        super(indicator);
        this.indicator = indicator;
        this.timeFrame = timeFrame;
        this.maxPriceIndicator = maxPriceIndicator;
        this.minPriceIndicator = minPriceIndicator;
    }

    @Override
    protected Decimal calculate(int index) {
        HighestValueIndicator highestHigh = new HighestValueIndicator(this.maxPriceIndicator, this.timeFrame);
        LowestValueIndicator lowestMin = new LowestValueIndicator(this.minPriceIndicator, this.timeFrame);
        Decimal highestHighPrice = (Decimal)highestHigh.getValue(index);
        Decimal lowestLowPrice = (Decimal)lowestMin.getValue(index);
        return this.indicator.getValue(index).minus(lowestLowPrice).dividedBy(highestHighPrice.minus(lowestLowPrice)).multipliedBy(Decimal.HUNDRED);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " timeFrame: " + this.timeFrame;
    }
}

