/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.indicators.CachedIndicator;
import eu.verdelhan.ta4j.indicators.RSIIndicator;
import eu.verdelhan.ta4j.indicators.helpers.ClosePriceIndicator;
import eu.verdelhan.ta4j.indicators.helpers.HighestValueIndicator;
import eu.verdelhan.ta4j.indicators.helpers.LowestValueIndicator;

public class StochasticRSIIndicator
extends CachedIndicator<Decimal> {
    private final int timeFrame;
    private final RSIIndicator rsi;
    private final LowestValueIndicator minRsi;
    private final HighestValueIndicator maxRsi;

    public StochasticRSIIndicator(TimeSeries series, int timeFrame) {
        this(new ClosePriceIndicator(series), timeFrame);
    }

    public StochasticRSIIndicator(Indicator<Decimal> indicator, int timeFrame) {
        this(new RSIIndicator(indicator, timeFrame), timeFrame);
    }

    public StochasticRSIIndicator(RSIIndicator rsi, int timeFrame) {
        super(rsi);
        this.timeFrame = timeFrame;
        this.rsi = rsi;
        this.minRsi = new LowestValueIndicator(rsi, this.timeFrame);
        this.maxRsi = new HighestValueIndicator(rsi, this.timeFrame);
    }

    @Override
    protected Decimal calculate(int index) {
        Decimal minRsiValue = (Decimal)this.minRsi.getValue(index);
        return ((Decimal)this.rsi.getValue(index)).minus(minRsiValue).dividedBy(((Decimal)this.maxRsi.getValue(index)).minus(minRsiValue));
    }
}

