/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.indicators.CachedIndicator;
import eu.verdelhan.ta4j.indicators.helpers.HighestValueIndicator;

public class UlcerIndexIndicator
extends CachedIndicator<Decimal> {
    private Indicator<Decimal> indicator;
    private HighestValueIndicator highestValueInd;
    private int timeFrame;

    public UlcerIndexIndicator(Indicator<Decimal> indicator, int timeFrame) {
        super(indicator);
        this.indicator = indicator;
        this.timeFrame = timeFrame;
        this.highestValueInd = new HighestValueIndicator(indicator, timeFrame);
    }

    @Override
    protected Decimal calculate(int index) {
        int startIndex = Math.max(0, index - this.timeFrame + 1);
        int numberOfObservations = index - startIndex + 1;
        Decimal squaredAverage = Decimal.ZERO;
        for (int i = startIndex; i <= index; ++i) {
            Decimal currentValue = this.indicator.getValue(i);
            Decimal highestValue = (Decimal)this.highestValueInd.getValue(i);
            Decimal percentageDrawdown = currentValue.minus(highestValue).dividedBy(highestValue).multipliedBy(Decimal.HUNDRED);
            squaredAverage = squaredAverage.plus(percentageDrawdown.pow(2));
        }
        squaredAverage = squaredAverage.dividedBy(Decimal.valueOf(numberOfObservations));
        return squaredAverage.sqrt();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " timeFrame: " + this.timeFrame;
    }
}

