/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.candles;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Tick;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.indicators.CachedIndicator;
import eu.verdelhan.ta4j.indicators.SMAIndicator;
import eu.verdelhan.ta4j.indicators.candles.UpperShadowIndicator;

public class ThreeWhiteSoldiersIndicator
extends CachedIndicator<Boolean> {
    private final TimeSeries series;
    private final UpperShadowIndicator upperShadowInd;
    private final SMAIndicator averageUpperShadowInd;
    private final Decimal factor;
    private int blackCandleIndex = -1;

    public ThreeWhiteSoldiersIndicator(TimeSeries series, int timeFrame, Decimal factor) {
        super(series);
        this.series = series;
        this.upperShadowInd = new UpperShadowIndicator(series);
        this.averageUpperShadowInd = new SMAIndicator(this.upperShadowInd, timeFrame);
        this.factor = factor;
    }

    @Override
    protected Boolean calculate(int index) {
        if (index < 3) {
            return false;
        }
        this.blackCandleIndex = index - 3;
        return this.series.getTick(this.blackCandleIndex).isBearish() && this.isWhiteSoldier(index - 2) && this.isWhiteSoldier(index - 1) && this.isWhiteSoldier(index);
    }

    private boolean hasVeryShortUpperShadow(int index) {
        Decimal currentUpperShadow = (Decimal)this.upperShadowInd.getValue(index);
        Decimal averageUpperShadow = (Decimal)this.averageUpperShadowInd.getValue(this.blackCandleIndex);
        return currentUpperShadow.isLessThan(averageUpperShadow.multipliedBy(this.factor));
    }

    private boolean isGrowing(int index) {
        Tick prevTick = this.series.getTick(index - 1);
        Tick currTick = this.series.getTick(index);
        Decimal prevOpenPrice = prevTick.getOpenPrice();
        Decimal prevClosePrice = prevTick.getClosePrice();
        Decimal currOpenPrice = currTick.getOpenPrice();
        Decimal currClosePrice = currTick.getClosePrice();
        return currOpenPrice.isGreaterThan(prevOpenPrice) && currOpenPrice.isLessThan(prevClosePrice) && currClosePrice.isGreaterThan(prevClosePrice);
    }

    private boolean isWhiteSoldier(int index) {
        Tick prevTick = this.series.getTick(index - 1);
        Tick currTick = this.series.getTick(index);
        if (currTick.isBullish()) {
            if (prevTick.isBearish()) {
                return this.hasVeryShortUpperShadow(index) && currTick.getOpenPrice().isGreaterThan(prevTick.getMinPrice());
            }
            return this.hasVeryShortUpperShadow(index) && this.isGrowing(index);
        }
        return false;
    }
}

