/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.candles;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Tick;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.indicators.CachedIndicator;

public class UpperShadowIndicator
extends CachedIndicator<Decimal> {
    private final TimeSeries series;

    public UpperShadowIndicator(TimeSeries series) {
        super(series);
        this.series = series;
    }

    @Override
    protected Decimal calculate(int index) {
        Tick t = this.series.getTick(index);
        Decimal openPrice = t.getOpenPrice();
        Decimal closePrice = t.getClosePrice();
        if (closePrice.isGreaterThan(openPrice)) {
            return t.getMaxPrice().minus(closePrice);
        }
        return t.getMaxPrice().minus(openPrice);
    }
}

