/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.helpers;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.indicators.RecursiveCachedIndicator;
import eu.verdelhan.ta4j.indicators.helpers.TrueRangeIndicator;

public class AverageTrueRangeIndicator
extends RecursiveCachedIndicator<Decimal> {
    private final int timeFrame;
    private final TrueRangeIndicator tr;

    public AverageTrueRangeIndicator(TimeSeries series, int timeFrame) {
        super(series);
        this.timeFrame = timeFrame;
        this.tr = new TrueRangeIndicator(series);
    }

    @Override
    protected Decimal calculate(int index) {
        if (index == 0) {
            return Decimal.ONE;
        }
        Decimal nbPeriods = Decimal.valueOf(this.timeFrame);
        Decimal nbPeriodsMinusOne = Decimal.valueOf(this.timeFrame - 1);
        return ((Decimal)this.getValue(index - 1)).multipliedBy(nbPeriodsMinusOne).plus((Decimal)this.tr.getValue(index)).dividedBy(nbPeriods);
    }
}

