/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.helpers;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.indicators.CachedIndicator;

public class CumulatedGainsIndicator
extends CachedIndicator<Decimal> {
    private final Indicator<Decimal> indicator;
    private final int timeFrame;

    public CumulatedGainsIndicator(Indicator<Decimal> indicator, int timeFrame) {
        super(indicator);
        this.indicator = indicator;
        this.timeFrame = timeFrame;
    }

    @Override
    protected Decimal calculate(int index) {
        Decimal sumOfGains = Decimal.ZERO;
        for (int i = Math.max(1, index - this.timeFrame + 1); i <= index; ++i) {
            if (!this.indicator.getValue(i).isGreaterThan(this.indicator.getValue(i - 1))) continue;
            sumOfGains = sumOfGains.plus(this.indicator.getValue(i).minus(this.indicator.getValue(i - 1)));
        }
        return sumOfGains;
    }
}

