/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.helpers;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.indicators.CachedIndicator;

public class CumulatedLossesIndicator
extends CachedIndicator<Decimal> {
    private final Indicator<Decimal> indicator;
    private final int timeFrame;

    public CumulatedLossesIndicator(Indicator<Decimal> indicator, int timeFrame) {
        super(indicator);
        this.indicator = indicator;
        this.timeFrame = timeFrame;
    }

    @Override
    protected Decimal calculate(int index) {
        Decimal sumOfLosses = Decimal.ZERO;
        for (int i = Math.max(1, index - this.timeFrame + 1); i <= index; ++i) {
            if (!this.indicator.getValue(i).isLessThan(this.indicator.getValue(i - 1))) continue;
            sumOfLosses = sumOfLosses.plus(this.indicator.getValue(i - 1).minus(this.indicator.getValue(i)));
        }
        return sumOfLosses;
    }
}

