/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.helpers;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.indicators.CachedIndicator;

public class LowestValueIndicator
extends CachedIndicator<Decimal> {
    private final Indicator<Decimal> indicator;
    private final int timeFrame;

    public LowestValueIndicator(Indicator<Decimal> indicator, int timeFrame) {
        super(indicator);
        this.indicator = indicator;
        this.timeFrame = timeFrame;
    }

    @Override
    protected Decimal calculate(int index) {
        int start = Math.max(0, index - this.timeFrame + 1);
        Decimal lowest = this.indicator.getValue(start);
        for (int i = start + 1; i <= index; ++i) {
            if (!lowest.isGreaterThan(this.indicator.getValue(i))) continue;
            lowest = this.indicator.getValue(i);
        }
        return lowest;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " timeFrame: " + this.timeFrame;
    }
}

